/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

class SerializationHelper {
    static final String METADATA_FIELD = "metadata";

    SerializationHelper() {
    }

    static Map<String, Object> deserializeMetadata(ObjectMapper mapper, JsonNode parentNode) throws JsonProcessingException {
        JsonNode node = parentNode.findValue(METADATA_FIELD);
        if (node.isNull() || node.isEmpty()) {
            return Map.of();
        }
        if (!node.isObject()) {
            throw new IllegalStateException("Metadata must be an object");
        }
        return (Map)mapper.treeToValue((TreeNode)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    static void serializeMetadata(JsonGenerator gen, Map<String, Object> metadata) throws IOException {
        gen.writeObjectField(METADATA_FIELD, metadata);
    }
}

