/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.bsc.langgraph4j.action.Command;
import org.bsc.langgraph4j.utils.CollectionsUtils;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;

public class SpringAIToolService {
    private final List<ToolCallback> agentFunctions;

    public SpringAIToolService(List<ToolCallback> agentFunctions) {
        this.agentFunctions = agentFunctions;
    }

    public List<ToolCallback> agentFunctionsCallback() {
        return this.agentFunctions;
    }

    public Optional<ToolCallback> agentFunction(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return this.agentFunctions.stream().filter(tool -> Objects.equals(tool.getToolDefinition().name(), name)).findFirst();
    }

    public CompletableFuture<Command> executeFunctions(List<AssistantMessage.ToolCall> toolCalls, Map<String, Object> toolContextData, String propertyNameToUpdate) {
        if (propertyNameToUpdate == null) {
            return CompletableFuture.failedFuture(new NullPointerException("propertyName cannot be null"));
        }
        if (propertyNameToUpdate.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("propertyName cannot be empty"));
        }
        ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>(toolCalls.size());
        Map update = Map.of();
        String gotoNode = null;
        for (AssistantMessage.ToolCall toolCall : toolCalls) {
            Optional<ToolCallback> toolCallback = this.agentFunction(toolCall.name());
            if (toolCallback.isEmpty()) {
                return CompletableFuture.failedFuture(new IllegalStateException(String.format("No tool callback found for name: %s", toolCall.name())));
            }
            ScopedToolCallResult scopedToolTaskResult = this.scopedToolCall(toolCallback.get(), toolCall, toolContextData);
            Command command = scopedToolTaskResult.command();
            if (command.gotoNodeSafe().isPresent()) {
                if (gotoNode != null) {
                    return CompletableFuture.failedFuture(new IllegalStateException(String.format("Multiple nodes target provided! tried to set %s when %s was already present : ", command.gotoNode(), gotoNode)));
                }
                gotoNode = command.gotoNode();
            }
            update = CollectionsUtils.mergeMap((Map)update, (Map)command.update(), (v1, v2) -> v2);
            toolResponses.add(scopedToolTaskResult.toolResponse());
        }
        update = CollectionsUtils.mergeMap(update, Map.of(propertyNameToUpdate, new ToolResponseMessage(toolResponses)));
        return CompletableFuture.completedFuture(new Command(gotoNode, update));
    }

    public CompletableFuture<Command> executeFunctions(List<AssistantMessage.ToolCall> toolCalls, Map<String, Object> toolContextData) {
        return this.executeFunctions(toolCalls, toolContextData, "messages");
    }

    private ScopedToolCallResult scopedToolCall(ToolCallback toolCallback, AssistantMessage.ToolCall toolCall, Map<String, Object> toolContextData) {
        AtomicReference scopedCommandResult = new AtomicReference();
        Map context = CollectionsUtils.mergeMap(Objects.requireNonNull(toolContextData, "state cannot be null!"), Map.of("AtomicReference<Command>", scopedCommandResult), (v1, v2) -> v2);
        ToolContext toolContext = new ToolContext(context);
        String toolResult = toolCallback.call(toolCall.arguments(), toolContext);
        ToolResponseMessage.ToolResponse toolResponse = new ToolResponseMessage.ToolResponse(toolCall.id(), toolCall.name(), toolResult);
        return new ScopedToolCallResult(toolResponse, (Command)scopedCommandResult.get());
    }

    private record ScopedToolCallResult(ToolResponseMessage.ToolResponse toolResponse, Command command) {
        private final Command command;

        ScopedToolCallResult {
            Objects.requireNonNull(toolResponse, "response cannot be null");
        }

        public Command command() {
            return Optional.ofNullable(this.command).orElseGet(Command::emptyCommand);
        }
    }
}

