/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;

public class SpringAIToolService {
    private final List<ToolCallback> agentFunctions;

    public SpringAIToolService(List<ToolCallback> agentFunctions) {
        this.agentFunctions = agentFunctions;
    }

    public List<ToolCallback> agentFunctionsCallback() {
        return this.agentFunctions;
    }

    public Optional<ToolCallback> agentFunction(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return this.agentFunctions.stream().filter(tool -> Objects.equals(tool.getToolDefinition().name(), name)).findFirst();
    }

    public CompletableFuture<ToolResponseMessage> executeFunctions(List<AssistantMessage.ToolCall> toolCalls, Map<String, Object> toolContextMap) {
        CompletableFuture<ToolResponseMessage> result = new CompletableFuture<ToolResponseMessage>();
        ToolContext toolContext = new ToolContext(toolContextMap);
        ArrayList<ToolResponseMessage.ToolResponse> responses = new ArrayList<ToolResponseMessage.ToolResponse>();
        for (AssistantMessage.ToolCall toolCall : toolCalls) {
            String functionName = toolCall.name();
            Optional<ToolCallback> functionCallback = this.agentFunction(functionName);
            if (functionCallback.isEmpty()) {
                result.completeExceptionally(new IllegalStateException("No function callback found for function name: " + functionName));
                return result;
            }
            String functionResponse = functionCallback.get().call(toolCall.arguments(), toolContext);
            ToolResponseMessage.ToolResponse toolResponse = new ToolResponseMessage.ToolResponse(toolCall.id(), functionName, functionResponse);
            responses.add(toolResponse);
        }
        result.complete(new ToolResponseMessage(responses));
        return result;
    }

    public CompletableFuture<ToolResponseMessage> executeFunctions(List<AssistantMessage.ToolCall> toolCalls) {
        return this.executeFunctions(toolCalls, Map.of());
    }
}

