/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.SerializationHelper;
import org.springframework.ai.chat.messages.UserMessage;

public interface UserMessageHandler {

    public static class Deserializer
    extends StdDeserializer<UserMessage> {
        public Deserializer() {
            super(UserMessage.class);
        }

        public UserMessage deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode node = (ObjectNode)mapper.readTree(jsonParser);
            String text = node.findValue(Field.TEXT.name).asText();
            Map<String, Object> metadata = SerializationHelper.deserializeMetadata(mapper, (JsonNode)node);
            return UserMessage.builder().text(text).metadata(metadata).build();
        }
    }

    public static class Serializer
    extends StdSerializer<UserMessage> {
        public Serializer() {
            super(UserMessage.class);
        }

        public void serialize(UserMessage msg, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("@type", msg.getMessageType().name());
            gen.writeStringField(Field.TEXT.name, msg.getText());
            SerializationHelper.serializeMetadata(gen, msg.getMetadata());
            gen.writeEndObject();
        }
    }

    public static enum Field {
        TEXT("text"),
        MEDIA("media");

        final String name;

        private Field(String name) {
            this.name = name;
        }
    }
}

