/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.BigIntegers;

public class MPInteger
extends BCPGObject {
    private final BigInteger value;

    public MPInteger(BCPGInputStream in) throws IOException {
        boolean validateLength = false;
        this.value = MPInteger.readMPI(in, validateLength);
    }

    public MPInteger(BigInteger value) {
        if (value == null || value.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        StreamUtil.write2OctetLength(out, this.value.bitLength());
        BigIntegers.writeUnsignedByteArray((OutputStream)out, (BigInteger)this.value);
    }

    private static BigInteger readMPI(BCPGInputStream in, boolean validateLength) throws IOException {
        int bitLength = StreamUtil.read2OctetLength(in);
        int byteLength = (bitLength + 7) / 8;
        byte[] bytes = new byte[byteLength];
        in.readFully(bytes);
        BigInteger n = new BigInteger(1, bytes);
        if (validateLength && n.bitLength() != bitLength) {
            throw new IOException("malformed MPI");
        }
        return n;
    }
}

