/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAuthEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSAuthEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.mail.smime.MailcapUtil;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;

public class SMIMEAuthEnvelopedGenerator
extends SMIMEEnvelopedGenerator {
    public static final String AES128_GCM = CMSAuthEnvelopedDataGenerator.AES128_GCM;
    public static final String AES192_GCM = CMSAuthEnvelopedDataGenerator.AES192_GCM;
    public static final String AES256_GCM = CMSAuthEnvelopedDataGenerator.AES256_GCM;
    static final String AUTH_ENVELOPED_DATA_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=authEnveloped-data";
    private final AuthEnvelopedGenerator authFact = new AuthEnvelopedGenerator();

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) throws IllegalArgumentException {
        this.authFact.addRecipientInfoGenerator(recipientInfoGenerator);
    }

    public void setBerEncodeRecipients(boolean bl) {
        this.authFact.setBEREncodeRecipients(bl);
    }

    protected String getEncryptedContentType() {
        return AUTH_ENVELOPED_DATA_CONTENT_TYPE;
    }

    protected SMIMEStreamingProcessor getContentEncryptor(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) throws SMIMEException {
        if (outputEncryptor instanceof OutputAEADEncryptor) {
            return new ContentEncryptor(mimeBodyPart, (OutputAEADEncryptor)outputEncryptor);
        }
        throw new SMIMEException("encryptor is not AEAD encryptor");
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    CommandMap.setDefaultCommandMap((CommandMap)MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                return null;
            }
        });
    }

    private static class AuthEnvelopedGenerator
    extends CMSAuthEnvelopedDataStreamGenerator {
        private ASN1ObjectIdentifier dataType;
        private ASN1EncodableVector recipientInfos;

        private AuthEnvelopedGenerator() {
        }

        protected OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, ASN1EncodableVector aSN1EncodableVector, OutputAEADEncryptor outputAEADEncryptor) throws IOException {
            this.dataType = aSN1ObjectIdentifier;
            this.recipientInfos = aSN1EncodableVector;
            return super.open(aSN1ObjectIdentifier, outputStream, aSN1EncodableVector, outputAEADEncryptor);
        }

        OutputStream regenerate(OutputStream outputStream, OutputAEADEncryptor outputAEADEncryptor) throws IOException {
            return super.open(this.dataType, outputStream, this.recipientInfos, outputAEADEncryptor);
        }
    }

    private class ContentEncryptor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private OutputAEADEncryptor _encryptor;
        private boolean _firstTime = true;

        ContentEncryptor(MimeBodyPart mimeBodyPart, OutputAEADEncryptor outputAEADEncryptor) {
            this._content = mimeBodyPart;
            this._encryptor = outputAEADEncryptor;
        }

        public void write(OutputStream outputStream) throws IOException {
            try {
                OutputStream outputStream2;
                if (this._firstTime) {
                    outputStream2 = SMIMEAuthEnvelopedGenerator.this.authFact.open(outputStream, this._encryptor);
                    this._firstTime = false;
                } else {
                    outputStream2 = SMIMEAuthEnvelopedGenerator.this.authFact.regenerate(outputStream, this._encryptor);
                }
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    this._content.getDataHandler().setCommandMap((CommandMap)MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                this._content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new SMIMEEnvelopedGenerator.WrappingIOException(messagingException.toString(), messagingException);
            }
            catch (CMSException cMSException) {
                throw new SMIMEEnvelopedGenerator.WrappingIOException(cMSException.toString(), cMSException);
            }
        }
    }
}

