/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.paddings;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.OutputLengthException;
import org.bouncycastle.crypto.internal.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PaddedBufferedBlockCipher
extends DefaultBufferedBlockCipher {
    BlockCipherPadding padding;

    public PaddedBufferedBlockCipher(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this.cipher = blockCipher;
        this.padding = blockCipherPadding;
        this.buf = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.padding.init(parametersWithRandom.getRandom());
            this.cipher.init(bl, parametersWithRandom.getParameters());
        } else {
            if (bl) {
                this.padding.init(null);
            }
            this.cipher.init(bl, cipherParameters);
        }
    }

    @Override
    public int getOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = n2 % this.buf.length;
        if (n3 == 0) {
            if (this.forEncryption) {
                return n2 + this.buf.length;
            }
            return n2;
        }
        return n2 - n3 + this.buf.length;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = n2 % this.buf.length;
        if (!this.forEncryption && n3 == 0) {
            return Math.max(0, n2 - this.buf.length);
        }
        return n2 - n3;
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(this.buf, 0, byArray, n);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
        return n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.getBlockSize();
        int n5 = this.getUpdateOutputSize(n2);
        if (n5 > 0 && n3 + n5 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n6 = 0;
        int n7 = this.buf.length - this.bufOff;
        if (n2 > n7) {
            System.arraycopy(byArray, n, this.buf, this.bufOff, n7);
            n6 += this.cipher.processBlock(this.buf, 0, byArray2, n3);
            this.bufOff = 0;
            n2 -= n7;
            n += n7;
            while (n2 > this.buf.length) {
                n6 += this.cipher.processBlock(byArray, n, byArray2, n3 + n6);
                n2 -= n4;
                n += n4;
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        int n2 = this.cipher.getBlockSize();
        int n3 = 0;
        if (this.forEncryption) {
            if (this.bufOff == n2) {
                if (n + 2 * n2 > byArray.length) {
                    this.reset();
                    throw new OutputLengthException("output buffer too short");
                }
                n3 = this.cipher.processBlock(this.buf, 0, byArray, n);
                this.bufOff = 0;
            }
            this.padding.addPadding(this.buf, this.bufOff);
            n3 += this.cipher.processBlock(this.buf, 0, byArray, n + n3);
            this.reset();
        } else {
            if (this.bufOff != n2) {
                this.reset();
                throw new DataLengthException("last block incomplete in decryption");
            }
            n3 = this.cipher.processBlock(this.buf, 0, this.buf, 0);
            this.bufOff = 0;
            try {
                System.arraycopy(this.buf, 0, byArray, n, n3 -= this.padding.padCount(this.buf));
            }
            finally {
                this.reset();
            }
        }
        return n3;
    }
}

