/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DHValidationParameters {
    private int usageIndex;
    private byte[] seed;
    private int counter;

    public DHValidationParameters(byte[] byArray) {
        this(byArray, -1, -1);
    }

    public DHValidationParameters(byte[] byArray, int n) {
        this(byArray, n, -1);
    }

    public DHValidationParameters(byte[] byArray, int n, int n2) {
        this.seed = Arrays.clone(byArray);
        this.counter = n;
        this.usageIndex = n2;
    }

    public int getCounter() {
        return this.counter;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public int getUsageIndex() {
        return this.usageIndex;
    }

    public int hashCode() {
        int n = this.counter;
        n += 37 * Arrays.hashCode(this.seed);
        return n += 37 * this.usageIndex;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHValidationParameters)) {
            return false;
        }
        DHValidationParameters dHValidationParameters = (DHValidationParameters)object;
        if (dHValidationParameters.counter != this.counter) {
            return false;
        }
        if (dHValidationParameters.usageIndex != this.usageIndex) {
            return false;
        }
        return Arrays.areEqual(this.seed, dHValidationParameters.seed);
    }
}

