/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AgreedKeyWithMacKey
implements SecretKey {
    private SecretKey secretKey;
    private byte[] macKey;
    private String macAlgorithm;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isZeroed = new AtomicBoolean(false);

    public AgreedKeyWithMacKey(SecretKey secretKey) {
        this(secretKey, null, null);
    }

    public AgreedKeyWithMacKey(SecretKey secretKey, String string, byte[] byArray) {
        this.secretKey = secretKey;
        this.macKey = Arrays.clone(byArray);
        this.macAlgorithm = string;
    }

    @Override
    public String getAlgorithm() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getEncoded();
    }

    @Override
    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.secretKey = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SecretKey) {
            return this.secretKey.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }

    private byte[] getMacKeyBytes() {
        if (this.isZeroed.get()) {
            return null;
        }
        return this.macKey;
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        if (this.macKey == null) {
            return null;
        }
        return new ZeroizableSecretKey(){

            @Override
            public void zeroize() {
                AgreedKeyWithMacKey.this.isZeroed.set(true);
                if (AgreedKeyWithMacKey.this.macKey != null) {
                    Arrays.fill(AgreedKeyWithMacKey.this.macKey, (byte)0);
                }
            }

            @Override
            public void destroy() {
                this.zeroize();
            }

            @Override
            public boolean isDestroyed() {
                return AgreedKeyWithMacKey.this.isZeroed.get();
            }

            @Override
            public String getAlgorithm() {
                return AgreedKeyWithMacKey.this.macAlgorithm;
            }

            @Override
            public String getFormat() {
                return "RAW";
            }

            @Override
            public byte[] getEncoded() {
                return AgreedKeyWithMacKey.this.getMacKeyBytes();
            }
        };
    }
}

