/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.Gost3410KeyGenerationParameters;
import org.bouncycastle.crypto.general.Gost3410Parameters;
import org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Gost3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private Gost3410KeyGenerationParameters param;

    Gost3410KeyPairGenerator() {
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (Gost3410KeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        Gost3410Parameters gost3410Parameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = gost3410Parameters.getQ();
        BigInteger bigInteger3 = gost3410Parameters.getP();
        BigInteger bigInteger4 = gost3410Parameters.getA();
        while ((bigInteger = new BigInteger(256, secureRandom)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new Gost3410PublicKeyParameters(bigInteger5, gost3410Parameters), new Gost3410PrivateKeyParameters(bigInteger, gost3410Parameters));
    }
}

