/*
 * Copyright (c) 2010-2023. Axon Framework
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.axonframework.tracing;

/**
 * Represents the scope of a {@link Span}. This is attached to the thread, and should be closed
 * on the same thread as it was created before the span is ended.
 *
 * @author Mitchell Herrijgers
 * @since 4.6.5
 */
@FunctionalInterface
public interface SpanScope extends AutoCloseable {
    /**
     * Closes the scope of the Span on which it was opened.
     * <p/>
     * {@inheritDoc}
     */
    @Override
    void close();
}
