/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.AbstractUnitOfWork;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.MessageProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public abstract class DisruptorUnitOfWork<T extends Message<?>>
extends AbstractUnitOfWork<T> {
    private MessageProcessingContext<T> processingContext;

    public void reset(T message) {
        if (this.processingContext == null) {
            this.processingContext = new MessageProcessingContext(message);
        } else {
            this.processingContext.reset(message);
        }
        this.setPhase(UnitOfWork.Phase.NOT_STARTED);
        this.resources().clear();
        this.correlationDataProviders().clear();
    }

    public void pause() {
        CurrentUnitOfWork.clear((UnitOfWork)this);
    }

    public void resume() {
        CurrentUnitOfWork.set((UnitOfWork)this);
    }

    public Optional<UnitOfWork<?>> parent() {
        return Optional.empty();
    }

    public T getMessage() {
        return (T)this.processingContext.getMessage();
    }

    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.processingContext.transformMessage(transformOperator);
        return this;
    }

    protected void notifyHandlers(UnitOfWork.Phase phase) {
        this.processingContext.notifyHandlers((UnitOfWork)this, phase);
    }

    protected void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        this.processingContext.addHandler(phase, handler);
    }

    protected void setExecutionResult(ExecutionResult executionResult) {
        this.processingContext.setExecutionResult(executionResult);
    }

    protected void setRollbackCause(Throwable cause) {
        this.setExecutionResult(new ExecutionResult(GenericResultMessage.asResultMessage((Throwable)cause)));
    }

    public <R> ResultMessage<R> executeWithResult(Callable<R> task, @Nonnull RollbackConfiguration rollbackConfiguration) {
        throw new UnsupportedOperationException();
    }

    public ExecutionResult getExecutionResult() {
        return this.processingContext.getExecutionResult();
    }
}

