/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateLdapAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SurrogateAuthentication, module="ldap")
@AutoConfiguration
public class SurrogateLdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateLdapAuthenticationConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.surrogate.ldap.ldap-url");

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"surrogateLdapConnectionFactory"})
    public ConnectionFactory surrogateLdapConnectionFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (ConnectionFactory)BeanSupplier.of(ConnectionFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
            return LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)su.getLdap());
        }).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public SurrogateAuthenticationService surrogateAuthenticationService(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="surrogateLdapConnectionFactory") ConnectionFactory surrogateLdapConnectionFactory, CasConfigurationProperties casProperties) throws Exception {
        return (SurrogateAuthenticationService)BeanSupplier.of(SurrogateAuthenticationService.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
            LOGGER.debug("Using LDAP [{}] with baseDn [{}] to locate surrogate accounts", (Object)su.getLdap().getLdapUrl(), (Object)su.getLdap().getBaseDn());
            return new SurrogateLdapAuthenticationService(surrogateLdapConnectionFactory, su.getLdap(), servicesManager);
        }).otherwiseProxy().get();
    }
}

