/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.OAuth20TicketGrantingTicketAwareSecurityLogic;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="CasOAuth20ThrottleConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20ThrottleConfiguration {

    @Configuration(value="CasOAuth20ThrottleInterceptorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ThrottleInterceptorConfiguration {
        @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            SecurityInterceptor interceptor = new SecurityInterceptor(oauthSecConfig, "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
            interceptor.setMatchers("securityheaders");
            interceptor.setAuthorizers("isFullyAuthenticated");
            OAuth20TicketGrantingTicketAwareSecurityLogic logic = new OAuth20TicketGrantingTicketAwareSecurityLogic(ticketGrantingTicketCookieGenerator, ticketRegistry, centralAuthenticationService);
            interceptor.setSecurityLogic((SecurityLogic)logic);
            return interceptor;
        }

        @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAccessTokenInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            String clients = oauthSecConfig.getClients().findAllClients().stream().filter(client -> client instanceof DirectClient).map(Client::getName).collect(Collectors.joining(","));
            SecurityInterceptor interceptor = new SecurityInterceptor(oauthSecConfig, clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
            interceptor.setMatchers("securityheaders");
            interceptor.setAuthorizers("isFullyAuthenticated");
            DefaultSecurityLogic logic = new DefaultSecurityLogic();
            logic.setLoadProfilesFromSession(false);
            interceptor.setSecurityLogic((SecurityLogic)logic);
            return interceptor;
        }
    }

    @Configuration(value="CasOAuth20ThrottleMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ThrottleMvcConfiguration {
        @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor oauthHandlerInterceptorAdapter(@Qualifier(value="requiresAuthenticationAuthorizeInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor, @Qualifier(value="requiresAuthenticationAccessTokenInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators, ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors, @Qualifier(value="oauthDistributedSessionStore") ObjectProvider<SessionStore> oauthDistributedSessionStore, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager) {
            return new OAuth20HandlerInterceptorAdapter(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor, accessTokenGrantRequestExtractors, servicesManager, oauthDistributedSessionStore, oauthAuthorizationRequestValidators);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oauthWebMvcConfigurer(final @Qualifier(value="oauthHandlerInterceptorAdapter") ObjectProvider<HandlerInterceptor> oauthHandlerInterceptorAdapter) {
            return new WebMvcConfigurer(){

                public void addInterceptors(InterceptorRegistry registry) {
                    registry.addInterceptor((HandlerInterceptor)oauthHandlerInterceptorAdapter.getObject()).order(1).addPathPatterns(new String[]{"/oauth2.0".concat("/*")});
                }
            };
        }
    }

    @Configuration(value="CasOAuth20ThrottlePlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasOAuth20ThrottlePlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oauthThrottleWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oauthThrottleWebMvcConfigurer(final @Qualifier(value="authenticationThrottlingExecutionPlan") ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan) {
            return new WebMvcConfigurer(){

                public void addInterceptors(InterceptorRegistry registry) {
                    authenticationThrottlingExecutionPlan.ifAvailable(plan -> plan.getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).order(0).addPathPatterns(new String[]{"/oauth2.0".concat("/*")})));
                }
            };
        }
    }
}

