/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.ldap.services.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.ldap.services.DefaultLdapRegisteredServiceMapper;
import org.apereo.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.apereo.cas.adaptors.ldap.services.LdapServiceRegistry;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.serviceregistry.LdapServiceRegistryProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.ServiceRegistry, module="ldap")
@AutoConfiguration
public class LdapServiceRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapServiceRegistryConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.service-registry.ldap.ldap-url");

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapServiceRegistryMapper"})
    public LdapRegisteredServiceMapper ldapServiceRegistryMapper(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (LdapRegisteredServiceMapper)BeanSupplier.of(LdapRegisteredServiceMapper.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultLdapRegisteredServiceMapper(casProperties.getServiceRegistry().getLdap(), (StringSerializer<RegisteredService>)new RegisteredServiceJsonSerializer(applicationContext))).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapServiceRegistry"})
    public ServiceRegistry ldapServiceRegistry(@Qualifier(value="ldapServiceRegistryMapper") LdapRegisteredServiceMapper ldapServiceRegistryMapper, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners) throws Exception {
        return (ServiceRegistry)BeanSupplier.of(ServiceRegistry.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            LdapServiceRegistryProperties ldap = casProperties.getServiceRegistry().getLdap();
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            LOGGER.debug("Configured LDAP service registry search filter to [{}] and load filter to [{}]", (Object)ldap.getSearchFilter(), (Object)ldap.getLoadFilter());
            return new LdapServiceRegistry(connectionFactory, ldapServiceRegistryMapper, ldap, applicationContext, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new));
        }).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"ldapServiceRegistryExecutionPlanConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ServiceRegistryExecutionPlanConfigurer ldapServiceRegistryExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="ldapServiceRegistry") ServiceRegistry ldapServiceRegistry) throws Exception {
        return (ServiceRegistryExecutionPlanConfigurer)BeanSupplier.of(ServiceRegistryExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerServiceRegistry(ldapServiceRegistry)).otherwiseProxy().get();
    }
}

