/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.ldap.services;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.apereo.cas.configuration.model.support.ldap.serviceregistry.LdapServiceRegistryProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultLdapRegisteredServiceMapper
implements LdapRegisteredServiceMapper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapRegisteredServiceMapper.class);
    private final LdapServiceRegistryProperties ldap;
    private final StringSerializer<RegisteredService> jsonSerializer;

    @Override
    public LdapEntry mapFromRegisteredService(String dn, RegisteredService svc) {
        if (svc.getId() == -1L) {
            long id = System.currentTimeMillis();
            svc.setId(id);
        }
        String newDn = this.getDnForRegisteredService(dn, svc);
        LOGGER.debug("Creating entry DN [{}]", (Object)newDn);
        ArrayList<LdapAttribute> attrs = new ArrayList<LdapAttribute>(3);
        attrs.add(new LdapAttribute(this.ldap.getIdAttribute(), new String[]{String.valueOf(svc.getId())}));
        return (LdapEntry)FunctionUtils.doUnchecked(() -> {
            try (StringWriter writer = new StringWriter();){
                this.jsonSerializer.to((Writer)writer, (Object)svc);
                String defn = writer.toString();
                attrs.add(new LdapAttribute(this.ldap.getServiceDefinitionAttribute(), new String[]{defn}));
                attrs.add(new LdapAttribute("objectClass", new String[]{"top", this.ldap.getObjectClass()}));
            }
            LOGGER.debug("LDAP attributes assigned to the DN [{}] are [{}]", (Object)newDn, (Object)attrs);
            LdapEntry entry = (LdapEntry)LdapEntry.builder().dn(newDn).attributes((Collection)attrs).build();
            LOGGER.debug("Constructed LDAP entry [{}]", (Object)entry);
            return entry;
        });
    }

    @Override
    public RegisteredService mapToRegisteredService(LdapEntry entry) {
        String value = LdapUtils.getString((LdapEntry)entry, (String)this.ldap.getServiceDefinitionAttribute());
        if (StringUtils.hasText((String)value)) {
            LOGGER.debug("Transforming LDAP entry [{}] into registered service definition", (Object)entry);
            return (RegisteredService)this.jsonSerializer.from(value);
        }
        LOGGER.warn("LDAP entry [{}] is not assigned the service definition attribute [{}] and will be ignored", (Object)entry, (Object)this.ldap.getServiceDefinitionAttribute());
        return null;
    }

    @Override
    public String getObjectClass() {
        return this.ldap.getObjectClass();
    }

    @Override
    public String getIdAttribute() {
        return this.ldap.getIdAttribute();
    }

    @Override
    public String getDnForRegisteredService(String parentDn, RegisteredService svc) {
        return String.format("%s=%s,%s", this.ldap.getIdAttribute(), svc.getId(), parentDn);
    }

    @Generated
    public DefaultLdapRegisteredServiceMapper(LdapServiceRegistryProperties ldap, StringSerializer<RegisteredService> jsonSerializer) {
        this.ldap = ldap;
        this.jsonSerializer = jsonSerializer;
    }
}

