/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.geo.google;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import java.net.InetAddress;
import java.util.Arrays;
import lombok.Generated;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.support.geo.AbstractGeoLocationService;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMapsGeoLocationService
extends AbstractGeoLocationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleMapsGeoLocationService.class);
    private final GeoApiContext context;

    public GeoLocationResponse locate(InetAddress address) {
        return this.locate(address.getHostAddress());
    }

    public GeoLocationResponse locate(Double latitude, Double longitude) {
        if (latitude == null || longitude == null) {
            LOGGER.debug("latitude/longitude must not be null in order for geolocation to proceed");
            return null;
        }
        GeoLocationResponse r = new GeoLocationResponse();
        r.setLatitude(latitude.doubleValue());
        r.setLongitude(longitude.doubleValue());
        LatLng latlng = new LatLng(latitude.doubleValue(), longitude.doubleValue());
        try {
            GeocodingResult[] results = this.reverseGeocode(latlng);
            if (results != null && results.length > 0) {
                Arrays.stream(results).map(result -> result.formattedAddress).forEach(arg_0 -> ((GeoLocationResponse)r).addAddress(arg_0));
                return r;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return r;
    }

    protected GeocodingResult[] reverseGeocode(LatLng latlng) throws Exception {
        return (GeocodingResult[])GeocodingApi.reverseGeocode((GeoApiContext)this.context, (LatLng)latlng).await();
    }

    @Generated
    public GoogleMapsGeoLocationService(GeoApiContext context) {
        this.context = context;
    }
}

