/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.geo.config;

import com.google.maps.GaeRequestHandler;
import com.google.maps.GeoApiContext;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.geo.googlemaps.GoogleMapsProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.geo.google.GoogleMapsGeoLocationService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasGeoLocationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class GoogleMapsGeoCodingConfiguration {
    @ConditionalOnMissingBean(name={"geoLocationService"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public GeoLocationService geoLocationService(CasConfigurationProperties casProperties) {
        GeoApiContext.Builder builder = new GeoApiContext.Builder();
        GoogleMapsProperties properties = casProperties.getGoogleMaps();
        if (properties.isGoogleAppsEngine()) {
            builder.requestHandlerBuilder((GeoApiContext.RequestHandler.Builder)new GaeRequestHandler.Builder());
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getClientId()) && StringUtils.isNotBlank((CharSequence)properties.getClientSecret())) {
            builder.enterpriseCredentials(properties.getClientId(), properties.getClientSecret());
        }
        builder.apiKey(properties.getApiKey()).connectTimeout(Beans.newDuration((String)properties.getConnectTimeout()).toMillis(), TimeUnit.MILLISECONDS);
        return new GoogleMapsGeoLocationService(builder.build());
    }
}

