/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.helper.XSDHelper;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sdo.SDOExtendedMetaData;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.SDOExtendedMetaDataImpl;
import org.apache.tuscany.sdo.model.internal.InternalFactory;
import org.apache.tuscany.sdo.model.internal.impl.InternalFactoryImpl;
import org.apache.tuscany.sdo.util.StAX2SAXAdapter;
import org.apache.tuscany.sdo.util.resource.ChangeSummaryStreamDeserializer;
import org.apache.tuscany.sdo.util.resource.ChangeSummaryStreamSerializer;
import org.apache.tuscany.sdo.util.resource.RecordedEventXMLStreamReader;
import org.apache.tuscany.sdo.util.resource.XMLDocumentStreamReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLOptions;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.emf.ecore.xmi.util.DefaultEcoreBuilder;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SDOXMLResourceImpl
extends XMLResourceImpl {
    private XMLStreamReader reader;
    public EObject root;
    protected static int loadLaxForm;
    ChangeSummaryStreamSerializer changeSummarySerializer;
    static final String INDENT = "  ";
    static final String LINE_SEPARATOR;
    static final char MARK = '\n';
    static final String LINE_BREAK;

    public SDOXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        return new SDOXMLHelperImpl((XMLResource)this, this.reader);
    }

    protected XMLLoad createXMLLoad() {
        return new SDOXMLLoadImpl(this.createXMLHelper());
    }

    public void doLoad(InputSource inputSource, Map options) throws IOException {
        if (options != null) {
            Object option = options.get("load malform");
            int tolerance = option == null ? loadLaxForm : ((Number)option).intValue();
            option = options.get("EXTENDED_META_DATA");
            if (tolerance == 0) {
                if (option instanceof SDOExtendedMetaData) {
                    ((SDOExtendedMetaData)option).setFeatureNamespaceMatchingLax(false);
                }
            } else if (option instanceof SDOExtendedMetaData) {
                ((SDOExtendedMetaData)option).setFeatureNamespaceMatchingLax(true);
            } else {
                option = new SDOExtendedMetaDataImpl();
                options.put("EXTENDED_META_DATA", option);
            }
            if (Boolean.TRUE.equals(options.get("ProcessSchemaLocations"))) {
                XSDHelper xsdHelper;
                ExtendedMetaData extendedMetaData;
                XMLOptions xmlOptions = (XMLOptions)options.get("XML_OPTIONS");
                if (xmlOptions == null) {
                    xmlOptions = new XMLOptionsImpl();
                    options.put("XML_OPTIONS", xmlOptions);
                }
                xmlOptions.setProcessSchemaLocations(true);
                if (option == null) {
                    option = this.getDefaultLoadOptions().get("EXTENDED_META_DATA");
                }
                if (option == null) {
                    extendedMetaData = ExtendedMetaData.INSTANCE;
                    xsdHelper = XSDHelper.INSTANCE;
                } else {
                    extendedMetaData = (ExtendedMetaData)option;
                    xsdHelper = new HelperContextImpl(extendedMetaData, false).getXSDHelper();
                }
                xmlOptions.setEcoreBuilder((EcoreBuilder)new DefaultEcoreBuilder(extendedMetaData){

                    public Collection generate(Map targetNamespaceToURI) throws IOException {
                        Iterator iterator = targetNamespaceToURI.values().iterator();
                        while (iterator.hasNext()) {
                            String uri = iterator.next().toString();
                            xsdHelper.define(uri.indexOf(":/") == -1 ? Thread.currentThread().getContextClassLoader().getResourceAsStream(uri) : new URL(uri).openStream(), uri);
                        }
                        return null;
                    }
                });
            }
            if (Boolean.TRUE.equals(options.get("load unknown properties"))) {
                options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            }
        } else if (loadLaxForm != 0) {
            options = new HashMap<String, Object>();
            options.put("EXTENDED_META_DATA", new SDOExtendedMetaDataImpl());
        }
        super.doLoad(inputSource, options);
    }

    public void load(XMLStreamReader reader, Map options) throws IOException {
        this.reader = reader;
        SDOXMLLoadImpl xmlLoad = (SDOXMLLoadImpl)this.createXMLLoad();
        HashMap mergedOptions = new HashMap(this.defaultLoadOptions);
        if (options != null) {
            mergedOptions.putAll(options);
        }
        xmlLoad.load((XMLResource)this, reader, mergedOptions);
    }

    protected XMLSave createXMLSave() {
        return new SDOXMLSaveImpl(this.createXMLHelper());
    }

    static {
        int defaultLaxForm = 16962;
        String property = System.getProperty("XML.load.form.lax");
        if (property == null) {
            loadLaxForm = defaultLaxForm;
        } else {
            try {
                loadLaxForm = Integer.decode(property);
            }
            catch (NumberFormatException eNumberFormat) {
                loadLaxForm = defaultLaxForm;
            }
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
        LINE_BREAK = new String(new char[]{'\n'});
    }

    final class SDOXMLSaveImpl
    extends XMLSaveImpl {
        Map changeSummaryOptions;
        String indent;
        String margin;
        XMLStreamWriter xmlStreamWriter;

        SDOXMLSaveImpl(XMLHelper helper) {
            super(helper);
            this.changeSummaryOptions = new HashMap();
            this.indent = SDOXMLResourceImpl.INDENT;
        }

        XmlString doc(XMLResource resource, Map options) {
            if (this.doc instanceof XmlString) {
                return (XmlString)this.doc;
            }
            Object lineWidth = options.get("LINE_WIDTH");
            int width = lineWidth == null ? Integer.MAX_VALUE : ((Number)lineWidth).intValue();
            XmlString d = resource != null && Boolean.TRUE.equals(options.get("SAVE_DOCTYPE")) ? new XmlString(width, resource.getPublicId(), resource.getSystemId(), this.doc.getTemporaryFileName()) : new XmlString(width, this.doc.getTemporaryFileName());
            this.doc = d;
            return d;
        }

        protected void init(XMLResource resource, Map options) {
            super.init(resource, options);
            int unformat = 0;
            String lineBreak = (String)options.get("LineBreak");
            if (lineBreak == null) {
                this.changeSummaryOptions.put("LineBreak", LINE_BREAK);
            } else if (lineBreak.length() == 0) {
                ++unformat;
            } else {
                this.changeSummaryOptions.put("LineBreak", LINE_BREAK);
                if (lineBreak.equals(LINE_SEPARATOR)) {
                    lineBreak = null;
                }
            }
            String indent = (String)options.get("indent");
            if (indent == null) {
                this.changeSummaryOptions.put("indent", SDOXMLResourceImpl.INDENT);
            } else if (indent.length() == 0) {
                ++unformat;
            } else {
                this.indent = indent;
                this.changeSummaryOptions.put("indent", this.indent);
                if (indent.equals(SDOXMLResourceImpl.INDENT)) {
                    indent = null;
                }
            }
            String margin = (String)options.get("margin");
            if (margin == null || margin.length() == 0) {
                if (unformat == 2) {
                    this.doc.setUnformatted(true);
                } else if (lineBreak != null) {
                    XmlString d = this.doc(resource, options);
                    d.setLineBreak(lineBreak);
                    if (indent != null) {
                        d.indent = indent;
                    }
                } else if (indent != null) {
                    this.doc((XMLResource)resource, (Map)options).indent = indent;
                }
                this.margin = this.indent;
            } else {
                XmlString d = this.doc(resource, options);
                d.margin(margin);
                if (lineBreak != null) {
                    d.setLineBreak(lineBreak);
                }
                if (indent != null) {
                    d.indent = indent;
                }
                this.margin = margin + this.indent;
                if (!this.toDOM && this.declareXML) {
                    d.add(margin);
                }
            }
            this.changeSummaryOptions.put("EXTENDED_META_DATA", this.extendedMetaData);
        }

        QName qName(EStructuralFeature f) {
            if (this.extendedMetaData == null) {
                return new LocalName(f.getName());
            }
            String nameSpace = this.extendedMetaData.getNamespace(f);
            String name = this.extendedMetaData.getName(f);
            return nameSpace == null ? new LocalName(name) : new QName(nameSpace, name);
        }

        void saveChangeSummary(EObject o, EStructuralFeature f, Object changeSummary) {
            boolean notMixed;
            if (this.doc instanceof XmlString) {
                notMixed = !((XmlString)this.doc).mixed();
            } else if (this.extendedMetaData == null) {
                notMixed = true;
            } else {
                switch (this.extendedMetaData.getContentKind(o.eClass())) {
                    case 2: 
                    case 3: {
                        notMixed = false;
                        break;
                    }
                    default: {
                        notMixed = true;
                    }
                }
            }
            if (notMixed) {
                EObject grandContainer;
                StringBuffer margin = new StringBuffer(this.margin);
                EObject container = o.eContainer();
                while ((grandContainer = container.eContainer()) != null) {
                    margin.append(this.indent);
                    container = grandContainer;
                }
                this.changeSummaryOptions.put("margin", margin.toString());
            }
            try {
                if (this.xmlStreamWriter == null) {
                    this.xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(new Writer(){

                        public void close() {
                        }

                        public void flush() {
                        }

                        protected final void add(char[] cbuf, int index, int off) {
                            SDOXMLSaveImpl.this.doc.addText(new String(cbuf, index, off - index));
                        }

                        public void write(char[] cbuf, int off, int len) {
                            block8: {
                                if (len == 0) break block8;
                                while (true) {
                                    block9: {
                                        block7: {
                                            if (cbuf[off] == '\n') {
                                                SDOXMLSaveImpl.this.doc.addLine();
                                                if (--len == 0) {
                                                    return;
                                                }
                                                ++off;
                                                continue;
                                            }
                                            int index = off;
                                            do {
                                                ++off;
                                                if (--len != 0) continue;
                                                this.add(cbuf, index, off);
                                                break block7;
                                            } while (cbuf[off] != '\n');
                                            this.add(cbuf, index, off);
                                            SDOXMLSaveImpl.this.doc.addLine();
                                            if (--len != 0) break block9;
                                        }
                                        return;
                                    }
                                    ++off;
                                }
                            }
                        }
                    });
                    this.xmlStreamWriter.setNamespaceContext(new SDOXMLHelperImpl.NameSpaceContext((SDOXMLHelperImpl)this.helper){
                        {
                            SDOXMLHelperImpl sDOXMLHelperImpl = x0;
                            ((Object)((Object)sDOXMLHelperImpl)).getClass();
                        }

                        public String getNamespaceURI(String prefix) {
                            return SDOXMLSaveImpl.this.declareXSI && "xsi".equals(prefix) ? "http://www.w3.org/2001/XMLSchema-instance" : super.getNamespaceURI(prefix);
                        }

                        public String getPrefix(String namespaceURI) {
                            return SDOXMLSaveImpl.this.declareXSI && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) ? "xsi" : super.getPrefix(namespaceURI);
                        }

                        public Iterator getPrefixes(String namespaceURI) {
                            final Iterator iterator = super.getPrefixes(namespaceURI);
                            return "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) ? new Iterator(){
                                boolean first = true;

                                public boolean hasNext() {
                                    if (this.first) {
                                        if (SDOXMLSaveImpl.this.declareXSI) {
                                            return true;
                                        }
                                        this.first = false;
                                    }
                                    return iterator.hasNext();
                                }

                                public Object next() {
                                    if (this.first) {
                                        this.first = false;
                                        if (SDOXMLSaveImpl.this.declareXSI) {
                                            return "xsi";
                                        }
                                    }
                                    return iterator.next();
                                }

                                public void remove() {
                                    if (this.first) {
                                        SDOXMLSaveImpl.this.declareXSI = false;
                                    } else {
                                        iterator.remove();
                                    }
                                }
                            } : iterator;
                        }
                    });
                    Iterator iterator = this.helper.getPrefixToNamespaceMap().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        this.xmlStreamWriter.setPrefix((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (this.declareXSI) {
                        this.xmlStreamWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    }
                    if (SDOXMLResourceImpl.this.changeSummarySerializer == null) {
                        SDOXMLResourceImpl.this.changeSummarySerializer = new ChangeSummaryStreamSerializer();
                    }
                }
                SDOXMLResourceImpl.this.changeSummarySerializer.saveChangeSummary((ChangeSummary)changeSummary, this.qName(f), this.xmlStreamWriter, this.changeSummaryOptions);
                if (notMixed) {
                    this.doc.addLine();
                }
            }
            catch (XMLStreamException e) {
                this.xmlResource.getErrors().add((Object)new XMIException((Exception)e));
            }
        }

        protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
            if (f.getEType() == ChangeSummaryStreamSerializer.ChangeSummary_TYPE) {
                this.saveChangeSummary(o, f, this.helper.getValue(o, f));
            } else {
                super.saveDataTypeElementSingle(o, f);
            }
        }

        protected boolean saveElementFeatureMap(EObject o, EStructuralFeature f) {
            List values = (List)this.helper.getValue(o, f);
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String stringValue;
                FeatureMap.Entry entry = (FeatureMap.Entry)values.get(i);
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                Object value = entry.getValue();
                if (entryFeature instanceof EReference) {
                    if (value == null) {
                        this.saveNil(o, entryFeature);
                        continue;
                    }
                    EReference referenceEntryFeature = (EReference)entryFeature;
                    if (referenceEntryFeature.isContainment()) {
                        this.saveElement((InternalEObject)value, entryFeature);
                        continue;
                    }
                    if (referenceEntryFeature.isResolveProxies()) {
                        this.saveFeatureMapElementReference((EObject)value, referenceEntryFeature);
                        continue;
                    }
                    this.saveElementIDRef(o, (EObject)value, entryFeature);
                    continue;
                }
                if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                    String svalue = value.toString();
                    if (this.escape != null) {
                        svalue = this.escape.convertText(svalue);
                    }
                    if (!this.toDOM) {
                        this.doc.addText(svalue);
                        continue;
                    }
                    Text text = this.document.createTextNode(svalue);
                    this.currentNode.appendChild(text);
                    this.handler.recordValues((Node)text, o, f, (Object)entry);
                    continue;
                }
                if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA()) {
                    stringValue = value.toString();
                    if (this.escape != null) {
                        stringValue = this.escape.convertLines(stringValue);
                    }
                    if (!this.toDOM) {
                        this.doc.addCDATA(stringValue);
                        continue;
                    }
                    CDATASection cdata = this.document.createCDATASection(stringValue);
                    this.currentNode.appendChild(cdata);
                    this.handler.recordValues((Node)cdata, o, f, (Object)entry);
                    continue;
                }
                if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment()) {
                    stringValue = value.toString();
                    if (this.escape != null) {
                        stringValue = this.escape.convertLines(stringValue);
                    }
                    if (!this.toDOM) {
                        this.doc.addComment(stringValue);
                        continue;
                    }
                    this.currentNode.appendChild(this.document.createComment(stringValue));
                    continue;
                }
                this.saveElement(o, value, entryFeature);
            }
            return size > 0;
        }

        protected final void saveElement(EObject o, Object value, EStructuralFeature f) {
            if (f.getEType() == ChangeSummaryStreamSerializer.ChangeSummary_TYPE) {
                this.saveChangeSummary(o, f, value);
                return;
            }
            if (value == null) {
                this.saveNil(o, f);
            } else {
                String svalue = this.getDatatypeValue(value, f, false);
                if (!this.toDOM) {
                    this.doc.saveDataValueElement(this.helper.getQName(f), svalue);
                } else {
                    this.helper.populateNameInfo(this.nameInfo, f);
                    Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                    Text text = this.document.createTextNode(svalue);
                    elem.appendChild(text);
                    this.currentNode.appendChild(elem);
                    this.handler.recordValues((Node)elem, o, f, value);
                    this.handler.recordValues((Node)text, o, f, value);
                }
            }
        }
    }

    static final class XmlString
    extends XMLString {
        String indent = "  ";

        XmlString(int lineWidth, String temporaryFileName) {
            super(lineWidth, temporaryFileName);
        }

        XmlString(int lineWidth, String publicId, String systemId, String temporaryFileName) {
            super(lineWidth, publicId, systemId, temporaryFileName);
        }

        void setLineBreak(String lineBreak) {
            this.lineSeparator = lineBreak;
        }

        void margin(String margin) {
            this.indents.set(0, margin);
        }

        protected String getElementIndent(int extra) {
            int nesting = this.depth + extra - 1;
            for (int i = this.indents.size() - 1; i < nesting; ++i) {
                this.indents.add(this.indents.get(i) + this.indent);
            }
            return (String)this.indents.get(nesting);
        }

        protected String getAttributeIndent() {
            return this.getElementIndent();
        }

        public final boolean mixed() {
            return this.isMixed;
        }

        public void reset(String publicId, String systemId, int lineWidth, String temporaryFileName) {
            super.reset(publicId, systemId, lineWidth, temporaryFileName);
            this.setLineBreak(LINE_SEPARATOR);
            this.indent = SDOXMLResourceImpl.INDENT;
        }
    }

    private static final class LocalName
    extends QName {
        private LocalName(String name) {
            super(name);
        }

        public String getNamespaceURI() {
            return null;
        }
    }

    public class SDOXMLLoadImpl
    extends XMLLoadImpl {
        public SDOXMLLoadImpl(XMLHelper helper) {
            super(helper);
        }

        protected DefaultHandler makeDefaultHandler() {
            return new XmlHandler();
        }

        public void load(XMLResource resource, final XMLStreamReader reader, Map options) throws IOException {
            this.resource = resource;
            HashMap mergedOptions = new HashMap(SDOXMLResourceImpl.this.defaultLoadOptions);
            if (options != null) {
                mergedOptions.putAll(options);
            }
            this.options = mergedOptions;
            final DefaultHandler handler = this.makeDefaultHandler();
            if (SDOXMLResourceImpl.this.errors != null) {
                SDOXMLResourceImpl.this.errors.clear();
            }
            final StAX2SAXAdapter adapter = new StAX2SAXAdapter(true);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws XMLStreamException, SAXException {
                        adapter.parse(reader, handler);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new Resource.IOWrappedException(e.getException());
            }
            this.helper = null;
            if (!resource.getErrors().isEmpty()) {
                XMIException exception;
                Exception error = (Exception)resource.getErrors().get(0);
                if (error instanceof XMIException && (exception = (XMIException)error).getWrappedException() != null) {
                    throw new Resource.IOWrappedException(exception.getWrappedException());
                }
                throw new Resource.IOWrappedException(error);
            }
        }

        final class XmlHandler
        extends SAXXMLHandler {
            protected RecordedEventXMLStreamReader.Tag tag;
            protected List nameSpaces;
            protected Collection changeSummaryDeserializers;

            XmlHandler() {
                super(SDOXMLLoadImpl.this.resource, SDOXMLLoadImpl.this.helper, SDOXMLLoadImpl.this.options);
            }

            protected void handleTopLocations(String prefix, String name) {
                this.processSchemaLocations(prefix, name);
                if (!this.processAnyXML) {
                    return;
                }
                String nameSpace = this.helper.getURI(prefix);
                if (this.extendedMetaData.getPackage(nameSpace) == null) {
                    if (SDOXMLLoadImpl.this.options.get("default root type") == null) {
                        this.extendedMetaData.demandFeature(nameSpace, name, true);
                    } else {
                        this.extendedMetaData.demandPackage(nameSpace);
                    }
                }
            }

            EClassifier defaultRootType(String prefix, String name, boolean isElement, EObject peekObject, String value) {
                Object type = SDOXMLLoadImpl.this.options.get("default root type");
                if (type != null) {
                    return (EClassifier)type;
                }
                super.handleUnknownFeature(prefix, name, isElement, peekObject, value);
                return null;
            }

            protected void handleUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value) {
                if (this.objects.size() == 1) {
                    EFactory eFactory;
                    EClassifier type;
                    String typeQName = this.getXSIType();
                    if (typeQName == null) {
                        type = this.defaultRootType(prefix, name, isElement, peekObject, value);
                        if (type == null) {
                            return;
                        }
                        eFactory = type.getEPackage().getEFactoryInstance();
                    } else {
                        String typeName = null;
                        String xsiPrefix = "";
                        int index = typeQName.indexOf(":");
                        if (index > 0) {
                            xsiPrefix = typeQName.substring(0, index);
                            typeName = typeQName.substring(index + 1);
                        } else {
                            typeName = typeQName;
                        }
                        eFactory = this.getFactoryForPrefix(xsiPrefix);
                        if (eFactory != null) {
                            type = this.helper.getType(eFactory, typeName);
                        } else if ("".equals(xsiPrefix) && this.helper.getURI(xsiPrefix) == null) {
                            EPackage ePackage = this.handleMissingPackage(null);
                            if (ePackage == null) {
                                type = this.defaultRootType(prefix, name, isElement, peekObject, value);
                                if (type == null) {
                                    return;
                                }
                                eFactory = type.getEPackage().getEFactoryInstance();
                            } else {
                                eFactory = ePackage.getEFactoryInstance();
                                type = this.helper.getType(eFactory, typeName);
                            }
                        } else {
                            type = this.defaultRootType(prefix, name, isElement, peekObject, value);
                            if (type == null) {
                                return;
                            }
                            eFactory = type.getEPackage().getEFactoryInstance();
                        }
                    }
                    ((SDOXMLLoadImpl)SDOXMLLoadImpl.this).SDOXMLResourceImpl.this.root = this.helper.createObject(eFactory, type);
                    if (((SDOXMLLoadImpl)SDOXMLLoadImpl.this).SDOXMLResourceImpl.this.root != null) {
                        if (this.disableNotify) {
                            ((SDOXMLLoadImpl)SDOXMLLoadImpl.this).SDOXMLResourceImpl.this.root.eSetDeliver(false);
                        }
                        this.handleObjectAttribs(((SDOXMLLoadImpl)SDOXMLLoadImpl.this).SDOXMLResourceImpl.this.root);
                        this.processObject(((SDOXMLLoadImpl)SDOXMLLoadImpl.this).SDOXMLResourceImpl.this.root);
                        return;
                    }
                }
                super.handleUnknownFeature(prefix, name, isElement, peekObject, value);
            }

            public void startPrefixMapping(String prefix, String uri) {
                if (this.nameSpaces == null) {
                    this.nameSpaces = new ArrayList();
                }
                RecordedEventXMLStreamReader.Tag.bind(prefix, uri, this.nameSpaces);
                if (this.tag == null) {
                    super.startPrefixMapping(prefix, uri);
                }
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String prefix;
                EStructuralFeature feature;
                if (this.tag != null) {
                    this.tag.start(uri, localName, qName, attributes, this.locator, this.nameSpaces);
                    this.nameSpaces = null;
                    return;
                }
                EObject peekObject = this.objects.peekEObject();
                if (peekObject != null && (feature = this.getFeature(peekObject, (prefix = this.helper.getPrefix(uri.length() == 0 ? null : uri)) == null ? "" : prefix, localName, true)) != null && feature.getEType() == ChangeSummaryStreamSerializer.ChangeSummary_TYPE) {
                    this.tag = new RecordedEventXMLStreamReader.Tag(uri, localName, prefix, attributes, this.locator, ((SDOXMLHelperImpl)this.helper).nameSpaceContext(), this.nameSpaces);
                    this.nameSpaces = null;
                    return;
                }
                if (this.nameSpaces != null) {
                    this.nameSpaces.clear();
                }
                super.startElement(uri, localName, qName, attributes);
            }

            public void characters(char[] ch, int start, int length) {
                if (this.tag == null) {
                    super.characters(ch, start, length);
                } else {
                    this.tag.text(4, new String(ch, start, length), this.locator);
                }
            }

            public void endElement(String uri, String localName, String qName) {
                if (this.tag == null) {
                    super.endElement(uri, localName, qName);
                } else if (this.tag.end(uri, localName, qName, this.locator)) {
                    if (this.changeSummaryDeserializers == null) {
                        this.changeSummaryDeserializers = new ArrayList();
                    }
                    ChangeSummaryStreamDeserializer changeSummaryDeserializer = new ChangeSummaryStreamDeserializer();
                    try {
                        changeSummaryDeserializer.begin((DataObject)this.objects.peekEObject(), new HelperContextImpl(this.extendedMetaData, false), this.tag.play(this.xmlResource));
                        this.changeSummaryDeserializers.add(changeSummaryDeserializer);
                    }
                    catch (XMLStreamException e) {
                        this.xmlResource.getErrors().add((Object)new XMIException((Exception)e));
                    }
                    this.tag = null;
                }
            }

            public void endDocument() {
                super.endDocument();
                if (this.changeSummaryDeserializers != null) {
                    Iterator iterator = this.changeSummaryDeserializers.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((ChangeSummaryStreamDeserializer)iterator.next()).end();
                        }
                        catch (XMLStreamException e) {
                            this.xmlResource.getErrors().add((Object)new XMIException((Exception)e));
                        }
                    }
                }
            }
        }
    }

    public static class SDOXMLHelperImpl
    extends XMLHelperImpl {
        NameSpaceContext nameSpaceContext;

        public SDOXMLHelperImpl(XMLResource resource, XMLStreamReader reader) {
            this(reader);
            this.setResource(resource);
        }

        public SDOXMLHelperImpl(XMLStreamReader reader) {
            if (reader instanceof XMLDocumentStreamReader) {
                this.namespaceSupport = new StreamNamespaceSupport(reader);
            }
        }

        protected final NameSpaceContext nameSpaceContext() {
            if (this.nameSpaceContext == null) {
                this.nameSpaceContext = new NameSpaceContext();
            }
            return this.nameSpaceContext;
        }

        private String xsdQName2SDOURI(String xsdQName) {
            org.eclipse.emf.ecore.xml.type.internal.QName qname = new org.eclipse.emf.ecore.xml.type.internal.QName(xsdQName);
            try {
                this.updateQNameURI(qname);
            }
            catch (IllegalArgumentException e) {
                return xsdQName;
            }
            String uri = qname.getNamespaceURI();
            if (uri != "") {
                return uri + "#" + qname.getLocalPart();
            }
            return qname.getLocalPart();
        }

        private String getPrefixFromNamespaceURI(String nsURI) {
            String nsPrefix = null;
            List prefixes = (List)this.urisToPrefixes.get(nsURI);
            if (prefixes != null) {
                Iterator i = prefixes.iterator();
                while (i.hasNext()) {
                    nsPrefix = (String)i.next();
                    if (nsPrefix.length() < 0) continue;
                    return nsPrefix;
                }
            }
            if ((nsPrefix = this.namespaceSupport.getPrefix(nsURI)) != null) {
                return nsPrefix;
            }
            EPackage ePackage = this.extendedMetaData.demandPackage(nsURI);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(nsURI)) {
                ePackage.setNsPrefix("xsi");
            }
            nsPrefix = this.getPrefix(ePackage, true);
            return nsPrefix;
        }

        private String SDOURI2XsdQName(String sdoURI) {
            String namespace = null;
            String localPart = sdoURI;
            int index = sdoURI.indexOf(35);
            if (index == -1) {
                return localPart;
            }
            namespace = sdoURI.substring(0, index);
            localPart = sdoURI.substring(index + 1);
            String prefix = this.getPrefixFromNamespaceURI(namespace);
            if (prefix.length() == 0) {
                return localPart;
            }
            return prefix + ":" + localPart;
        }

        protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
            Object obj = super.createFromString(eFactory, eDataType, value);
            if (eDataType == ((InternalFactoryImpl)InternalFactory.INSTANCE).getQName() && this.extendedMetaData != null) {
                if (obj instanceof List) {
                    List list = (List)obj;
                    for (int i = 0; i < list.size(); ++i) {
                        String xsdQName = (String)list.get(i);
                        list.set(i, this.xsdQName2SDOURI(xsdQName));
                    }
                } else {
                    obj = this.xsdQName2SDOURI((String)obj);
                }
            }
            return obj;
        }

        public String convertToString(EFactory factory, EDataType eDataType, Object value) {
            if (eDataType == ((InternalFactoryImpl)InternalFactory.INSTANCE).getQName() && this.extendedMetaData != null) {
                if (value instanceof List) {
                    List list = (List)value;
                    for (int i = 0; i < list.size(); ++i) {
                        String sdoURI = (String)list.get(i);
                        list.set(i, this.SDOURI2XsdQName(sdoURI));
                    }
                } else {
                    value = this.SDOURI2XsdQName((String)value);
                }
            }
            return super.convertToString(factory, eDataType, value);
        }

        private class NameSpaceContext
        implements NamespaceContext {
            private NameSpaceContext() {
            }

            public String getNamespaceURI(String prefix) {
                return SDOXMLHelperImpl.this.getNamespaceURI(prefix);
            }

            public String getPrefix(String namespaceURI) {
                return SDOXMLHelperImpl.this.getPrefix(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return ((Collection)SDOXMLHelperImpl.this.urisToPrefixes.get(namespaceURI)).iterator();
            }
        }

        private static class StreamNamespaceSupport
        extends XMLHelperImpl.NamespaceSupport {
            protected NamespaceContext nameSpaceContext;

            public String getPrefix(String uri) {
                String prefix = super.getPrefix(uri);
                if (prefix == null) {
                    try {
                        prefix = this.nameSpaceContext.getPrefix(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return prefix;
            }

            public String getURI(String prefix) {
                String uri = super.getURI(prefix);
                if (uri == null) {
                    try {
                        uri = this.nameSpaceContext.getNamespaceURI(prefix);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return uri;
            }

            public StreamNamespaceSupport(XMLStreamReader reader) {
                this.nameSpaceContext = reader.getNamespaceContext();
            }
        }
    }
}

