/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sdo.impl.ClassImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class VirtualSequence
implements Sequence {
    private final DataObject dataObject;
    protected final List delegateProperties;

    public VirtualSequence(DataObject object) {
        this.dataObject = object;
        this.delegateProperties = ((ClassImpl)this.dataObject.getType()).getVirtualSequenceProperties();
    }

    protected static boolean isSequenceProperty(Object property) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)((EStructuralFeature)property));
    }

    public int size() {
        int size = 0;
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                size += ((Sequence)this.dataObject.get(property)).size();
                continue;
            }
            if (property.isMany()) {
                size += this.dataObject.getList(property).size();
                continue;
            }
            ++size;
        }
        return size;
    }

    public Property getProperty(int index) {
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                int size = sequence.size();
                if (index < size) {
                    return sequence.getProperty(index);
                }
                index -= size;
                continue;
            }
            if (property.isMany()) {
                int size = this.dataObject.getList(property).size();
                if (index < size) {
                    return property;
                }
                index -= size;
                continue;
            }
            if (index == 0) {
                return property;
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    public Object getValue(int index) {
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            int size;
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                size = sequence.size();
                if (index < size) {
                    return sequence.getValue(index);
                }
                index -= size;
                continue;
            }
            if (property.isMany()) {
                List values = this.dataObject.getList(property);
                size = values.size();
                if (index < size) {
                    return values.get(index);
                }
                index -= size;
                continue;
            }
            if (index == 0) {
                return this.dataObject.get(property);
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    public Object setValue(int index, Object value) {
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            int size;
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                size = sequence.size();
                if (index < size) {
                    return sequence.setValue(index, value);
                }
                index -= size;
                continue;
            }
            if (property.isMany()) {
                List values = this.dataObject.getList(property);
                size = values.size();
                if (index < size) {
                    return values.set(index, value);
                }
                index -= size;
                continue;
            }
            if (index == 0) {
                Object old = this.dataObject.get(property);
                this.dataObject.set(property, value);
                return old;
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    boolean validate(EStructuralFeature feature, Object property) {
        return FeatureMapUtil.getValidator((EClass)((EClass)this.dataObject.getType()), (EStructuralFeature)feature).isValid((EStructuralFeature)property);
    }

    boolean append(Property delegateProperty, Property property, Object value) {
        return ((Sequence)this.dataObject.get(delegateProperty)).add(property, value);
    }

    boolean append(Property property, Object value) {
        return this.dataObject.getList(property).add(value);
    }

    boolean set(Property property, Object value) {
        if (property.isMany()) {
            return this.append(property, value);
        }
        this.dataObject.set(property, value);
        return true;
    }

    public final boolean add(Property p, Object value) {
        EStructuralFeature feature;
        Property property;
        int size;
        int index = size = this.delegateProperties.size();
        do {
            if (!this.dataObject.isSet(property = (Property)this.delegateProperties.get(--index))) continue;
            feature = (EStructuralFeature)property;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                if (this.validate(feature, p)) {
                    return this.append(property, p, value);
                }
            } else if (property == p && property.isMany()) {
                return this.append(property, value);
            }
            if (size == ++index) {
                return false;
            }
            property = (Property)this.delegateProperties.get(index);
            break;
        } while (index != 0);
        while (true) {
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)(feature = (EStructuralFeature)property))) {
                if (this.validate(feature, p)) {
                    return this.append(property, p, value);
                }
            } else if (property == p) {
                return this.set(p, value);
            }
            if (size == ++index) {
                return false;
            }
            property = (Property)this.delegateProperties.get(index);
        }
    }

    protected final Property property(String name) {
        return this.dataObject.getType().getProperty(name);
    }

    public boolean add(String propertyName, Object value) {
        return this.add(this.property(propertyName), value);
    }

    protected final Property property(int index) {
        return (Property)this.dataObject.getType().getProperties().get(index);
    }

    public boolean add(int propertyIndex, Object value) {
        return this.add(this.property(propertyIndex), value);
    }

    void insert(Property property, Property p, Object value) {
        ((Sequence)this.dataObject.get(property)).add(0, p, value);
    }

    void insert(Property property, Object value) {
        this.dataObject.getList(property).add(0, value);
    }

    protected final int insert(Iterator iterator, Property p, Object value) {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            EStructuralFeature feature = (EStructuralFeature)property;
            if (this.dataObject.isSet(property)) {
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    if (!this.validate(feature, p)) {
                        return 2;
                    }
                    this.insert(property, p, value);
                    return 0;
                }
                if (property != p || !property.isMany()) {
                    return 2;
                }
                this.insert(property, value);
                return 0;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                if (!this.validate(feature, p)) continue;
                this.append(property, p, value);
                return 0;
            }
            if (property != p) continue;
            this.set(property, value);
            return 0;
        }
        return 1;
    }

    public final void add(int index, Property p, Object value) {
        Iterator iterator = this.delegateProperties.iterator();
        if (index == 0) {
            switch (this.insert(iterator, p, value)) {
                case 0: {
                    return;
                }
                case 1: {
                    throw new IndexOutOfBoundsException();
                }
            }
            throw new IllegalArgumentException();
        }
        while (iterator.hasNext()) {
            int size;
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                size = sequence.size();
                if (index < size) {
                    sequence.add(index, p, value);
                    return;
                }
                if ((index -= size) != 0) continue;
                if (this.insert(iterator, p, value) != 0) {
                    sequence.add(p, value);
                }
                return;
            }
            if (property.isMany()) {
                List values = this.dataObject.getList(property);
                size = values.size();
                if (index < size) {
                    values.add(index, value);
                    return;
                }
                if ((index -= size) != 0 || property != p) continue;
                values.add(value);
                return;
            }
            if (index == 0) {
                throw new IllegalArgumentException();
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    public void add(int index, String propertyName, Object value) {
        this.add(index, this.property(propertyName), value);
    }

    public void add(int index, int propertyIndex, Object value) {
        this.add(index, this.property(propertyIndex), value);
    }

    public final void addText(String text) {
        throw new IllegalArgumentException();
    }

    public void add(String text) {
        this.addText(text);
    }

    public final void addText(int index, String text) {
        throw new IllegalArgumentException();
    }

    public void add(int index, String text) {
        this.addText(index, text);
    }

    public void remove(int index) {
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            int size;
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                size = sequence.size();
                if (index < size) {
                    sequence.remove(index);
                    return;
                }
                index -= size;
                continue;
            }
            if (property.isMany()) {
                List values = this.dataObject.getList(property);
                size = values.size();
                if (index < size) {
                    values.remove(index);
                    return;
                }
                index -= size;
                continue;
            }
            if (index == 0) {
                this.dataObject.unset(property);
                return;
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    private static Object remove(Sequence sequence, int index) {
        Object value = sequence.getValue(index);
        sequence.remove(index);
        return value;
    }

    static void move(Sequence fromSequence, int fromIndex, Sequence toSequence, int toIndex, Property property) {
        toSequence.add(toIndex, property, VirtualSequence.remove(fromSequence, fromIndex));
    }

    protected static void move(Sequence fromSequence, int fromIndex, Sequence toSequence, int toIndex) {
        VirtualSequence.move(fromSequence, fromIndex, toSequence, toIndex, fromSequence.getProperty(fromIndex));
    }

    protected static void add(Object value, List list, int index, int size) {
        if (++index == size) {
            list.add(value);
        } else {
            list.add(index, value);
        }
    }

    protected static void add(Property property, Object value, Sequence toSequence, int toIndex, int size) {
        if (++toIndex == size) {
            toSequence.add(property, value);
        } else {
            toSequence.add(toIndex, property, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void move(int toIndex, int fromIndex) {
        Iterator iterator = this.delegateProperties.iterator();
        while (iterator.hasNext()) {
            int size;
            Property property = (Property)iterator.next();
            if (!this.dataObject.isSet(property)) continue;
            if (VirtualSequence.isSequenceProperty(property)) {
                Sequence sequence = (Sequence)this.dataObject.get(property);
                size = sequence.size();
                if (toIndex < size) {
                    if (fromIndex < size) {
                        sequence.move(toIndex, fromIndex);
                        return;
                    }
                    while (iterator.hasNext()) {
                        property = (Property)iterator.next();
                        if (!this.dataObject.isSet(property)) continue;
                        fromIndex -= size;
                        if (VirtualSequence.isSequenceProperty(property)) {
                            Sequence fromSequence = (Sequence)this.dataObject.get(property);
                            size = fromSequence.size();
                            if (fromIndex >= size) continue;
                            VirtualSequence.move(fromSequence, fromIndex, sequence, toIndex);
                            return;
                        }
                        if (property.isMany()) {
                            List list = this.dataObject.getList(property);
                            size = list.size();
                            if (fromIndex >= size) continue;
                            sequence.add(toIndex, property, list.remove(fromIndex));
                            return;
                        }
                        if (fromIndex == 0) {
                            sequence.add(toIndex, property, this.dataObject.get(property));
                            this.dataObject.unset(property);
                            return;
                        }
                        size = 1;
                    }
                    throw new IndexOutOfBoundsException();
                }
                if (fromIndex < size) {
                    while (iterator.hasNext()) {
                        property = (Property)iterator.next();
                        if (!this.dataObject.isSet(property)) continue;
                        toIndex -= size;
                        if (VirtualSequence.isSequenceProperty(property)) {
                            Sequence toSequence = (Sequence)this.dataObject.get(property);
                            size = toSequence.size();
                            if (toIndex >= size) continue;
                            if (++toIndex == size) {
                                toSequence.add(sequence.getProperty(fromIndex), VirtualSequence.remove(sequence, fromIndex));
                                return;
                            } else {
                                VirtualSequence.move(sequence, fromIndex, toSequence, toIndex);
                            }
                            return;
                        }
                        if (property.isMany()) {
                            List list = this.dataObject.getList(property);
                            size = list.size();
                            if (toIndex >= size) continue;
                            if (sequence.getProperty(fromIndex) != property) {
                                throw new IllegalArgumentException();
                            }
                            VirtualSequence.add(VirtualSequence.remove(sequence, fromIndex), list, toIndex, size);
                            return;
                        }
                        if (toIndex == 0) {
                            while (iterator.hasNext()) {
                                Property p = sequence.getProperty(fromIndex);
                                property = (Property)iterator.next();
                                EStructuralFeature feature = (EStructuralFeature)property;
                                if (this.dataObject.isSet(property)) {
                                    if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                        VirtualSequence.move(sequence, fromIndex, (Sequence)this.dataObject.get(property), 0, p);
                                        return;
                                    }
                                    if (property != p || !property.isMany()) {
                                        throw new IllegalArgumentException();
                                    }
                                    this.insert(property, VirtualSequence.remove(sequence, fromIndex));
                                    return;
                                }
                                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                    if (!this.validate(feature, p)) continue;
                                    this.append(property, p, VirtualSequence.remove(sequence, fromIndex));
                                    return;
                                }
                                if (property != p) continue;
                                this.set(property, VirtualSequence.remove(sequence, fromIndex));
                                return;
                            }
                            throw new IndexOutOfBoundsException();
                        }
                        size = 1;
                    }
                    throw new IndexOutOfBoundsException();
                }
                toIndex -= size;
                fromIndex -= size;
                continue;
            }
            if (property.isMany()) {
                List list = this.dataObject.getList(property);
                size = list.size();
                if (toIndex < size) {
                    if (fromIndex < size) {
                        ((EList)list).move(toIndex, fromIndex);
                        return;
                    }
                    while (iterator.hasNext()) {
                        Property p = (Property)iterator.next();
                        if (!this.dataObject.isSet(p)) continue;
                        fromIndex -= size;
                        if (VirtualSequence.isSequenceProperty(p)) {
                            Sequence fromSequence = (Sequence)this.dataObject.get(p);
                            size = fromSequence.size();
                            if (fromIndex >= size) continue;
                            if (fromSequence.getProperty(fromIndex) != property) {
                                throw new IllegalArgumentException();
                            }
                            list.add(toIndex, VirtualSequence.remove(fromSequence, fromIndex));
                            return;
                        }
                        if (p.isMany()) {
                            List l = this.dataObject.getList(p);
                            size = l.size();
                            if (fromIndex >= size) continue;
                            list.add(toIndex, l.remove(fromIndex));
                            return;
                        }
                        if (fromIndex == 0) {
                            list.add(toIndex, this.dataObject.get(p));
                            this.dataObject.unset(p);
                            return;
                        }
                        size = 1;
                    }
                    throw new IndexOutOfBoundsException();
                }
                if (fromIndex < size) {
                    while (iterator.hasNext()) {
                        Property p = (Property)iterator.next();
                        if (!this.dataObject.isSet(p)) continue;
                        toIndex -= size;
                        if (VirtualSequence.isSequenceProperty(p)) {
                            Sequence toSequence = (Sequence)this.dataObject.get(p);
                            size = toSequence.size();
                            if (toIndex >= size) continue;
                            VirtualSequence.add(property, list.remove(fromIndex), toSequence, toIndex, size);
                            return;
                        }
                        if (p.isMany()) {
                            List l = this.dataObject.getList(p);
                            size = l.size();
                            if (toIndex >= size) continue;
                            VirtualSequence.add(list.remove(fromIndex), l, toIndex, size);
                            return;
                        }
                        if (toIndex == 0) {
                            while (iterator.hasNext()) {
                                p = (Property)iterator.next();
                                EStructuralFeature feature = (EStructuralFeature)p;
                                if (this.dataObject.isSet(p)) {
                                    if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                        this.insert(p, property, list.remove(fromIndex));
                                        return;
                                    }
                                    if (!p.isMany()) {
                                        throw new IllegalArgumentException();
                                    }
                                    this.insert(p, list.remove(fromIndex));
                                    return;
                                }
                                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                    if (!this.validate(feature, property)) continue;
                                    this.append(p, property, list.remove(fromIndex));
                                    return;
                                }
                                if (p != property) continue;
                                this.set(p, list.remove(fromIndex));
                                return;
                            }
                            throw new IndexOutOfBoundsException();
                        }
                        size = 1;
                    }
                    throw new IndexOutOfBoundsException();
                }
                toIndex -= size;
                fromIndex -= size;
                continue;
            }
            if (toIndex == 0) {
                throw new IllegalArgumentException();
            }
            if (fromIndex == 0) {
                int size2 = 1;
                while (iterator.hasNext()) {
                    Property p = (Property)iterator.next();
                    if (!this.dataObject.isSet(p)) continue;
                    toIndex -= size2;
                    if (VirtualSequence.isSequenceProperty(p)) {
                        Sequence toSequence = (Sequence)this.dataObject.get(p);
                        size2 = toSequence.size();
                        if (toIndex >= size2) continue;
                        VirtualSequence.add(property, this.dataObject.get(property), toSequence, toIndex, size2);
                        this.dataObject.unset(property);
                        return;
                    }
                    if (p.isMany()) {
                        List l = this.dataObject.getList(p);
                        size2 = l.size();
                        if (toIndex >= size2) continue;
                        VirtualSequence.add(this.dataObject.get(property), l, toIndex, size2);
                        this.dataObject.unset(property);
                        return;
                    }
                    if (toIndex == 0) {
                        while (iterator.hasNext()) {
                            p = (Property)iterator.next();
                            EStructuralFeature feature = (EStructuralFeature)p;
                            if (this.dataObject.isSet(p)) {
                                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                    this.insert(p, property, this.dataObject.get(property));
                                } else {
                                    if (!p.isMany()) throw new IllegalArgumentException();
                                    this.insert(p, this.dataObject.get(property));
                                }
                            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                                if (!this.validate(feature, property)) continue;
                                this.append(p, property, this.dataObject.get(property));
                            } else {
                                if (p != property) continue;
                                this.set(p, this.dataObject.get(property));
                            }
                            this.dataObject.unset(property);
                            return;
                        }
                        throw new IndexOutOfBoundsException();
                    }
                    size2 = 1;
                }
                throw new IndexOutOfBoundsException();
            }
            --toIndex;
            --fromIndex;
        }
        throw new IndexOutOfBoundsException();
    }
}

