/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.SDOExtendedMetaDataImpl;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.helper.XMLStreamHelper;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;

public final class SDOUtil {
    public static final String XML_SAVE_LineBreak = "LineBreak";
    public static final String XML_SAVE_INDENT = "indent";
    public static final String XML_SAVE_MARGIN = "margin";
    public static final String XML_SAVE_LineWidth = "LINE_WIDTH";
    public static final String XML_SAVE_DocType = "SAVE_DOCTYPE";
    public static final String XML_LOAD_SCHEMA = "ProcessSchemaLocations";
    public static final String XML_LOAD_LaxForm = "load malform";

    public static TypeHelper createTypeHelper() {
        EPackageRegistryImpl registry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        SDOExtendedMetaDataImpl extendedMetaData = new SDOExtendedMetaDataImpl((EPackage.Registry)registry);
        return new HelperContextImpl(extendedMetaData, false).getTypeHelper();
    }

    public static DataFactory createDataFactory(TypeHelper scope) {
        return ((TypeHelperImpl)scope).getHelperContext().getDataFactory();
    }

    public static XMLHelper createXMLHelper(TypeHelper scope) {
        return ((TypeHelperImpl)scope).getHelperContext().getXMLHelper();
    }

    public static XSDHelper createXSDHelper(TypeHelper scope) {
        return ((TypeHelperImpl)scope).getHelperContext().getXSDHelper();
    }

    public static void addTypeInstanceProperties(Type definedType, DataObject modeledType) {
        List instanceProperties = SDOUtil.getOpenContentProperties(modeledType);
        Iterator iter = instanceProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            org.apache.tuscany.sdo.api.SDOUtil.addTypeInstanceProperty((Type)definedType, (Property)property, (Object)modeledType.get(property));
        }
    }

    public static void addPropertyInstanceProperties(Property definedProperty, DataObject modeledProperty) {
        List instanceProperties = SDOUtil.getOpenContentProperties(modeledProperty);
        Iterator iter = instanceProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            org.apache.tuscany.sdo.api.SDOUtil.addPropertyInstanceProperty((Property)definedProperty, (Property)property, (Object)modeledProperty.get(property));
        }
    }

    public static void registerStaticTypes(Class factoryClass) {
        String temp = factoryClass.getName().replaceFirst("Factory$", "PackageImpl");
        int lastDot = temp.lastIndexOf(46);
        String packageName = temp.substring(0, lastDot) + ".impl" + temp.substring(lastDot);
        try {
            Class javaClass = SDOUtil.getPackageClass(factoryClass, packageName);
            Field field = javaClass.getField("eINSTANCE");
            EPackageImpl pkg = (EPackageImpl)field.get(null);
            EPackage.Registry.INSTANCE.put((Object)pkg.getNsURI(), (Object)pkg);
        }
        catch (Exception e1) {
            packageName = factoryClass.getName().replaceFirst("Factory$", "Package");
            try {
                Class javaClass = SDOUtil.getPackageClass(factoryClass, packageName);
                Field field = javaClass.getField("eINSTANCE");
                EPackageImpl pkg = (EPackageImpl)field.get(null);
                EPackage.Registry.INSTANCE.put((Object)pkg.getNsURI(), (Object)pkg);
            }
            catch (Exception e2) {
                try {
                    Field field = factoryClass.getField("INSTANCE");
                    EPackageImpl pkg = (EPackageImpl)field.get(null);
                    EPackage.Registry.INSTANCE.put((Object)pkg.getNsURI(), (Object)pkg);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    private static Class getPackageClass(Class factoryClass, String packageName) throws Exception {
        final Class factoryClassTemp = factoryClass;
        final String packageNameTemp = packageName;
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return factoryClassTemp.getClassLoader().loadClass(packageNameTemp);
            }
        });
    }

    public static DataObject createDataTypeWrapper(Type dataType, Object value) {
        return org.apache.tuscany.sdo.api.SDOUtil.createDataTypeWrapper((Type)dataType, (Object)value);
    }

    public static Object createFromString(Type dataType, String literal) {
        return org.apache.tuscany.sdo.api.SDOUtil.createFromString((Type)dataType, (String)literal);
    }

    public static String convertToString(Type dataType, Object value) {
        return org.apache.tuscany.sdo.api.SDOUtil.convertToString((Type)dataType, (Object)value);
    }

    public static Type getXSDSDOType(String xsdType) {
        return org.apache.tuscany.sdo.api.SDOUtil.getXSDSDOType((String)xsdType);
    }

    public static Sequence getSubstitutionValues(DataObject dataObject, Property head) {
        return org.apache.tuscany.sdo.api.SDOUtil.getSubstitutionValues((DataObject)dataObject, (Property)head);
    }

    public static Type getJavaSDOType(Class javaClass) {
        return org.apache.tuscany.sdo.api.SDOUtil.getJavaSDOType((Class)javaClass);
    }

    public static boolean isRequired(Property property) {
        return org.apache.tuscany.sdo.api.SDOUtil.isRequired((Property)property);
    }

    public static int getUpperBound(Property property) {
        return org.apache.tuscany.sdo.api.SDOUtil.getUpperBound((Property)property);
    }

    public static boolean isMany(Property property, DataObject context) {
        return org.apache.tuscany.sdo.api.SDOUtil.isMany((Property)property, (DataObject)context);
    }

    public static DataGraph createDataGraph() {
        return org.apache.tuscany.sdo.api.SDOUtil.createDataGraph();
    }

    public static void setRootObject(DataGraph dataGraph, DataObject rootObject) {
        org.apache.tuscany.sdo.api.SDOUtil.setRootObject((DataGraph)dataGraph, (DataObject)rootObject);
    }

    public static DataGraph loadDataGraph(InputStream inputStream, Map options) throws IOException {
        return org.apache.tuscany.sdo.api.SDOUtil.loadDataGraph((InputStream)inputStream, (Map)options, (HelperContext)null);
    }

    public static DataGraph loadDataGraph(InputStream inputStream, Map options, TypeHelper scope) throws IOException {
        return org.apache.tuscany.sdo.api.SDOUtil.loadDataGraph((InputStream)inputStream, (Map)options, (HelperContext)((TypeHelperImpl)scope).getHelperContext());
    }

    public static void saveDataGraph(DataGraph dataGraph, OutputStream outputStream, Map options) throws IOException {
        org.apache.tuscany.sdo.api.SDOUtil.saveDataGraph((DataGraph)dataGraph, (OutputStream)outputStream, (Map)options);
    }

    public static void registerDataGraphTypes(DataGraph dataGraph, List types) {
        org.apache.tuscany.sdo.api.SDOUtil.registerDataGraphTypes((DataGraph)dataGraph, (List)types);
    }

    public static HelperContext createHelperContext(boolean extensibleNamespaces) {
        return org.apache.tuscany.sdo.api.SDOUtil.createHelperContext((boolean)extensibleNamespaces);
    }

    public static HelperContext createHelperContext() {
        return org.apache.tuscany.sdo.api.SDOUtil.createHelperContext();
    }

    public static CopyHelper createCrossScopeCopyHelper(TypeHelper targetScope) {
        return org.apache.tuscany.sdo.api.SDOUtil.createCrossScopeCopyHelper((HelperContext)((TypeHelperImpl)targetScope).getHelperContext());
    }

    public static XMLStreamHelper createXMLStreamHelper(TypeHelper scope) {
        return (XMLStreamHelper)org.apache.tuscany.sdo.api.SDOUtil.createXMLStreamHelper((HelperContext)((TypeHelperImpl)scope).getHelperContext());
    }

    public static ObjectInputStream createObjectInputStream(InputStream inputStream, HelperContext helperContext) throws IOException {
        return org.apache.tuscany.sdo.api.SDOUtil.createObjectInputStream((InputStream)inputStream, (HelperContext)helperContext);
    }

    public static ObjectOutputStream createObjectOutputStream(OutputStream outputStream, HelperContext helperContext) throws IOException {
        return org.apache.tuscany.sdo.api.SDOUtil.createObjectOutputStream((OutputStream)outputStream, (HelperContext)helperContext);
    }

    public static List getTypes(TypeHelper scope, String uri) {
        return org.apache.tuscany.sdo.api.SDOUtil.getTypes((HelperContext)((TypeHelperImpl)scope).getHelperContext(), (String)uri);
    }

    public static List getOpenContentProperties(DataObject dataObject) {
        return org.apache.tuscany.sdo.api.SDOUtil.getOpenContentProperties((DataObject)dataObject);
    }

    public static boolean isDocumentRoot(Type type) {
        return org.apache.tuscany.sdo.api.SDOUtil.isDocumentRoot((Type)type);
    }

    public static Type createType(TypeHelper scope, String uri, String name, boolean isDataType) {
        return org.apache.tuscany.sdo.api.SDOUtil.createType((HelperContext)((TypeHelperImpl)scope).getHelperContext(), (String)uri, (String)name, (boolean)isDataType);
    }

    public static void addBaseType(Type type, Type baseType) {
        org.apache.tuscany.sdo.api.SDOUtil.addBaseType((Type)type, (Type)baseType);
    }

    public static void addAliasName(Type type, String aliasName) {
        org.apache.tuscany.sdo.api.SDOUtil.addAliasName((Type)type, (String)aliasName);
    }

    public static void setOpen(Type type, boolean isOpen) {
        org.apache.tuscany.sdo.api.SDOUtil.setOpen((Type)type, (boolean)isOpen);
    }

    public static void setSequenced(Type type, boolean isSequenced) {
        org.apache.tuscany.sdo.api.SDOUtil.setSequenced((Type)type, (boolean)isSequenced);
    }

    public static void setAbstract(Type type, boolean isAbstract) {
        org.apache.tuscany.sdo.api.SDOUtil.setAbstract((Type)type, (boolean)isAbstract);
    }

    public static void setJavaClassName(Type type, String javaClassName) {
        org.apache.tuscany.sdo.api.SDOUtil.setJavaClassName((Type)type, (String)javaClassName);
    }

    public static Property createProperty(Type containingType, String name, Type propertyType) {
        return org.apache.tuscany.sdo.api.SDOUtil.createProperty((Type)containingType, (String)name, (Type)propertyType);
    }

    public static Property createGlobalProperty(TypeHelper scope, String uri, String name, Type type) {
        return org.apache.tuscany.sdo.api.SDOUtil.createOpenContentProperty((HelperContext)((TypeHelperImpl)scope).getHelperContext(), (String)uri, (String)name, (Type)type);
    }

    public static void addAliasName(Property property, String aliasName) {
        org.apache.tuscany.sdo.api.SDOUtil.addAliasName((Property)property, (String)aliasName);
    }

    public static void setMany(Property property, boolean isMany) {
        org.apache.tuscany.sdo.api.SDOUtil.setMany((Property)property, (boolean)isMany);
    }

    public static void setContainment(Property property, boolean isContainment) {
        org.apache.tuscany.sdo.api.SDOUtil.setContainment((Property)property, (boolean)isContainment);
    }

    public static void setDefault(Property property, String defaultValue) {
        org.apache.tuscany.sdo.api.SDOUtil.setDefault((Property)property, (String)defaultValue);
    }

    public static void setReadOnly(Property property, boolean isReadOnly) {
        org.apache.tuscany.sdo.api.SDOUtil.setReadOnly((Property)property, (boolean)isReadOnly);
    }

    public static void setOpposite(Property property, Property opposite) {
        org.apache.tuscany.sdo.api.SDOUtil.setOpposite((Property)property, (Property)opposite);
    }
}

