/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.model.java.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.FactoryBase;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.model.java.JavaFactory;
import org.apache.tuscany.sdo.model.java.JavaInfo;
import org.apache.tuscany.sdo.model.java.impl.JavaInfoImpl;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

public class JavaFactoryImpl
extends FactoryBase
implements JavaFactory {
    public static final String NAMESPACE_URI = "commonj.sdo/java";
    public static final String NAMESPACE_PREFIX = "sdoJava";
    public static final String PATTERN_VERSION = "1.2";
    public static final int JAVA_INFO = 1;
    public static final int BOOLEAN_OBJECT = 2;
    public static final int BYTE_OBJECT = 3;
    public static final int CHARACTER_OBJECT = 4;
    public static final int DOUBLE_OBJECT = 5;
    public static final int FLOAT_OBJECT = 6;
    public static final int INT_OBJECT = 7;
    public static final int LONG_OBJECT = 8;
    public static final int SHORT_OBJECT = 9;
    protected Type javaInfoType = null;
    protected Type booleanObjectType = null;
    protected Type byteObjectType = null;
    protected Type characterObjectType = null;
    protected Type doubleObjectType = null;
    protected Type floatObjectType = null;
    protected Type intObjectType = null;
    protected Type longObjectType = null;
    protected Type shortObjectType = null;
    private static JavaFactoryImpl instance = null;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    public JavaFactoryImpl() {
        super(NAMESPACE_URI, NAMESPACE_PREFIX, "org.apache.tuscany.sdo.model.java");
    }

    public void register(HelperContext scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope can not be null");
        }
        ModelFactory.INSTANCE.register(scope);
        TypeHelperImpl th = (TypeHelperImpl)scope.getTypeHelper();
        th.getExtendedMetaData().putPackage(NAMESPACE_URI, (EPackage)this);
    }

    public DataObject create(int typeNumber) {
        switch (typeNumber) {
            case 1: {
                return (DataObject)this.createJavaInfo();
            }
        }
        return super.create(typeNumber);
    }

    public Object createFromString(int typeNumber, String initialValue) {
        switch (typeNumber) {
            case 2: {
                return this.createBooleanObjectFromString(initialValue);
            }
            case 3: {
                return this.createByteObjectFromString(initialValue);
            }
            case 4: {
                return this.createCharacterObjectFromString(initialValue);
            }
            case 5: {
                return this.createDoubleObjectFromString(initialValue);
            }
            case 6: {
                return this.createFloatObjectFromString(initialValue);
            }
            case 7: {
                return this.createIntObjectFromString(initialValue);
            }
            case 8: {
                return this.createLongObjectFromString(initialValue);
            }
            case 9: {
                return this.createShortObjectFromString(initialValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public String convertToString(int typeNumber, Object instanceValue) {
        switch (typeNumber) {
            case 2: {
                return this.convertBooleanObjectToString(instanceValue);
            }
            case 3: {
                return this.convertByteObjectToString(instanceValue);
            }
            case 4: {
                return this.convertCharacterObjectToString(instanceValue);
            }
            case 5: {
                return this.convertDoubleObjectToString(instanceValue);
            }
            case 6: {
                return this.convertFloatObjectToString(instanceValue);
            }
            case 7: {
                return this.convertIntObjectToString(instanceValue);
            }
            case 8: {
                return this.convertLongObjectToString(instanceValue);
            }
            case 9: {
                return this.convertShortObjectToString(instanceValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public JavaInfo createJavaInfo() {
        JavaInfoImpl javaInfo = new JavaInfoImpl();
        return javaInfo;
    }

    public Type getJavaInfo() {
        return this.javaInfoType;
    }

    public Type getBooleanObject() {
        return this.booleanObjectType;
    }

    public Type getByteObject() {
        return this.byteObjectType;
    }

    public Type getCharacterObject() {
        return this.characterObjectType;
    }

    public Type getDoubleObject() {
        return this.doubleObjectType;
    }

    public Type getFloatObject() {
        return this.floatObjectType;
    }

    public Type getIntObject() {
        return this.intObjectType;
    }

    public Type getLongObject() {
        return this.longObjectType;
    }

    public Type getShortObject() {
        return this.shortObjectType;
    }

    public static JavaFactoryImpl init() {
        if (instance != null) {
            return instance;
        }
        instance = new JavaFactoryImpl();
        ModelFactory ModelFactoryInstance = ModelFactory.INSTANCE;
        instance.createMetaData();
        instance.initializeMetaData();
        return instance;
    }

    public void createMetaData() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.javaInfoType = this.createType(false, 1);
        this.createProperty(true, this.javaInfoType, 0);
        this.booleanObjectType = this.createType(true, 2);
        this.byteObjectType = this.createType(true, 3);
        this.characterObjectType = this.createType(true, 4);
        this.doubleObjectType = this.createType(true, 5);
        this.floatObjectType = this.createType(true, 6);
        this.intObjectType = this.createType(true, 7);
        this.longObjectType = this.createType(true, 8);
        this.shortObjectType = this.createType(true, 9);
    }

    public void initializeMetaData() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ModelFactoryImpl theModelPackageImpl = (ModelFactoryImpl)ModelFactory.INSTANCE;
        Property property = null;
        this.initializeType(this.javaInfoType, JavaInfo.class, "JavaInfo", false);
        property = this.getLocalProperty(this.javaInfoType, 0);
        this.initializeProperty(property, theModelPackageImpl.getString(), "javaClass", null, 0, 1, JavaInfo.class, false, true, false);
        this.initializeType(this.booleanObjectType, Boolean.class, "BooleanObject", true, false);
        this.setInstanceProperty(this.booleanObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Boolean");
        this.initializeType(this.byteObjectType, Byte.class, "ByteObject", true, false);
        this.setInstanceProperty(this.byteObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Byte");
        this.initializeType(this.characterObjectType, Character.class, "CharacterObject", true, false);
        this.setInstanceProperty(this.characterObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Character");
        this.initializeType(this.doubleObjectType, Double.class, "DoubleObject", true, false);
        this.setInstanceProperty(this.doubleObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Double");
        this.initializeType(this.floatObjectType, Float.class, "FloatObject", true, false);
        this.setInstanceProperty(this.floatObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Float");
        this.initializeType(this.intObjectType, Integer.class, "IntObject", true, false);
        this.setInstanceProperty(this.intObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Integer");
        this.initializeType(this.longObjectType, Long.class, "LongObject", true, false);
        this.setInstanceProperty(this.longObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Long");
        this.initializeType(this.shortObjectType, Short.class, "ShortObject", true, false);
        this.setInstanceProperty(this.shortObjectType, NAMESPACE_URI, "instanceClass", "java.lang.Short");
        this.createXSDMetaData(theModelPackageImpl);
    }

    protected void createXSDMetaData(ModelFactoryImpl theModelPackageImpl) {
        super.initXSD();
        Property property = null;
        property = this.createGlobalProperty("extendedInstanceClass", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "extendedInstanceClass", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("instanceClass", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "instanceClass", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("javaClass", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "javaClass", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("nestedInterfaces", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "nestedInterfaces", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("package", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "package", "namespace", "##targetNamespace"}, true);
        this.addXSDMapping(this.javaInfoType, new String[]{"name", "JavaInfo", "kind", "empty"});
        this.addXSDMapping(this.getProperty(this.javaInfoType, 0), new String[]{"kind", "attribute", "name", "javaClass"});
        this.addXSDMapping(this.booleanObjectType, new String[]{"name", "BooleanObject"});
        this.addXSDMapping(this.byteObjectType, new String[]{"name", "ByteObject"});
        this.addXSDMapping(this.characterObjectType, new String[]{"name", "CharacterObject"});
        this.addXSDMapping(this.doubleObjectType, new String[]{"name", "DoubleObject"});
        this.addXSDMapping(this.floatObjectType, new String[]{"name", "FloatObject"});
        this.addXSDMapping(this.intObjectType, new String[]{"name", "IntObject"});
        this.addXSDMapping(this.longObjectType, new String[]{"name", "LongObject"});
        this.addXSDMapping(this.shortObjectType, new String[]{"name", "ShortObject"});
    }

    public Boolean createBooleanObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createBooleanObject(initialValue);
    }

    public String convertBooleanObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertBooleanObject((Boolean)instanceValue);
    }

    public Byte createByteObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createByteObject(initialValue);
    }

    public String convertByteObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertByteObject((Byte)instanceValue);
    }

    public Character createCharacterObjectFromString(String initialValue) {
        return initialValue == null && initialValue.length() > 0 ? null : new Character(XMLTypeUtil.normalize((String)initialValue, (boolean)true).charAt(0));
    }

    public String convertCharacterObjectToString(Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Double createDoubleObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createDoubleObject(initialValue);
    }

    public String convertDoubleObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertDoubleObject((Double)instanceValue);
    }

    public Float createFloatObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createFloatObject(initialValue);
    }

    public String convertFloatObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertFloatObject((Float)instanceValue);
    }

    public Integer createIntObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createIntObject(initialValue);
    }

    public String convertIntObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertIntObject((Integer)instanceValue);
    }

    public Long createLongObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createLongObject(initialValue);
    }

    public String convertLongObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertLongObject((Long)instanceValue);
    }

    public Short createShortObjectFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createShortObject(initialValue);
    }

    public String convertShortObjectToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertShortObject((Short)instanceValue);
    }
}

