/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.XSDHelper;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.tuscany.sdo.helper.SDOAnnotations;
import org.apache.tuscany.sdo.helper.TypeTable;
import org.apache.tuscany.sdo.util.SDOUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class SchemaBuilder
extends SDOAnnotations {
    public static final String DEFAULT_SCHEMA_LOCATION = "";
    public static final String NAME_SPACE_PREFIX = "stn_";
    private static int prefixCount = 1;
    public static final String EFEATURE_MAP_ENTRY = "EFeatureMapEntry";
    private Map schemaMap = null;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaLocationMap = null;
    protected TypeTable typeTable = null;
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;

    protected SchemaBuilder(Map schemaMap, Map nsPrefixMap, TypeTable typeTable, Map schemaLocMap) {
        this.schemaMap = schemaMap;
        this.targetNamespacePrefixMap = nsPrefixMap;
        this.typeTable = typeTable;
        this.schemaLocationMap = schemaLocMap;
    }

    private QName addAttribute2ComplexType(String targetNamespace, XSDComplexTypeDefinition complexType, Property aProperty) {
        QName attributeSchemaType = null;
        String prefix = null;
        try {
            attributeSchemaType = this.buildSchema(aProperty.getType());
        }
        catch (IllegalArgumentException e) {
            attributeSchemaType = new QName(aProperty.getType().getURI(), aProperty.getType().getName(), this.generatePrefix());
            if (aProperty.getType().isDataType()) {
                this.typeTable.addSimpleSchemaType(aProperty.getType().getName(), attributeSchemaType);
                XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
                simpleType.setName(aProperty.getType().getName());
                simpleType.setTargetNamespace(aProperty.getType().getURI());
                this.typeTable.addXSDTypeDef(attributeSchemaType.getNamespaceURI(), attributeSchemaType.getLocalPart(), (XSDTypeDefinition)simpleType);
            } else {
                this.typeTable.addComplexSchemaType(aProperty.getType().getURI(), aProperty.getType().getName(), attributeSchemaType);
                XSDComplexTypeDefinition extComplexType = this.xsdFactory.createXSDComplexTypeDefinition();
                extComplexType.setName(aProperty.getType().getName());
                extComplexType.setTargetNamespace(aProperty.getType().getURI());
                this.typeTable.addXSDTypeDef(attributeSchemaType.getNamespaceURI(), attributeSchemaType.getLocalPart(), (XSDTypeDefinition)extComplexType);
            }
            this.includeExtXSD(aProperty.getType());
        }
        prefix = this.addImports((XSDSchema)this.schemaMap.get(targetNamespace), attributeSchemaType);
        XSDAttributeDeclaration attribute = this.xsdFactory.createXSDAttributeDeclaration();
        attribute.setName(aProperty.getName());
        XSDAttributeUse orderDateAttributeUse = this.xsdFactory.createXSDAttributeUse();
        orderDateAttributeUse.setContent(attribute);
        complexType.getAttributeContents().add((Object)orderDateAttributeUse);
        attribute.updateElement();
        if (aProperty.getType().isDataType()) {
            attribute.setTypeDefinition((XSDSimpleTypeDefinition)this.typeTable.getXSDTypeDef(attributeSchemaType.getNamespaceURI(), attributeSchemaType.getLocalPart()));
        } else {
            attribute.setTypeDefinition((XSDSimpleTypeDefinition)this.typeTable.getXSDTypeDef(this.typeTable.getSimpleSchemaTypeName("URI").getNamespaceURI(), this.typeTable.getSimpleSchemaTypeName("URI").getLocalPart()));
        }
        if (aProperty.getDefault() != null) {
            attribute.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            attribute.setLexicalValue(aProperty.getDefault().toString());
        }
        this.addAnnotations((XSDSchemaContent)attribute, aProperty);
        if (!aProperty.getType().isDataType()) {
            String value = prefix + ":" + attributeSchemaType.getLocalPart();
            attribute.getElement().setAttribute("sdo:propertyType", value);
        }
        return attributeSchemaType;
    }

    private QName addElement2ComplexType(String targetNamespace, XSDComplexTypeDefinition complexType, Property aProperty) {
        String prefix = null;
        QName elementSchemaType = null;
        try {
            elementSchemaType = this.buildSchema(aProperty.getType());
        }
        catch (IllegalArgumentException e) {
            elementSchemaType = new QName(aProperty.getType().getURI(), aProperty.getType().getName(), this.generatePrefix());
            if (aProperty.getType().isDataType()) {
                this.typeTable.addSimpleSchemaType(aProperty.getType().getName(), elementSchemaType);
                XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
                simpleType.setName(aProperty.getType().getName());
                simpleType.setTargetNamespace(aProperty.getType().getURI());
                this.typeTable.addXSDTypeDef(elementSchemaType.getNamespaceURI(), elementSchemaType.getLocalPart(), (XSDTypeDefinition)simpleType);
            } else {
                this.typeTable.addComplexSchemaType(aProperty.getType().getURI(), aProperty.getType().getName(), elementSchemaType);
                XSDComplexTypeDefinition extComplexType = this.xsdFactory.createXSDComplexTypeDefinition();
                extComplexType.setName(aProperty.getType().getName());
                extComplexType.setTargetNamespace(aProperty.getType().getURI());
                this.typeTable.addXSDTypeDef(elementSchemaType.getNamespaceURI(), elementSchemaType.getLocalPart(), (XSDTypeDefinition)extComplexType);
            }
            this.includeExtXSD(aProperty.getType());
        }
        prefix = this.addImports((XSDSchema)this.schemaMap.get(targetNamespace), elementSchemaType);
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(aProperty.getName());
        XSDParticle aParticle = this.xsdFactory.createXSDParticle();
        aParticle.setContent((XSDParticleContent)element);
        ((XSDModelGroup)((XSDParticle)complexType.getContent()).getContent()).getContents().add((Object)aParticle);
        element.updateElement();
        if (aProperty.isMany()) {
            aParticle.setMaxOccurs(-1);
            aParticle.setMinOccurs(0);
        }
        if (aProperty.isContainment()) {
            element.setTypeDefinition(this.typeTable.getXSDTypeDef(elementSchemaType.getNamespaceURI(), elementSchemaType.getLocalPart()));
        } else if (!aProperty.getType().isDataType()) {
            QName qName = this.typeTable.getSimpleSchemaTypeName("URI");
            element.setTypeDefinition(this.typeTable.getXSDTypeDef(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        this.addAnnotations((XSDSchemaContent)element, aProperty);
        if (!aProperty.isContainment() && !aProperty.getType().isDataType()) {
            String value = prefix + ":" + elementSchemaType.getLocalPart();
            element.getElement().setAttribute("sdo:propertyType", value);
        }
        return elementSchemaType;
    }

    private void addAnnotations(XSDSchemaContent xsdContent, Property aProperty) {
        if (!aProperty.getAliasNames().isEmpty()) {
            this.addAliasNamesAnnotation(xsdContent, aProperty.getAliasNames());
        }
        if (aProperty.isReadOnly()) {
            xsdContent.getElement().setAttribute("sdo:readOnly", Boolean.toString(aProperty.isReadOnly()));
        }
        if (aProperty.getOpposite() != null) {
            xsdContent.getElement().setAttribute("sdo:oppositeProperty", aProperty.getOpposite().getName());
        }
    }

    private QName buildComplexSchemaTypeContents(String targetNamespace, XSDComplexTypeDefinition complexType, Type dataType) {
        List properties = dataType.getDeclaredProperties();
        Iterator iterator = properties.iterator();
        QName propertySchemaTypeName = null;
        while (iterator.hasNext()) {
            Property aProperty = (Property)iterator.next();
            if (aProperty.isContainment() || aProperty.isMany() || !aProperty.getType().isDataType()) {
                propertySchemaTypeName = this.addElement2ComplexType(targetNamespace, complexType, aProperty);
                continue;
            }
            propertySchemaTypeName = this.addAttribute2ComplexType(targetNamespace, complexType, aProperty);
        }
        return propertySchemaTypeName;
    }

    public QName buildComplexSchemaType(Type dataType) {
        QName complexSchemaTypeName = null;
        if (!dataType.isDataType() && (complexSchemaTypeName = this.typeTable.getComplexSchemaTypeName(dataType.getURI(), dataType.getName())) == null) {
            XSDSchema xmlSchema = this.getXmlSchema(dataType);
            String targetNamespace = dataType.getURI();
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNamespace);
            complexSchemaTypeName = new QName(targetNamespace, dataType.getName(), targetNamespacePrefix);
            XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
            complexType.setName(dataType.getName());
            complexType.setTargetNamespace(targetNamespace);
            complexType.setAbstract(dataType.isAbstract());
            xmlSchema.getTypeDefinitions().add((Object)complexType);
            xmlSchema.getContents().add((Object)complexType);
            complexType.updateElement();
            this.addAnnotations((XSDTypeDefinition)complexType, dataType);
            this.handleBaseExtn(xmlSchema, dataType, complexType);
            this.handleSDOSequence(dataType, complexType);
            this.handleSDOOpenType(dataType, complexType);
            this.typeTable.addComplexSchemaType(dataType.getURI(), dataType.getName(), complexSchemaTypeName);
            this.typeTable.addXSDTypeDef(dataType.getURI(), dataType.getName(), (XSDTypeDefinition)complexType);
            this.buildComplexSchemaTypeContents(targetNamespace, complexType, dataType);
            this.createGlobalElement(xmlSchema, complexType, complexSchemaTypeName);
        }
        return complexSchemaTypeName;
    }

    private void addAnnotations(XSDTypeDefinition xsdType, Type dataType) {
        if (dataType.isAbstract()) {
            if (xsdType instanceof XSDComplexTypeDefinition) {
                ((XSDComplexTypeDefinition)xsdType).setAbstract(dataType.isAbstract());
            } else {
                xsdType.getElement().setAttribute("abstract", Boolean.toString(dataType.isAbstract()));
            }
        }
        this.addAliasNamesAnnotation((XSDSchemaContent)xsdType, dataType.getAliasNames());
        if (dataType.getInstanceClass() != null) {
            xsdType.getElement().setAttribute("sdoJava:instanceClass", dataType.getInstanceClass().getName());
        }
    }

    private QName buildSimpleSchemaType(Type dataType) {
        QName simpleSchemaTypeName = null;
        if (dataType.isDataType() && (simpleSchemaTypeName = this.typeTable.getSimpleSchemaTypeName(dataType.getName())) == null) {
            XSDSchema xmlSchema = this.getXmlSchema(dataType);
            XSDSimpleTypeDefinition simpleType = this.xsdFactory.createXSDSimpleTypeDefinition();
            simpleType.setName(dataType.getName());
            simpleType.setTargetNamespace(dataType.getURI());
            simpleSchemaTypeName = new QName(dataType.getURI(), dataType.getName(), (String)this.targetNamespacePrefixMap.get(dataType.getURI()));
            xmlSchema.getContents().add((Object)simpleType);
            simpleType.updateElement();
            this.addAnnotations((XSDTypeDefinition)simpleType, dataType);
            if (!dataType.getBaseTypes().isEmpty()) {
                Type baseType = (Type)dataType.getBaseTypes().get(0);
                QName baseSchemaType = null;
                try {
                    baseSchemaType = this.buildSchema(baseType);
                }
                catch (IllegalArgumentException e) {
                    baseSchemaType = new QName(baseType.getURI(), baseType.getName(), this.generatePrefix());
                    this.typeTable.addSimpleSchemaType(baseType.getName(), baseSchemaType);
                    XSDSimpleTypeDefinition baseTypeDef = this.xsdFactory.createXSDSimpleTypeDefinition();
                    baseTypeDef.setName(baseType.getName());
                    baseTypeDef.setTargetNamespace(baseType.getURI());
                    this.typeTable.addXSDTypeDef(baseType.getURI(), baseType.getName(), (XSDTypeDefinition)baseTypeDef);
                    this.includeExtXSD(baseType);
                }
                simpleType.setBaseTypeDefinition((XSDSimpleTypeDefinition)this.typeTable.getXSDTypeDef(baseSchemaType.getNamespaceURI(), baseSchemaType.getLocalPart()));
                this.addImports(xmlSchema, baseSchemaType);
            }
            this.typeTable.addSimpleSchemaType(dataType.getName(), simpleSchemaTypeName);
            this.typeTable.addXSDTypeDef(dataType.getURI(), dataType.getName(), (XSDTypeDefinition)simpleType);
        }
        return simpleSchemaTypeName;
    }

    private void includeExtXSD(Type dataType) {
        XSDSchema xmlSchema = this.getXmlSchema(dataType);
        Vector<Object> schemaLocations = new Vector<Object>();
        if (this.schemaLocationMap.get(dataType.getURI()) != null) {
            schemaLocations.add(this.schemaLocationMap.get(dataType.getURI()));
        }
        if (schemaLocations.size() <= 0) {
            schemaLocations.add(DEFAULT_SCHEMA_LOCATION);
        }
        Object schemaContent = null;
        Iterator includesIterator = xmlSchema.getContents().iterator();
        Iterator schemaLocIterator = schemaLocations.iterator();
        String aSchemaLocation = null;
        boolean includeExists = false;
        while (schemaLocIterator.hasNext()) {
            aSchemaLocation = (String)schemaLocIterator.next();
            while (includesIterator.hasNext()) {
                schemaContent = includesIterator.next();
                if (!(schemaContent instanceof XSDInclude) || includeExists || !aSchemaLocation.equals(((XSDInclude)schemaContent).getSchemaLocation())) continue;
                includeExists = true;
            }
            if (includeExists) continue;
            XSDInclude includeElement = this.xsdFactory.createXSDInclude();
            includeElement.setSchemaLocation(aSchemaLocation);
            xmlSchema.getContents().add(0, (Object)includeElement);
        }
    }

    protected QName buildSchema(Type dataType) throws IllegalArgumentException {
        QName schemaTypeName = null;
        schemaTypeName = dataType.isDataType() ? this.typeTable.getSimpleSchemaTypeName(dataType.getName()) : this.typeTable.getComplexSchemaTypeName(dataType.getURI(), dataType.getName());
        if (schemaTypeName == null) {
            XSDHelper xsdHelper = SDOUtil.createHelperContext().getXSDHelper();
            if (!xsdHelper.isXSD(dataType)) {
                schemaTypeName = dataType.isDataType() ? this.buildSimpleSchemaType(dataType) : this.buildComplexSchemaType(dataType);
            } else {
                throw new IllegalArgumentException("Cannot generate XSD since SDO Type '" + dataType.getName() + "' was orginally generated from XSD.  Use original XSD");
            }
        }
        return schemaTypeName;
    }

    private XSDSchema getXmlSchema(Type dataType) {
        XSDSchema xmlSchema = null;
        xmlSchema = (XSDSchema)this.schemaMap.get(dataType.getURI());
        if (xmlSchema == null) {
            String targetNamespacePrefix = this.generatePrefix();
            xmlSchema = this.xsdFactory.createXSDSchema();
            xmlSchema.setTargetNamespace(dataType.getURI());
            xmlSchema.setAttributeFormDefault(XSDForm.QUALIFIED_LITERAL);
            xmlSchema.setElementFormDefault(XSDForm.QUALIFIED_LITERAL);
            this.targetNamespacePrefixMap.put(dataType.getURI(), targetNamespacePrefix);
            this.schemaMap.put(dataType.getURI(), xmlSchema);
            xmlSchema.getQNamePrefixToNamespaceMap().put("xs", "http://www.w3.org/2001/XMLSchema");
            xmlSchema.setSchemaForSchemaQNamePrefix("xs");
            xmlSchema.getQNamePrefixToNamespaceMap().put(targetNamespacePrefix, dataType.getURI());
            this.addSDONamespaces(xmlSchema);
            this.addPackageAnnotation(xmlSchema, dataType);
        }
        return xmlSchema;
    }

    private void addSDONamespaces(XSDSchema xmlSchema) {
        xmlSchema.getQNamePrefixToNamespaceMap().put("sdo", "commonj.sdo");
        xmlSchema.getQNamePrefixToNamespaceMap().put("sdoJava", "commonj.sdo/java");
    }

    public static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }

    private String addImports(XSDSchema xmlSchema, QName schemaTypeName) {
        String prefix = null;
        Iterator iterator = xmlSchema.getQNamePrefixToNamespaceMap().keySet().iterator();
        while (iterator.hasNext()) {
            prefix = (String)iterator.next();
            if (!schemaTypeName.getNamespaceURI().equals(xmlSchema.getQNamePrefixToNamespaceMap().get(prefix))) continue;
            return prefix;
        }
        XSDImport importElement = this.xsdFactory.createXSDImport();
        importElement.setNamespace(schemaTypeName.getNamespaceURI());
        xmlSchema.getContents().add(0, (Object)importElement);
        prefix = schemaTypeName.getPrefix();
        if (prefix == null || prefix.length() <= 0) {
            prefix = this.generatePrefix();
        }
        xmlSchema.getQNamePrefixToNamespaceMap().put(prefix, schemaTypeName.getNamespaceURI());
        return prefix;
    }

    private void handleSDOSequence(Type datatype, XSDComplexTypeDefinition complexType) {
        if (datatype.isSequenced()) {
            complexType.setMixed(true);
            XSDModelGroup choice = this.xsdFactory.createXSDModelGroup();
            choice.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle aParticle = this.xsdFactory.createXSDParticle();
            aParticle.setContent((XSDParticleContent)choice);
            aParticle.setMaxOccurs(-1);
            complexType.setContent((XSDComplexTypeContent)aParticle);
        } else {
            XSDModelGroup sequence = this.xsdFactory.createXSDModelGroup();
            sequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            XSDParticle aParticle = this.xsdFactory.createXSDParticle();
            aParticle.setContent((XSDParticleContent)sequence);
            complexType.setContent((XSDComplexTypeContent)aParticle);
        }
    }

    private void handleSDOOpenType(Type datatype, XSDComplexTypeDefinition complexType) {
        if (datatype.isOpen()) {
            XSDWildcard elementWildcard = this.xsdFactory.createXSDWildcard();
            elementWildcard.getLexicalNamespaceConstraint().add((Object)"##other");
            elementWildcard.setProcessContents(XSDProcessContents.LAX_LITERAL);
            XSDParticle wildcardParticle = this.xsdFactory.createXSDParticle();
            wildcardParticle.setContent((XSDParticleContent)elementWildcard);
            wildcardParticle.setMaxOccurs(-1);
            ((XSDModelGroup)((XSDParticle)complexType.getContent()).getContent()).getContents().add((Object)wildcardParticle);
            XSDWildcard attributeWildcard = this.xsdFactory.createXSDWildcard();
            attributeWildcard.getLexicalNamespaceConstraint().add((Object)"##other");
            attributeWildcard.setProcessContents(XSDProcessContents.LAX_LITERAL);
            complexType.setAttributeWildcard(attributeWildcard);
        }
    }

    private void handleBaseExtn(XSDSchema xmlSchema, Type datatype, XSDComplexTypeDefinition complexType) {
        if (datatype.getBaseTypes().size() > 0) {
            Type baseType = (Type)datatype.getBaseTypes().get(0);
            QName baseSchemaType = null;
            try {
                baseSchemaType = this.buildSchema(baseType);
            }
            catch (IllegalArgumentException e) {
                baseSchemaType = new QName(baseType.getURI(), baseType.getName(), this.generatePrefix());
                XSDSimpleTypeDefinition baseTypeDef = this.xsdFactory.createXSDSimpleTypeDefinition();
                baseTypeDef.setName(baseType.getName());
                baseTypeDef.setTargetNamespace(baseType.getURI());
                this.typeTable.addXSDTypeDef(baseType.getURI(), baseType.getName(), (XSDTypeDefinition)baseTypeDef);
                this.includeExtXSD(baseType);
            }
            complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            if (baseType.isDataType()) {
                XSDSimpleTypeDefinition anonymousSimpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
                anonymousSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)this.typeTable.getXSDTypeDef(baseSchemaType.getNamespaceURI(), baseSchemaType.getLocalPart()));
                complexType.setContent((XSDComplexTypeContent)anonymousSimpleTypeDefinition);
            } else {
                complexType.setBaseTypeDefinition((XSDTypeDefinition)((XSDSimpleTypeDefinition)this.typeTable.getXSDTypeDef(baseSchemaType.getNamespaceURI(), baseSchemaType.getLocalPart())));
            }
            this.addImports(xmlSchema, baseSchemaType);
        }
    }

    private String formGlobalElementName(String typeName) {
        String firstChar = typeName.substring(0, 1);
        return typeName.replaceFirst(firstChar, firstChar.toLowerCase());
    }

    private void createGlobalElement(XSDSchema xmlSchema, XSDComplexTypeDefinition complexType, QName schemaElementName) {
        XSDElementDeclaration globalElement = this.xsdFactory.createXSDElementDeclaration();
        globalElement.setTargetNamespace(xmlSchema.getTargetNamespace());
        globalElement.setName(this.formGlobalElementName(complexType.getName()));
        globalElement.setTypeDefinition(this.typeTable.getXSDTypeDef(schemaElementName.getNamespaceURI(), schemaElementName.getLocalPart()));
        xmlSchema.getContents().add((Object)globalElement);
        xmlSchema.getElementDeclarations().add((Object)globalElement);
    }

    private void addAliasNamesAnnotation(XSDSchemaContent typeDef, List aliasNames) {
        if (!aliasNames.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator iterator = aliasNames.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
            }
            typeDef.getElement().setAttribute("sdo:aliasName", sb.toString());
        }
    }

    private void addPackageAnnotation(XSDSchema xmlSchema, Type dataType) {
        if (dataType.getInstanceClass() != null) {
            xmlSchema.updateElement();
            xmlSchema.getElement().setAttribute("sdoJava:package", dataType.getInstanceClass().getPackage().getName());
        }
    }

    private String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }
}

