/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.TypeHelper;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class CrossScopeCopyHelperImpl
implements CopyHelper {
    protected TypeHelper scope;

    public CrossScopeCopyHelperImpl(TypeHelper targetScope) {
        this.scope = targetScope;
    }

    public DataObject copyShallow(DataObject dataObject) {
        CrossScopeCopier copier = new CrossScopeCopier(){

            protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            }

            protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                if (eObject.eIsSet((EStructuralFeature)eAttribute) && !FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
                    super.copyAttribute(eAttribute, eObject, copyEObject);
                }
            }
        };
        EObject result = copier.copy((EObject)dataObject);
        copier.copyReferences();
        return (DataObject)result;
    }

    public DataObject copy(DataObject dataObject) {
        CrossScopeCopier copier = new CrossScopeCopier();
        DataObject result = (DataObject)copier.copy((EObject)dataObject);
        copier.copyReferences();
        return result;
    }

    protected class CrossScopeCopier
    extends EcoreUtil.Copier {
        protected boolean useOriginalReferences = false;

        protected CrossScopeCopier() {
        }

        protected EClass getTarget(EClass eClass) {
            EClass target = (EClass)this.get(eClass);
            if (target == null) {
                Type type = (Type)eClass;
                target = (EClass)CrossScopeCopyHelperImpl.this.scope.getType(type.getURI(), type.getName());
            }
            return target;
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            EClass eClass = this.getTarget(eStructuralFeature.getEContainingClass());
            EStructuralFeature targetEf = eClass.getEStructuralFeature(eStructuralFeature.getName());
            return targetEf;
        }

        public void copyReferences() {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                int size = eClass.getFeatureCount();
                for (int j = 0; j < size; ++j) {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
                    if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature instanceof EReference) {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (eReference.isContainment() || eReference.isContainer()) continue;
                        this.copyReference(eReference, eObject, copyEObject);
                        continue;
                    }
                    if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) continue;
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                    FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                    int copyFeatureMapSize = copyFeatureMap.size();
                    int featureMapSize = featureMap.size();
                    block2: for (int k = 0; k < featureMapSize; ++k) {
                        EStructuralFeature feature = featureMap.getEStructuralFeature(k);
                        if (feature instanceof EReference) {
                            Object referencedEObject = featureMap.getValue(k);
                            Object copyReferencedEObject = this.get(referencedEObject);
                            if (copyReferencedEObject == null && referencedEObject != null) {
                                EReference reference = (EReference)feature;
                                if (!this.useOriginalReferences || reference.isContainment() || reference.getEOpposite() != null) continue;
                                copyReferencedEObject = referencedEObject;
                            }
                            if (copyFeatureMap.add(feature, copyReferencedEObject)) continue;
                            for (int l = 0; l < copyFeatureMapSize; ++l) {
                                if (copyFeatureMap.getEStructuralFeature(l) != feature || copyFeatureMap.getValue(l) != copyReferencedEObject) continue;
                                copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                --copyFeatureMapSize;
                                continue block2;
                            }
                            continue;
                        }
                        copyFeatureMap.add(featureMap.get(k));
                    }
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                if (eReference.isMany()) {
                    InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                    InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        Iterator k;
                        boolean isBidirectional = eReference.getEOpposite() != null;
                        int index = 0;
                        Iterator iterator = k = this.resolveProxies ? source.iterator() : source.basicIterator();
                        while (k.hasNext()) {
                            Object referencedEObject = k.next();
                            Object copyReferencedEObject = this.get(referencedEObject);
                            if (copyReferencedEObject == null) {
                                if (!this.useOriginalReferences || isBidirectional) continue;
                                target.addUnique(index, referencedEObject);
                                ++index;
                                continue;
                            }
                            if (isBidirectional) {
                                int position = target.indexOf(copyReferencedEObject);
                                if (position == -1) {
                                    target.addUnique(index, copyReferencedEObject);
                                } else if (index != position) {
                                    target.move(index, copyReferencedEObject);
                                }
                            } else {
                                target.addUnique(index, copyReferencedEObject);
                            }
                            ++index;
                        }
                    }
                } else {
                    Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                    if (referencedEObject == null) {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                    } else {
                        Object copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (this.useOriginalReferences && eReference.getEOpposite() == null) {
                                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                            }
                        } else {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                        }
                    }
                }
            }
        }
    }
}

