/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.codegen;

import commonj.sdo.Property;
import java.util.List;
import org.apache.tuscany.sdo.SDOTypeVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class BytecodeInterfaceGenerator
implements SDOTypeVisitor {
    private final ClassWriter cw = new ClassWriter(false);

    public void visitType(commonj.sdo.Type type) {
        String name = type.getName();
        int lastDot = name.lastIndexOf(46);
        name = lastDot != -1 ? name.replace('.', '/') : Character.toUpperCase(name.charAt(0)) + name.substring(1);
        List baseTypes = type.getBaseTypes();
        String[] interfaces = new String[baseTypes.size()];
        for (int i = 0; i < baseTypes.size(); ++i) {
            commonj.sdo.Type baseType = (commonj.sdo.Type)baseTypes.get(i);
            interfaces[i] = baseType.getInstanceClass().getName().replace('.', '/');
        }
        this.cw.visit(48, 1537, name, null, "java/lang/Object", interfaces);
    }

    public void visitProperty(Property property) {
        String name = property.getName();
        String propertyName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        Class javaType = property.getType().getInstanceClass();
        String desc = Type.getDescriptor((Class)javaType);
        if (property.isMany()) {
            this.cw.visitMethod(1025, "get" + propertyName, "()Ljava/util/List;", null, null).visitEnd();
        } else {
            if (Boolean.TYPE.equals(javaType)) {
                this.cw.visitMethod(1025, "is" + propertyName, "()Z", null, null).visitEnd();
            } else {
                this.cw.visitMethod(1025, "get" + propertyName, "()" + desc, null, null).visitEnd();
            }
            if (!property.isReadOnly()) {
                this.cw.visitMethod(1025, "set" + propertyName, '(' + desc + ")V", null, null).visitEnd();
            }
        }
    }

    public void visitEnd() {
        this.cw.visitEnd();
    }

    public byte[] getClassData() {
        return this.cw.toByteArray();
    }
}

