/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptPropertyFactory {
    private Mediator mediator = null;
    private SimpleTypeMapper simpleTypeMapper;
    boolean isSimpleType;

    public ScriptPropertyFactory(Mediator mediator, SimpleTypeMapper simpleTypeMapper) {
        this.mediator = mediator;
        this.simpleTypeMapper = simpleTypeMapper;
    }

    public ObjectFactory createValueFactory(Property property) {
        this.isSimpleType = this.isSimpleType(property);
        Document doc = (Document)property.getValue();
        Element rootElement = doc.getDocumentElement();
        Class<?> javaType = null;
        if (property.isMany()) {
            if (this.isSimpleType) {
                String value = "";
                if (rootElement.getChildNodes().getLength() > 0) {
                    value = rootElement.getChildNodes().item(0).getTextContent();
                }
                List<String> values = this.getSimplePropertyValues(value, javaType);
                return new ListObjectFactoryImpl(property, values, this.isSimpleType, javaType);
            }
            return new ListObjectFactoryImpl(property, this.getComplexPropertyValues(doc), this.isSimpleType, javaType);
        }
        if (this.isSimpleType) {
            String value = "";
            if (rootElement.getChildNodes().getLength() > 0) {
                value = rootElement.getChildNodes().item(0).getTextContent();
            }
            return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
        }
        Node value = this.getComplexPropertyValues(doc).get(0);
        return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
    }

    private boolean isSimpleType(Property property) {
        Document doc;
        Element element;
        if (property.getXSDType() != null) {
            return this.simpleTypeMapper.isSimpleXSDType(property.getXSDType());
        }
        return property instanceof Document && (element = (doc = (Document)property).getDocumentElement()).getChildNodes().getLength() == 1 && element.getChildNodes().item(0).getNodeType() == 3;
    }

    private List<String> getSimplePropertyValues(String concatenatedValue, Class<?> javaType) {
        ArrayList<String> propValues = new ArrayList<String>();
        StringTokenizer st = null;
        st = javaType.getName().equals("java.lang.String") ? new StringTokenizer(concatenatedValue, "\"") : new StringTokenizer(concatenatedValue);
        String aToken = null;
        while (st.hasMoreTokens()) {
            aToken = st.nextToken();
            if (aToken.trim().length() <= 0) continue;
            propValues.add(aToken);
        }
        return propValues;
    }

    private List<Node> getComplexPropertyValues(Document document) {
        Element rootElement = document.getDocumentElement();
        ArrayList<Node> propValues = new ArrayList<Node>();
        for (int count = 0; count < rootElement.getChildNodes().getLength(); ++count) {
            if (rootElement.getChildNodes().item(count).getNodeType() != 1) continue;
            propValues.add(rootElement.getChildNodes().item(count));
        }
        return propValues;
    }

    public class ListObjectFactoryImpl
    extends ObjectFactoryImplBase {
        public ListObjectFactoryImpl(Property property, List<?> propertyValues, boolean isSimpleType, Class<?> javaType) {
            super(property, propertyValues, isSimpleType, javaType);
        }

        public List<?> getInstance() throws ObjectCreationException {
            if (this.isSimpleType) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String aValue : (List)this.propertyValue) {
                    values.add(ScriptPropertyFactory.this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), aValue, null));
                }
                return values;
            }
            ArrayList<Object> instances = new ArrayList<Object>();
            for (Node aValue : (List)this.propertyValue) {
                instances.add(ScriptPropertyFactory.this.mediator.mediate((Object)aValue, this.sourceDataType, this.targetDataType, null));
            }
            return instances;
        }
    }

    public class ObjectFactoryImpl
    extends ObjectFactoryImplBase {
        public ObjectFactoryImpl(Property property, Object propertyValue, boolean isSimpleType, Class<?> javaType) {
            super(property, propertyValue, isSimpleType, javaType);
        }

        public Object getInstance() throws ObjectCreationException {
            if (this.isSimpleType) {
                return ScriptPropertyFactory.this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), (String)this.propertyValue, null);
            }
            return ScriptPropertyFactory.this.mediator.mediate(this.propertyValue, this.sourceDataType, this.targetDataType, null);
        }
    }

    public abstract class ObjectFactoryImplBase
    implements ObjectFactory {
        protected Property property;
        protected Object propertyValue;
        protected Class<?> javaType;
        protected DataType<XMLType> sourceDataType;
        protected DataType<?> targetDataType;
        boolean isSimpleType;

        public ObjectFactoryImplBase(Property property, Object propertyValue, boolean isSimpleType, Class<?> javaType) {
            this.isSimpleType = isSimpleType;
            this.property = property;
            this.propertyValue = propertyValue;
            this.javaType = javaType;
        }
    }
}

