/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script.provider;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.axiom.om.OMElement;
import org.apache.bsf.xml.XMLHelper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class ScriptInvoker
implements Invoker {
    private ScriptEngine scriptEngine;
    private XMLHelper xmlHelper;
    private Operation operation;

    public ScriptInvoker(ScriptEngine scriptEngine, XMLHelper xmlHelper, Operation operation) {
        this.scriptEngine = scriptEngine;
        this.xmlHelper = xmlHelper;
        this.operation = operation;
    }

    private Object doInvoke(Object[] objects, Operation op) throws ScriptException {
        Object response;
        Operation oper;
        if (this.xmlHelper != null) {
            objects[0] = this.xmlHelper.toScriptXML((OMElement)objects[0]);
        }
        if ((oper = this.operation).getName() == null) {
            oper = op;
        }
        try {
            response = ((Invocable)((Object)this.scriptEngine)).invokeFunction(oper.getName(), objects);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        if (this.xmlHelper != null) {
            response = this.xmlHelper.toOMElement(response);
        }
        return response;
    }

    public Message invoke(Message msg) {
        try {
            Object resp = this.doInvoke((Object[])msg.getBody(), msg.getOperation());
            msg.setBody(resp);
        }
        catch (ScriptException e) {
            msg.setFaultBody((Object)e.getCause());
        }
        return msg;
    }
}

