/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script.provider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.axiom.om.OMElement;
import org.apache.bsf.xml.XMLHelper;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.script.ScriptImplementation;
import org.apache.tuscany.sca.implementation.script.provider.ScriptInvoker;
import org.apache.tuscany.sca.implementation.script.provider.ScriptPropertyFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class ScriptImplementationProvider
implements ImplementationProvider {
    private RuntimeComponent component;
    private ScriptImplementation implementation;
    private ScriptPropertyFactory propertyFactory;
    private ScriptEngine scriptEngine;
    private XMLHelper xmlHelper;

    public ScriptImplementationProvider(RuntimeComponent component, ScriptImplementation implementation, ScriptPropertyFactory propertyFactory) {
        this.component = component;
        this.implementation = implementation;
        this.propertyFactory = propertyFactory;
        for (ComponentService service : component.getServices()) {
            InterfaceContract ic = service.getInterfaceContract();
            if (!(ic instanceof WSDLInterfaceContract)) continue;
            ic.getInterface().resetDataBinding(OMElement.class.getName());
            this.xmlHelper = XMLHelper.getArgHelper((ScriptEngine)this.scriptEngine);
        }
    }

    public void start() {
        try {
            String language = this.implementation.getLanguage();
            if (language == null) {
                language = this.implementation.getScript();
                language = language.substring(language.lastIndexOf(46) + 1);
            }
            this.scriptEngine = this.scriptEngine(language);
            if (this.scriptEngine == null) {
                throw new ObjectCreationException("no script engine found for language: " + this.implementation.getLanguage());
            }
            if (!(this.scriptEngine instanceof Invocable)) {
                throw new ObjectCreationException("script engine does not support Invocable: " + this.scriptEngine);
            }
            for (Reference reference : this.implementation.getReferences()) {
                this.scriptEngine.put(reference.getName(), this.getProxy(reference.getName()));
            }
            for (Property property : this.implementation.getProperties()) {
                ObjectFactory valueFactory = this.propertyFactory.createValueFactory(property);
                if (valueFactory == null) continue;
                this.scriptEngine.put(property.getName(), valueFactory.getInstance());
            }
            URL url = new URL(this.implementation.getLocation());
            InputStreamReader reader = new InputStreamReader(url.openStream());
            this.scriptEngine.eval(reader);
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void stop() {
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        return new ScriptInvoker(this.scriptEngine, this.xmlHelper, operation);
    }

    private Object getProxy(String name) {
        for (ComponentReference reference : this.component.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            Class iface = ((JavaInterface)reference.getInterfaceContract().getInterface()).getJavaClass();
            return this.component.getComponentContext().getService(iface, name);
        }
        throw new IllegalArgumentException("reference " + name + " not found on component: " + this.component);
    }

    private ScriptEngine scriptEngine(String language) {
        if (!"rb".equals(language) && "py".equals(language)) {
            ScriptImplementationProvider.pythonCachedir();
        }
        ScriptEngineManager scriptEngineManager = AccessController.doPrivileged(new PrivilegedAction<ScriptEngineManager>(){

            @Override
            public ScriptEngineManager run() {
                return new ScriptEngineManager();
            }
        });
        return scriptEngineManager.getEngineByExtension(language);
    }

    private static void pythonCachedir() {
        if (System.getProperty("python.home") == null) {
            System.setProperty("python.verbose", "error");
        }
    }
}

