/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.assembly.builder.WireBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;

public class WireMatcherImpl
implements WireBuilder {
    private InterfaceContractMapper interfaceContractMapper;
    private BuilderExtensionPoint builderExtensionPoint;

    public WireMatcherImpl(ExtensionPointRegistry registry) {
        this.builderExtensionPoint = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
    }

    public boolean build(EndpointReference endpointReference, Endpoint endpoint, BuilderContext context) {
        InterfaceContract targetIC;
        InterfaceContract sourceIC = endpointReference.getComponentReferenceInterfaceContract();
        if (!this.interfaceContractMapper.isCompatibleSubset(sourceIC, targetIC = endpoint.getComponentServiceInterfaceContract())) {
            return false;
        }
        for (PolicyBuilder policyBuilder : this.builderExtensionPoint.getPolicyBuilders()) {
            if (policyBuilder.build(endpointReference, endpoint, context)) continue;
            return false;
        }
        return true;
    }
}

