/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.oasisopen.sca.ServiceRuntimeException;

public class WireBuilderImpl {
    private AssemblyFactory assemblyFactory;
    private InterfaceContractMapper interfaceContractMapper;

    public WireBuilderImpl(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        Monitor monitor = context.getMonitor();
        this.processComponentReferences(composite, monitor);
        this.validateComponentReferences(composite, monitor);
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComponentReferences(Composite composite, Monitor monitor) {
        monitor.pushContext((Object)("Composite: " + composite.getName().toString()));
        try {
            HashMap<String, Component> components = new HashMap<String, Component>();
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
            this.connectWires(composite, componentServices, componentReferences, monitor);
            for (Component component : composite.getComponents()) {
                monitor.pushContext((Object)("Component: " + component.getName()));
                try {
                    Implementation implementation = component.getImplementation();
                    if (implementation instanceof Composite) {
                        this.processComponentReferences((Composite)implementation, monitor);
                    }
                    for (ComponentReference reference : component.getReferences()) {
                        this.createReferenceEndpointReferences(composite, component, reference, components, componentServices, monitor);
                        for (ComponentService service : component.getServices()) {
                            if (service.getInterfaceContract() == null || service.getInterfaceContract().getCallbackInterface() == null || !reference.getName().equals(service.getName())) continue;
                            for (Endpoint endpoint : service.getEndpoints()) {
                                endpoint.getCallbackEndpointReferences().addAll(reference.getEndpointReferences());
                            }
                        }
                        this.pushDownEndpointReferences(composite, component, reference, monitor);
                    }
                    this.validateReferenceMultiplicity(composite, component, monitor);
                }
                finally {
                    monitor.popContext();
                }
            }
        }
        finally {
            monitor.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateComponentReferences(Composite composite, Monitor monitor) {
        monitor.pushContext((Object)("Composite: " + composite.getName().toString()));
        try {
            for (Component component : composite.getComponents()) {
                monitor.pushContext((Object)("Component: " + component.getName()));
                try {
                    Implementation implementation = component.getImplementation();
                    if (implementation instanceof Composite) {
                        this.validateComponentReferences((Composite)implementation, monitor);
                    }
                    this.validateReferenceMultiplicity(composite, component, monitor);
                }
                finally {
                    monitor.popContext();
                }
            }
        }
        finally {
            monitor.popContext();
        }
    }

    protected void indexComponentsServicesAndReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            String uri;
            components.put(component.getName(), component);
            ComponentService nonCallbackService = null;
            int nonCallbackServices = 0;
            for (ComponentService componentService : component.getServices()) {
                uri = component.getName() + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                if (componentService.isForCallback()) continue;
                if (nonCallbackServices == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServices;
            }
            if (nonCallbackServices == 1) {
                componentServices.put(component.getName(), nonCallbackService);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                uri = component.getName() + '/' + componentReference.getName();
                componentReferences.put(uri, componentReference);
            }
        }
    }

    private void connectWires(Composite composite, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        List wires = composite.getWires();
        int n = wires.size();
        for (int i = 0; i < n; ++i) {
            ComponentService resolvedService;
            ComponentReference resolvedReference;
            Wire wire = (Wire)wires.get(i);
            ComponentReference source = wire.getSource();
            if (source != null && source.isUnresolved()) {
                resolvedReference = componentReferences.get(source.getName());
                if (resolvedReference != null) {
                    wire.setSource(resolvedReference);
                } else {
                    Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"WireSourceNotFound", (Object[])new Object[]{source.getName()});
                }
            } else {
                resolvedReference = wire.getSource();
            }
            ComponentService target = wire.getTarget();
            if (target != null && target.isUnresolved()) {
                resolvedService = componentServices.get(target.getName());
                if (resolvedService != null) {
                    wire.setTarget(target);
                } else {
                    Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"WireTargetNotFound", (Object[])new Object[]{target.getName()});
                }
            } else {
                resolvedService = wire.getTarget();
            }
            if (resolvedReference == null || resolvedService == null) continue;
            if (resolvedReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatibleSubset(resolvedReference.getInterfaceContract(), resolvedService.getInterfaceContract())) {
                if (wire.isReplace()) {
                    resolvedReference.getTargets().clear();
                }
                resolvedReference.getTargets().add(wire.getTarget());
                continue;
            }
            Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"WireIncompatibleInterface", (Object[])new Object[]{source.getName(), target.getName()});
        }
        composite.getWires().clear();
    }

    private void createReferenceEndpointReferences(Composite composite, Component component, ComponentReference reference, Map<String, Component> components, Map<String, ComponentService> componentServices, Monitor monitor) {
        EndpointReference endpointRef;
        monitor.pushContext((Object)("Reference: " + reference.getName()));
        List<ComponentService> refTargets = this.getReferenceTargets(reference);
        if (Boolean.TRUE.equals(reference.getAutowire()) && reference.getTargets().isEmpty()) {
            Multiplicity multiplicity = reference.getMultiplicity();
            block0: for (Component targetComponent : composite.getComponents()) {
                if ((multiplicity == Multiplicity.ZERO_ONE || multiplicity == Multiplicity.ONE_ONE) && reference.getEndpointReferences().size() != 0) break;
                if (targetComponent == component) continue;
                for (ComponentService targetComponentService : targetComponent.getServices()) {
                    if (reference.getInterfaceContract() != null && !this.interfaceContractMapper.isCompatibleSubset(reference.getInterfaceContract(), targetComponentService.getInterfaceContract()) || !this.intentsMatch(reference.getRequiredIntents(), targetComponentService.getRequiredIntents())) continue;
                    EndpointReference endpointRef2 = this.createEndpointRef(component, reference, false);
                    endpointRef2.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, true));
                    endpointRef2.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_READY_FOR_MATCHING);
                    reference.getEndpointReferences().add(endpointRef2);
                    if (multiplicity != Multiplicity.ZERO_ONE && multiplicity != Multiplicity.ONE_ONE) continue;
                    continue block0;
                }
            }
            if ((multiplicity == Multiplicity.ONE_N || multiplicity == Multiplicity.ONE_ONE) && reference.getEndpointReferences().size() == 0) {
                Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"NoComponentReferenceTarget", (Object[])new Object[]{reference.getName()});
            }
            this.setSingleAutoWireTarget(reference);
        } else if (!refTargets.isEmpty()) {
            if (this.bindingsIdentifyTargets(reference)) {
                Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ReferenceEndPointMixWithTarget", (Object[])new Object[]{composite.getName().toString(), component.getName(), reference.getName()});
            }
            for (ComponentService target : refTargets) {
                EndpointReference endpointRef3;
                ComponentService targetComponentService;
                String targetName = this.getComponentServiceName(target.getName());
                String bindingName = this.getBindingName(target.getName());
                targetComponentService = componentServices.get(targetName);
                Component targetComponent = this.getComponentFromTargetName(components, targetName);
                if (targetComponentService != null) {
                    if (reference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatibleSubset(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        if (bindingName != null) {
                            Binding targetBinding = null;
                            for (Binding tmp : targetComponentService.getBindings()) {
                                if (!tmp.getName().equals(bindingName)) continue;
                                targetBinding = tmp;
                            }
                            if (targetBinding != null) {
                                endpointRef = this.createEndpointRef(component, reference, false);
                                endpointRef.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, targetBinding, true));
                                endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
                                reference.getEndpointReferences().add(endpointRef);
                                continue;
                            }
                            endpointRef = this.createEndpointRef(component, reference, true);
                            endpointRef.setTargetEndpoint(this.createEndpoint(component, targetName));
                            endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                            reference.getEndpointReferences().add(endpointRef);
                            Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ComponentReferenceTargetNotFound", (Object[])new Object[]{composite.getName().toString(), targetName});
                            continue;
                        }
                        endpointRef3 = this.createEndpointRef(component, reference, false);
                        endpointRef3.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, true));
                        endpointRef3.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_READY_FOR_MATCHING);
                        reference.getEndpointReferences().add(endpointRef3);
                        continue;
                    }
                    Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ReferenceIncompatibleInterface", (Object[])new Object[]{composite.getName().toString(), component.getName() + "." + reference.getName(), targetName});
                    continue;
                }
                endpointRef3 = this.createEndpointRef(component, reference, true);
                endpointRef3.setTargetEndpoint(this.createEndpoint(component, targetName));
                endpointRef3.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                reference.getEndpointReferences().add(endpointRef3);
                Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ComponentReferenceTargetNotFound", (Object[])new Object[]{composite.getName().toString(), targetName});
            }
        }
        if (reference.getEndpointReferences().isEmpty()) {
            for (Binding binding : reference.getBindings()) {
                String uri = binding.getURI();
                if (uri == null) {
                    if (!reference.isForCallback() && binding instanceof SCABinding) continue;
                    EndpointReference endpointRef4 = this.createEndpointRef(component, reference, binding, null, false);
                    if (binding instanceof SCABinding) {
                        endpointRef4.setTargetEndpoint(this.createEndpoint(true));
                        endpointRef4.setStatus(EndpointReference.Status.NOT_CONFIGURED);
                    } else {
                        endpointRef4.setTargetEndpoint(this.createEndpoint(false));
                        endpointRef4.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                    }
                    reference.getEndpointReferences().add(endpointRef4);
                    continue;
                }
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                String targetName = this.getComponentServiceName(uri);
                String bindingName = this.getBindingName(uri);
                ComponentService targetComponentService = componentServices.get(targetName);
                Component targetComponent = this.getComponentFromTargetName(components, targetName);
                if (targetComponentService != null) {
                    if (reference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatibleSubset(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        if (bindingName != null) {
                            EndpointReference endpointRef5;
                            Binding targetBinding = null;
                            for (Binding tmp : targetComponentService.getBindings()) {
                                if (!tmp.getName().equals(bindingName)) continue;
                                targetBinding = tmp;
                            }
                            if (targetBinding != null) {
                                endpointRef5 = this.createEndpointRef(component, reference, false);
                                endpointRef5.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, targetBinding, true));
                                endpointRef5.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                                reference.getEndpointReferences().add(endpointRef5);
                                continue;
                            }
                            endpointRef5 = this.createEndpointRef(component, reference, true);
                            endpointRef5.setTargetEndpoint(this.createEndpoint(component, targetName));
                            endpointRef5.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                            reference.getEndpointReferences().add(endpointRef5);
                            Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ComponentReferenceTargetNotFound", (Object[])new Object[]{composite.getName().toString(), targetName});
                            continue;
                        }
                        endpointRef = this.createEndpointRef(component, reference, binding, null, false);
                        endpointRef.setTargetEndpoint(this.createEndpoint(targetComponent, targetComponentService, true));
                        endpointRef.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_READY_FOR_MATCHING);
                        reference.getEndpointReferences().add(endpointRef);
                        continue;
                    }
                    Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ReferenceIncompatibleInterface", (Object[])new Object[]{composite.getName().toString(), reference.getName(), uri});
                    continue;
                }
                endpointRef = this.createEndpointRef(component, reference, binding, null, false);
                Endpoint endpoint = this.createEndpoint(false);
                endpoint.setBinding(binding);
                endpointRef.setTargetEndpoint(endpoint);
                endpointRef.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                reference.getEndpointReferences().add(endpointRef);
            }
        }
        monitor.popContext();
    }

    private boolean intentsMatch(List<Intent> referenceIntents, List<Intent> serviceIntents) {
        HashSet<Intent> referenceIntentSet = new HashSet<Intent>(referenceIntents);
        HashSet<Intent> serviceIntentSet = new HashSet<Intent>(serviceIntents);
        return ((Object)referenceIntentSet).equals(serviceIntentSet);
    }

    private void pushDownEndpointReferences(Composite composite, Component component, ComponentReference componentReference, Monitor monitor) {
        Reference reference = componentReference.getReference();
        if (reference instanceof CompositeReference) {
            List<ComponentReference> leafComponentReferences = this.getPromotedComponentReferences((CompositeReference)reference);
            for (ComponentReference leafRef : leafComponentReferences) {
                int insertLocation = 0;
                for (EndpointReference epr : componentReference.getEndpointReferences()) {
                    EndpointReference eprCopy = this.copyHigherReference(epr, leafRef);
                    leafRef.getEndpointReferences().add(insertLocation, eprCopy);
                    ++insertLocation;
                }
            }
        }
    }

    private List<ComponentReference> getPromotedComponentReferences(CompositeReference compositeReference) {
        ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
        this.collectPromotedComponentReferences(compositeReference, componentReferences);
        return componentReferences;
    }

    private void collectPromotedComponentReferences(CompositeReference compositeReference, List<ComponentReference> componentReferences) {
        for (ComponentReference componentReference : compositeReference.getPromotedReferences()) {
            Reference reference = componentReference.getReference();
            if (reference instanceof CompositeReference) {
                this.collectPromotedComponentReferences((CompositeReference)reference, componentReferences);
                continue;
            }
            if (reference == null) continue;
            componentReferences.add(componentReference);
        }
    }

    private EndpointReference copyHigherReference(EndpointReference epRef, ComponentReference promotedReference) {
        EndpointReference epRefClone = null;
        try {
            epRefClone = (EndpointReference)epRef.clone();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        epRefClone.setReference(promotedReference);
        return epRefClone;
    }

    private void validateReferenceMultiplicity(Composite composite, Component component, Monitor monitor) {
        for (ComponentReference componentReference : component.getReferences()) {
            if (this.validateMultiplicity(componentReference.getMultiplicity(), componentReference.getEndpointReferences())) continue;
            if (componentReference.getEndpointReferences().isEmpty()) {
                boolean promoted = false;
                for (Reference reference : composite.getReferences()) {
                    CompositeReference compositeReference = (CompositeReference)reference;
                    if (!compositeReference.getPromotedReferences().contains(componentReference)) continue;
                    promoted = true;
                    break;
                }
                if (promoted || componentReference.isForCallback() || componentReference.isWiredByImpl()) continue;
                Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"ReferenceWithoutTargets", (Object[])new Object[]{composite.getName().toString(), componentReference.getName()});
                continue;
            }
            if (Boolean.TRUE.equals(componentReference.getAutowire())) break;
            Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"TooManyReferenceTargets", (Object[])new Object[]{componentReference.getName()});
        }
    }

    private boolean validateMultiplicity(Multiplicity multiplicity, List<EndpointReference> endpointReferences) {
        if (multiplicity == null) {
            return true;
        }
        int count = endpointReferences.size();
        switch (multiplicity) {
            case ZERO_N: {
                break;
            }
            case ZERO_ONE: {
                if (count <= 1) break;
                return false;
            }
            case ONE_ONE: {
                if (count == 1) break;
                return false;
            }
            case ONE_N: {
                if (count >= 1) break;
                return false;
            }
        }
        return true;
    }

    private boolean bindingsIdentifyTargets(ComponentReference reference) {
        for (Binding binding : reference.getBindings()) {
            if (binding instanceof SCABinding && binding.getURI() == null) continue;
            return true;
        }
        return false;
    }

    private List<ComponentService> getReferenceTargets(ComponentReference reference) {
        List theTargets = reference.getTargets();
        if (theTargets.isEmpty() && reference.getReference() != null) {
            theTargets = reference.getReference().getTargets();
        }
        return theTargets;
    }

    private String getComponentServiceName(String targetName) {
        String[] parts = targetName.split("/");
        if (parts.length > 1) {
            return parts[0] + "/" + parts[1];
        }
        return parts[0];
    }

    private String getBindingName(String targetName) {
        String[] parts = targetName.split("/");
        if (parts.length == 3) {
            return parts[2];
        }
        return null;
    }

    private Component getComponentFromTargetName(Map<String, Component> components, String targetName) {
        int s = targetName.indexOf(47);
        Component theComponent = s == -1 ? components.get(targetName) : components.get(targetName.substring(0, s));
        return theComponent;
    }

    private EndpointReference createEndpointRef(Component component, ComponentReference reference, Binding binding, Endpoint endpoint, boolean unresolved) {
        EndpointReference endpointRef = this.createEndpointRef(component, reference, unresolved);
        endpointRef.setBinding(binding);
        endpointRef.setTargetEndpoint(endpoint);
        return endpointRef;
    }

    private EndpointReference createEndpointRef(Component component, ComponentReference reference, boolean unresolved) {
        EndpointReference endpointRef = this.assemblyFactory.createEndpointReference();
        endpointRef.setComponent(component);
        endpointRef.setReference(reference);
        endpointRef.setUnresolved(unresolved);
        return endpointRef;
    }

    private Endpoint createEndpoint(Component component, ComponentService service, boolean unresolved) {
        Endpoint endpoint = this.createEndpoint(unresolved);
        endpoint.setComponent(component);
        endpoint.setService(service);
        endpoint.setUnresolved(unresolved);
        return endpoint;
    }

    private Endpoint createEndpoint(Component component, ComponentService service, Binding binding, boolean unresolved) {
        Endpoint endpoint = this.createEndpoint(unresolved);
        endpoint.setComponent(component);
        endpoint.setService(service);
        endpoint.setBinding(binding);
        endpoint.setUnresolved(unresolved);
        return endpoint;
    }

    private Endpoint createEndpoint(boolean unresolved) {
        Endpoint endpoint = this.assemblyFactory.createEndpoint();
        endpoint.setUnresolved(unresolved);
        return endpoint;
    }

    private Endpoint createEndpoint(Component component, String targetName) {
        String[] parts = targetName.split("/");
        if (parts.length < 1 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid target URI: " + targetName);
        }
        String uri = component.getURI();
        int index = uri.lastIndexOf(47);
        uri = index == -1 ? "" : uri.substring(0, index);
        if (parts.length >= 1) {
            uri = uri.length() == 0 ? parts[0] : uri + "/" + parts[0];
        }
        if (parts.length == 3) {
            uri = uri + "#service-binding(" + parts[1] + "/" + parts[2] + ")";
        } else if (parts.length == 2) {
            uri = uri + "#service(" + parts[1] + ")";
        }
        Endpoint endpoint = this.assemblyFactory.createEndpoint();
        endpoint.setUnresolved(true);
        endpoint.setURI(uri);
        return endpoint;
    }

    private void setSingleAutoWireTarget(ComponentReference reference) {
        String uri;
        if (reference.getEndpointReferences().size() > 1 && reference.getBindings() != null && reference.getBindings().size() == 1 && (uri = ((Binding)reference.getBindings().get(0)).getURI()) != null) {
            if (uri.indexOf(47) > -1) {
                int i = uri.indexOf(47);
                String c = uri.substring(0, i);
                String s = uri.substring(i + 1);
                uri = c + "#service(" + s + ")";
            }
            for (EndpointReference er : reference.getEndpointReferences()) {
                if (er.getTargetEndpoint() == null || !uri.equals(er.getTargetEndpoint().getURI())) continue;
                reference.getEndpointReferences().clear();
                reference.getEndpointReferences().add(er);
                return;
            }
        }
    }
}

