/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class StructuralURIBuilderImpl
implements CompositeBuilder {
    public StructuralURIBuilderImpl(ExtensionPointRegistry registry) {
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.StructualURIBuilder";
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.configureStructuralURIs(composite, null, context.getDefinitions(), context.getBindingBaseURIs(), context.getMonitor());
        return composite;
    }

    private void constructBindingNames(Contract contract, Monitor monitor) {
        Binding existed;
        List bindings = contract.getBindings();
        HashMap<String, Binding> bindingMap = new HashMap<String, Binding>();
        for (Binding binding : bindings) {
            if (binding.getName() == null) {
                binding.setName(contract.getName());
            }
            if ((existed = bindingMap.put(binding.getName(), binding)) == null || existed == binding) continue;
            if (contract instanceof Service) {
                Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"MultipleBindingsForService", (Object[])new Object[]{contract.getName(), binding.getName()});
                continue;
            }
            Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"MultipleBindingsForReference", (Object[])new Object[]{contract.getName(), binding.getName()});
        }
        if (contract.getCallback() != null) {
            bindings = contract.getCallback().getBindings();
            bindingMap.clear();
            for (Binding binding : bindings) {
                if (binding.getName() == null) {
                    binding.setName(contract.getName());
                }
                if ((existed = bindingMap.put(binding.getName(), binding)) == null || existed == binding) continue;
                if (contract instanceof Service) {
                    Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"MultipleBindingsForServiceCallback", (Object[])new Object[]{contract.getName(), binding.getName()});
                    continue;
                }
                Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", (String)"MultipleBindingsForReferenceCallback", (Object[])new Object[]{contract.getName(), binding.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureStructuralURIs(Composite composite, String parentComponentURI, Definitions definitions, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        monitor.pushContext((Object)("Composite: " + composite.getName().toString()));
        try {
            for (Service service : composite.getServices()) {
                this.constructBindingNames((Contract)service, monitor);
            }
            for (Reference reference : composite.getReferences()) {
                this.constructBindingNames((Contract)reference, monitor);
            }
            for (Component component : composite.getComponents()) {
                String componentURI = parentComponentURI == null ? component.getName() : parentComponentURI + '/' + component.getName();
                component.setURI(componentURI);
                monitor.pushContext((Object)("Component: " + component.getName()));
                try {
                    for (ComponentService service : component.getServices()) {
                        this.constructBindingNames((Contract)service, monitor);
                    }
                    for (ComponentService service : component.getReferences()) {
                        this.constructBindingNames((Contract)service, monitor);
                    }
                }
                finally {
                    monitor.popContext();
                }
                Implementation implementation = component.getImplementation();
                if (!(implementation instanceof Composite)) continue;
                this.configureStructuralURIs((Composite)implementation, componentURI, definitions, defaultBindings, monitor);
            }
        }
        finally {
            monitor.popContext();
        }
    }
}

