/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.ExternalAttachment;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PolicyAttachmentBuilderImpl
implements CompositeBuilder {
    protected static final String BUILDER_VALIDATION_BUNDLE = "org.apache.tuscany.sca.builder.builder-validation-messages";
    protected StAXHelper staxHelper;
    protected DOMHelper domHelper;
    protected ExtensionPointRegistry registry;
    protected StAXArtifactProcessor<Composite> processor;
    private static final QName COMPONENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "component");
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private static final QName COMPOSITE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "composite");

    public PolicyAttachmentBuilderImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.domHelper = DOMHelper.getInstance((ExtensionPointRegistry)registry);
        this.staxHelper = StAXHelper.getInstance((ExtensionPointRegistry)registry);
        StAXArtifactProcessorExtensionPoint processors = (StAXArtifactProcessorExtensionPoint)registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.processor = processors.getProcessor(Composite.class);
    }

    public String getID() {
        return "org.apache.tuscany.sca.policy.builder.PolicyAttachmentBuilder";
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        try {
            Composite patched = this.applyXPath(composite, context.getDefinitions(), context.getMonitor());
            return patched;
        }
        catch (Exception e) {
            throw new CompositeBuilderException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Composite applyXPath(Composite composite, Definitions definitions, Monitor monitor) throws Exception {
        monitor.pushContext((Object)("Composite: " + composite.getName().toString()));
        try {
            NodeList nodes;
            XPathExpression exp;
            if (definitions == null || definitions.getPolicySets().isEmpty() && definitions.getExternalAttachments().isEmpty()) {
                Composite composite2 = composite;
                return composite2;
            }
            Document document = null;
            for (PolicySet ps : definitions.getPolicySets()) {
                exp = ps.getAttachToXPathExpression();
                if (exp == null) continue;
                if (document == null) {
                    document = this.saveAsDOM(composite);
                }
                nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
                this.attachPolicySetToNodes(composite, monitor, nodes, ps);
            }
            for (ExternalAttachment ea : definitions.getExternalAttachments()) {
                exp = ea.getAttachToXPathExpression();
                if (exp == null) continue;
                if (document == null) {
                    document = this.saveAsDOM(composite);
                }
                nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
                for (PolicySet ps : ea.getPolicySets()) {
                    this.attachPolicySetToNodes(composite, monitor, nodes, ps);
                }
            }
            if (composite.getPolicySets().isEmpty()) {
                for (Component component : composite.getComponents()) {
                    Composite patched;
                    Implementation impl;
                    if (!component.getPolicySets().isEmpty() || !((impl = component.getImplementation()) instanceof Composite) || (patched = this.applyXPath((Composite)impl, definitions, monitor)) == impl) continue;
                    component.setImplementation((Implementation)patched);
                }
            }
            Composite composite3 = composite;
            return composite3;
        }
        finally {
            monitor.popContext();
        }
    }

    private void attachPolicySetToNodes(Composite composite, Monitor monitor, NodeList nodes, PolicySet ps) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            String index;
            PolicySubject subject;
            Node node = nodes.item(i);
            if (this.isAttachedToProperty(node)) {
                Monitor.error((Monitor)monitor, (Object)this, (String)BUILDER_VALIDATION_BUNDLE, (String)"PolicyAttachedToProperty", (Object[])new Object[]{ps.getName().toString()});
            }
            if ((subject = this.lookup(composite, index = PolicyAttachmentBuilderImpl.getStructuralURI(node))) != null) {
                ps.setIsExternalAttachment(true);
                ArrayList subjectPSCopy = new ArrayList(subject.getPolicySets());
                for (PolicySet existingPS : subjectPSCopy) {
                    if (!existingPS.getName().equals(ps.getName())) continue;
                    subject.getPolicySets().remove(existingPS);
                }
                subject.getPolicySets().add(ps);
                continue;
            }
            Monitor.warning((Monitor)monitor, (Object)this, (String)BUILDER_VALIDATION_BUNDLE, (String)"PolicyDOMModelMissmatch", (Object[])new Object[]{ps.getName().toString(), index});
        }
    }

    private boolean isAttachedToProperty(Node node) {
        for (Node testNode = node; testNode != null; testNode = testNode.getParentNode()) {
            if (node.getNodeType() != 1 || !node.getLocalName().equals("property")) continue;
            return true;
        }
        return false;
    }

    protected Document saveAsDOM(Composite composite) throws XMLStreamException, ContributionWriteException, IOException, SAXException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter writer = this.staxHelper.createXMLStreamWriter((Writer)sw);
        this.processor.write((Object)composite, writer, new ProcessorContext(this.registry));
        writer.close();
        Document document = this.domHelper.load(sw.toString());
        return document;
    }

    protected static String getStructuralURI(Node node) {
        if (node != null) {
            QName name = new QName(node.getNamespaceURI(), node.getLocalName());
            if (COMPONENT.equals(name)) {
                Element element = (Element)node;
                return element.getAttributeNS(null, "uri");
            }
            if (SERVICE.equals(name)) {
                Element component = (Element)node.getParentNode();
                String uri = component.getAttributeNS(null, "uri");
                String service = ((Element)node).getAttributeNS(null, "name");
                return uri + "#service(" + service + ")";
            }
            if (REFERENCE.equals(name)) {
                Element component = (Element)node.getParentNode();
                String uri = component.getAttributeNS(null, "uri");
                String reference = ((Element)node).getAttributeNS(null, "name");
                return uri + "#reference(" + reference + ")";
            }
            if (COMPOSITE.equals(name)) {
                return "";
            }
            String localName = node.getLocalName();
            if (localName.startsWith("binding.")) {
                boolean callback = false;
                String bindingName = ((Element)node).getAttributeNS(null, "name");
                Element contract = (Element)node.getParentNode();
                if ("callback".equals(contract.getLocalName())) {
                    callback = true;
                    contract = (Element)contract.getParentNode();
                }
                String contractName = contract.getAttributeNS(null, "name");
                Element component = (Element)contract.getParentNode();
                String uri = component.getAttributeNS(null, "uri");
                if (callback) {
                    return uri + "#" + contract.getLocalName() + "(" + contractName + "/callback/" + bindingName + ")";
                }
                return uri + "#" + contract.getLocalName() + "(" + contractName + "/" + bindingName + ")";
            }
            if (localName.startsWith("implementation.")) {
                Element component = (Element)node.getParentNode();
                String uri = component.getAttributeNS(null, "uri");
                return uri + "#implementation()";
            }
            if (localName.startsWith("interface.")) {
                Element contract = (Element)node.getParentNode();
                String contractName = contract.getAttributeNS(null, "name");
                Element component = (Element)node.getParentNode().getParentNode();
                String uri = component.getAttributeNS(null, "uri");
                return uri + "#" + contractName + "#interface()";
            }
        }
        return null;
    }

    protected Binding getBinding(Contract contract, String name, boolean isCallback) {
        List bindings = null;
        bindings = isCallback ? contract.getCallback().getBindings() : contract.getBindings();
        for (Binding binding : bindings) {
            if (!name.equals(binding.getName())) continue;
            return binding;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PolicySubject lookup(Composite composite, String structuralURI) {
        if (structuralURI == null) {
            return null;
        }
        if (structuralURI.equals("")) {
            return composite;
        }
        int index = structuralURI.indexOf(35);
        String componentURI = structuralURI;
        String service = null;
        String reference = null;
        String binding = null;
        boolean isInterface = false;
        boolean impl = false;
        boolean isCallback = false;
        if (index != -1) {
            componentURI = structuralURI.substring(0, index);
            String fragment = structuralURI.substring(index + 1);
            int begin = fragment.indexOf(40);
            int end = fragment.indexOf(41);
            if (begin != -1 && end != -1) {
                String path = fragment.substring(begin + 1, end).trim();
                String prefix = fragment.substring(0, begin).trim();
                if (prefix.equals("implementation")) {
                    impl = true;
                } else {
                    int pos = path.indexOf(47);
                    if (pos != -1) {
                        binding = path.substring(pos + 1);
                        if (binding.startsWith("callback/")) {
                            binding = path.substring(pos + 10);
                            isCallback = true;
                        }
                        path = path.substring(0, pos);
                        if ("service-binding".equals(prefix)) {
                            service = path;
                        } else if ("reference-binding".equals(prefix)) {
                            reference = path;
                        }
                    }
                    if ("service".equals(prefix)) {
                        service = path;
                    } else if ("reference".equals(prefix)) {
                        reference = path;
                    } else if (prefix.indexOf("#interface") != -1) {
                        service = prefix.substring(0, prefix.indexOf("#interface"));
                        isInterface = true;
                    }
                }
            }
        }
        for (Component component : composite.getComponents()) {
            if (component.getURI().equals(componentURI)) {
                Binding b;
                if (service != null) {
                    ComponentService componentService = component.getService(service);
                    if (isInterface) {
                        return componentService.getInterfaceContract().getInterface();
                    }
                    if (binding == null) return componentService;
                    b = this.getBinding((Contract)componentService, binding, isCallback);
                    if (!(b instanceof PolicySubject)) return component;
                    return (PolicySubject)b;
                }
                if (reference != null) {
                    ComponentReference componentReference = component.getReference(reference);
                    if (binding == null) return componentReference;
                    b = this.getBinding((Contract)componentReference, binding, isCallback);
                    if (!(b instanceof PolicySubject)) return component;
                    return (PolicySubject)b;
                }
                if (!impl) return component;
                return component.getImplementation();
            }
            if (!structuralURI.startsWith(component.getURI() + "/")) continue;
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) return null;
            return this.lookup((Composite)implementation, structuralURI);
        }
        return null;
    }
}

