/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.builder.impl.BindingURIBuilderImpl;
import org.apache.tuscany.sca.builder.impl.ComponentBuilderImpl;
import org.apache.tuscany.sca.builder.impl.ComponentReferenceBindingBuilderImpl;
import org.apache.tuscany.sca.builder.impl.ComponentServiceBindingBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositeCloneBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositeComponentTypeBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositeIncludeBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositePolicyBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositeWireApplierImpl;
import org.apache.tuscany.sca.builder.impl.EndpointBuilderImpl;
import org.apache.tuscany.sca.builder.impl.EndpointReferenceBuilderImpl;
import org.apache.tuscany.sca.builder.impl.PolicyAttachmentBuilderImpl;
import org.apache.tuscany.sca.builder.impl.StructuralURIBuilderImpl;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class ModelBuilderImpl
implements CompositeBuilder {
    private ExtensionPointRegistry registry;
    private CompositeBuilder compositeIncludeBuilder;
    private CompositeBuilder compositeCloneBuilder;
    private CompositeComponentTypeBuilderImpl compositeComponentTypeBuilder;
    private ComponentBuilderImpl componentBuilder;
    private CompositeBuilder structuralURIBuilder;
    private BindingURIBuilderImpl bindingURIBuilder;
    private ComponentServiceBindingBuilderImpl componentServiceBindingBuilder;
    private ComponentReferenceBindingBuilderImpl componentReferenceBindingBuilder;
    private CompositeBuilder compositeWireApplier;
    private EndpointBuilderImpl endpointBuilder;
    private EndpointReferenceBuilderImpl endpointReferenceBuilder;
    private CompositeBuilder policyAttachmentBuilder;
    private CompositePolicyBuilderImpl compositePolicyBuilder;

    public ModelBuilderImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.compositeIncludeBuilder = new CompositeIncludeBuilderImpl();
        this.compositeCloneBuilder = new CompositeCloneBuilderImpl();
        this.compositeComponentTypeBuilder = new CompositeComponentTypeBuilderImpl(registry);
        this.componentBuilder = new ComponentBuilderImpl(registry);
        this.compositeComponentTypeBuilder.setComponentBuilder(this.componentBuilder);
        this.componentBuilder.setComponentTypeBuilder(this.compositeComponentTypeBuilder);
        this.structuralURIBuilder = new StructuralURIBuilderImpl(registry);
        this.bindingURIBuilder = new BindingURIBuilderImpl(registry);
        this.componentServiceBindingBuilder = new ComponentServiceBindingBuilderImpl(registry);
        this.componentReferenceBindingBuilder = new ComponentReferenceBindingBuilderImpl(registry);
        this.compositeWireApplier = new CompositeWireApplierImpl(registry);
        this.endpointBuilder = new EndpointBuilderImpl(registry);
        this.endpointReferenceBuilder = new EndpointReferenceBuilderImpl(registry);
        this.policyAttachmentBuilder = new PolicyAttachmentBuilderImpl(registry);
        this.compositePolicyBuilder = new CompositePolicyBuilderImpl(registry);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeBuilder";
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        try {
            composite = this.compositeCloneBuilder.build(composite, context);
            composite = this.compositeIncludeBuilder.build(composite, context);
            composite = this.structuralURIBuilder.build(composite, context);
            composite = this.policyAttachmentBuilder.build(composite, context);
            this.compositeComponentTypeBuilder.createComponentType(null, composite, context);
            composite = this.bindingURIBuilder.build(composite, context);
            composite = this.componentServiceBindingBuilder.build(composite, context);
            composite = this.componentReferenceBindingBuilder.build(composite, context);
            composite = this.compositeWireApplier.build(composite, context);
            this.endpointBuilder.build(composite, context);
            this.endpointReferenceBuilder.build(composite, context);
            composite = this.compositePolicyBuilder.build(composite, context);
            return composite;
        }
        catch (Exception e) {
            throw new CompositeBuilderException("Exception while building model " + composite.getName(), (Throwable)e);
        }
    }

    public String dumpBuiltComposite(Composite composite) {
        StAXArtifactProcessorExtensionPoint xmlProcessors = (StAXArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor compositeProcessor = xmlProcessors.getProcessor(Composite.class);
        return this.writeComposite(composite, (StAXArtifactProcessor<Composite>)compositeProcessor);
    }

    private String writeComposite(Composite composite, StAXArtifactProcessor<Composite> compositeProcessor) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = (XMLOutputFactory)((FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class)).getFactory(XMLOutputFactory.class);
        try {
            compositeProcessor.write((Object)composite, outputFactory.createXMLStreamWriter(bos), new ProcessorContext(this.registry));
        }
        catch (Exception ex) {
            return ex.toString();
        }
        String result = bos.toString();
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            result = result + "\n<!-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX -->\n" + this.writeComposite((Composite)component.getImplementation(), compositeProcessor);
        }
        return result;
    }
}

