/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.builder.impl.ComponentPolicyBuilderImpl;
import org.apache.tuscany.sca.builder.impl.PolicyAppliesToBuilderImpl;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.util.PolicyHelper;

public class CompositePolicyBuilderImpl
extends ComponentPolicyBuilderImpl
implements CompositeBuilder {
    private static final QName NOLISTENER_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "noListener");
    private CompositeBuilder policyAppliesToBuilder = null;

    public CompositePolicyBuilderImpl(ExtensionPointRegistry registry) {
        super(registry);
        this.policyAppliesToBuilder = new PolicyAppliesToBuilderImpl(registry);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositePolicyBuilder";
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.computePolicies(composite, context);
        this.checkPolicies(composite, context);
        this.buildPolicies(composite, context);
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computePolicies(Composite composite, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        monitor.pushContext((Object)("Composite: " + composite.getName().toString()));
        try {
            this.resolveAndCheck((PolicySubject)composite, context);
            for (Component component : composite.getComponents()) {
                monitor.pushContext((Object)("Component: " + component.getName()));
                this.resolveAndCheck((PolicySubject)component, context);
                try {
                    Implementation implementation = component.getImplementation();
                    for (ComponentService componentService : component.getServices()) {
                        monitor.pushContext((Object)("Service: " + componentService.getName()));
                        try {
                            this.resolveAndCheck((PolicySubject)componentService, context);
                            if (componentService.getInterfaceContract() != null) {
                                this.resolveAndCheck((PolicySubject)componentService.getInterfaceContract().getInterface(), context);
                                this.resolveAndCheck((PolicySubject)componentService.getInterfaceContract().getCallbackInterface(), context);
                            }
                            for (Endpoint ep : componentService.getEndpoints()) {
                                this.inherit((PolicySubject)ep, null, true, ep.getBinding());
                                this.inherit((PolicySubject)ep, null, true, ep.getService(), ep.getComponent(), composite);
                                if (componentService.getInterfaceContract() != null) {
                                    this.inherit((PolicySubject)ep, null, false, componentService.getInterfaceContract().getInterface());
                                }
                                this.addDefaultIntents((PolicySubject)ep, ep.getBinding(), context);
                                this.resolveAndNormalize((PolicySubject)ep, context);
                                this.expandDefaultIntents((PolicySubject)ep, context);
                                this.removeConstrainedIntents((PolicySubject)ep, context);
                                this.removeDirectPolicySetsIfExternalExists((PolicySubject)ep, context);
                                this.checkForNoListenerIntent(ep, context);
                                this.checkIntentsResolved((PolicySubject)ep, context);
                                this.checkMutualExclusion((PolicySubject)ep, context);
                            }
                        }
                        finally {
                            monitor.popContext();
                        }
                    }
                    for (ComponentReference componentReference : component.getReferences()) {
                        monitor.pushContext((Object)("Reference: " + componentReference.getName().toString()));
                        try {
                            if (componentReference.getInterfaceContract() != null) {
                                this.resolveAndCheck((PolicySubject)componentReference.getInterfaceContract().getInterface(), context);
                                this.resolveAndCheck((PolicySubject)componentReference.getInterfaceContract().getCallbackInterface(), context);
                            }
                            for (EndpointReference epr : componentReference.getEndpointReferences()) {
                                this.inherit((PolicySubject)epr, null, true, epr.getBinding());
                                this.inherit((PolicySubject)epr, null, true, epr.getReference(), epr.getComponent(), composite);
                                if (componentReference.getInterfaceContract() != null) {
                                    this.inherit((PolicySubject)epr, null, true, componentReference.getInterfaceContract().getInterface());
                                }
                                this.addDefaultIntents((PolicySubject)epr, epr.getBinding(), context);
                                this.resolveAndNormalize((PolicySubject)epr, context);
                                this.expandDefaultIntents((PolicySubject)epr, context);
                                this.removeConstrainedIntents((PolicySubject)epr, context);
                                this.removeDirectPolicySetsIfExternalExists((PolicySubject)epr, context);
                                this.checkIntentsResolved((PolicySubject)epr, context);
                                this.checkMutualExclusion((PolicySubject)epr, context);
                            }
                        }
                        finally {
                            monitor.popContext();
                        }
                    }
                    if (implementation instanceof Composite) {
                        this.resolveAndCheck((PolicySubject)implementation, context);
                        this.inherit((PolicySubject)implementation, Intent.Type.implementation, true, component, composite);
                        this.computePolicies((Composite)implementation, context);
                        this.expandDefaultIntents((PolicySubject)implementation, context);
                        this.checkIntentsResolved((PolicySubject)implementation, context);
                        continue;
                    }
                    this.resolveAndCheck((PolicySubject)implementation, context);
                    if (implementation == null) continue;
                    this.inherit((PolicySubject)implementation, Intent.Type.implementation, true, component, composite);
                    this.removeConstrainedIntents((PolicySubject)implementation, context);
                    this.removeDirectPolicySetsIfExternalExists((PolicySubject)implementation, context);
                    this.expandDefaultIntents((PolicySubject)implementation, context);
                    this.checkIntentsResolved((PolicySubject)implementation, context);
                }
                finally {
                    monitor.popContext();
                }
            }
            this.removeConstrainedIntents((PolicySubject)composite, context);
        }
        finally {
            monitor.popContext();
        }
    }

    private void validateTransactionIntents(Composite composite, BuilderContext context) {
        for (Component component : composite.getComponents()) {
            if (component.getImplementation() == null) continue;
            if (component.getImplementation() instanceof Composite) {
                this.validateTransactionIntents((Composite)component.getImplementation(), context);
            }
            for (Intent implIntent : component.getImplementation().getRequiredIntents()) {
                if (Constants.MANAGED_TRANSACTION_LOCAL_INTENT.equals(implIntent.getName())) {
                    for (ComponentReference reference : component.getReferences()) {
                        for (EndpointReference epr : reference.getEndpointReferences()) {
                            for (Intent eprIntent : epr.getRequiredIntents()) {
                                if (Constants.TRANSACTED_ONE_WAY_INTENT.equals(eprIntent.getName())) {
                                    this.error(context.getMonitor(), "TransactedOneWayWithManagedTransactionLocal", this, "reference", epr.getComponent().getName(), epr.getReference().getName());
                                    continue;
                                }
                                if (!Constants.PROPAGATES_TRANSACTION_INTENT.equals(eprIntent.getName())) continue;
                                this.error(context.getMonitor(), "PropagatesTransactionWithLocalTran", this, "reference", epr.getComponent().getName(), epr.getReference().getName());
                            }
                        }
                    }
                    for (ComponentService service : component.getServices()) {
                        for (Endpoint ep : service.getEndpoints()) {
                            for (Intent epIntent : ep.getRequiredIntents()) {
                                if (Constants.TRANSACTED_ONE_WAY_INTENT.equals(epIntent.getName())) {
                                    this.error(context.getMonitor(), "TransactedOneWayWithManagedTransactionLocal", this, "service", ep.getComponent().getName(), ep.getService().getName());
                                    continue;
                                }
                                if (!Constants.PROPAGATES_TRANSACTION_INTENT.equals(epIntent.getName())) continue;
                                this.error(context.getMonitor(), "PropagatesTransactionWithLocalTran", this, "service", ep.getComponent().getName(), ep.getService().getName());
                            }
                        }
                    }
                    continue;
                }
                if (!Constants.NO_MANAGED_TRANSACTION_INTENT.equals(implIntent.getName())) continue;
                for (ComponentService service : component.getServices()) {
                    for (Endpoint ep : service.getEndpoints()) {
                        for (Intent epIntent : ep.getRequiredIntents()) {
                            if (!Constants.PROPAGATES_TRANSACTION_INTENT.equals(epIntent.getName())) continue;
                            this.error(context.getMonitor(), "PropagatesTransactionWithNoManagedTran", this, "service", ep.getComponent().getName(), ep.getService().getName());
                        }
                    }
                }
                for (ComponentReference reference : component.getReferences()) {
                    for (EndpointReference epr : reference.getEndpointReferences()) {
                        for (Intent eprIntent : epr.getRequiredIntents()) {
                            if (!Constants.PROPAGATES_TRANSACTION_INTENT.equals(eprIntent.getName())) continue;
                            this.error(context.getMonitor(), "PropagatesTransactionWithNoManagedTran", this, "reference", epr.getComponent().getName(), epr.getReference().getName());
                        }
                    }
                }
            }
            for (ComponentReference reference : component.getReferences()) {
                for (EndpointReference epr : reference.getEndpointReferences()) {
                    for (Intent eprIntent : epr.getRequiredIntents()) {
                        if (Constants.TRANSACTED_ONE_WAY_INTENT.equals(eprIntent.getName())) {
                            for (Operation o : epr.getComponentReferenceInterfaceContract().getInterface().getOperations()) {
                                if (o.isNonBlocking()) continue;
                                this.error(context.getMonitor(), "TransactedOneWayWithTwoWayOp", this, reference.getName(), o.getName());
                            }
                            continue;
                        }
                        if (!Constants.IMMEDIATE_ONE_WAY_INTENT.equals(eprIntent.getName())) continue;
                        for (Operation o : epr.getComponentReferenceInterfaceContract().getInterface().getOperations()) {
                            if (o.isNonBlocking()) continue;
                            this.error(context.getMonitor(), "ImmediateOneWayWithTwoWayOp", this, reference.getName(), o.getName());
                        }
                    }
                }
            }
        }
    }

    private void checkForNoListenerIntent(Endpoint ep, BuilderContext context) {
        PolicyHelper helper = new PolicyHelper();
        if (PolicyHelper.getIntent((PolicySubject)ep, (QName)NOLISTENER_INTENT) != null) {
            this.error(context.getMonitor(), "NoListenerIntentSpecifiedOnService", this, ep.toString());
        }
    }

    private void removeDirectPolicySetsIfExternalExists(PolicySubject subject, BuilderContext context) {
        boolean foundExternalPolicySet = false;
        for (PolicySet ps : subject.getPolicySets()) {
            if (!ps.isExternalAttachment()) continue;
            foundExternalPolicySet = true;
            break;
        }
        if (foundExternalPolicySet) {
            ArrayList copy = new ArrayList(subject.getPolicySets());
            for (PolicySet ps : copy) {
                if (ps.isExternalAttachment()) continue;
                subject.getPolicySets().remove(ps);
            }
        }
    }

    protected void checkPolicies(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.policyAppliesToBuilder.build(composite, context);
        this.validateTransactionIntents(composite, context);
    }

    protected void buildPolicies(Composite composite, BuilderContext context) {
        Implementation implementation;
        for (Component component : composite.getComponents()) {
            implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.buildPolicies((Composite)implementation, context);
        }
        for (Component component : composite.getComponents()) {
            PolicyBuilder builder;
            Set<String> policyNames;
            for (ComponentService componentService : component.getServices()) {
                for (Endpoint ep : componentService.getEndpoints()) {
                    policyNames = this.getPolicyNames((PolicySubject)ep);
                    if (policyNames.size() > 1) {
                        this.error(context.getMonitor(), "MultiplePolicyLanguagesInEP", this, ep.toString(), policyNames.toString());
                        continue;
                    }
                    for (PolicySet ps : ep.getPolicySets()) {
                        for (PolicyExpression exp : ps.getPolicies()) {
                            builder = this.builders.getPolicyBuilder(exp.getName());
                            if (builder == null) continue;
                            builder.build(ep, context);
                        }
                    }
                }
            }
            for (ComponentReference componentReference : component.getReferences()) {
                for (EndpointReference epr : componentReference.getEndpointReferences()) {
                    policyNames = this.getPolicyNames((PolicySubject)epr);
                    if (policyNames.size() > 1) {
                        this.error(context.getMonitor(), "MultiplePolicyLanguagesInEPR", this, epr.toString(), policyNames.toString());
                        continue;
                    }
                    for (PolicySet ps : epr.getPolicySets()) {
                        for (PolicyExpression exp : ps.getPolicies()) {
                            builder = this.builders.getPolicyBuilder(exp.getName());
                            if (builder == null) continue;
                            builder.build(epr, context);
                        }
                    }
                }
            }
            implementation = component.getImplementation();
            if (implementation == null) continue;
            Set<String> policyNames2 = this.getPolicyNames((PolicySubject)implementation);
            if (policyNames2.size() > 1) {
                this.error(context.getMonitor(), "MultiplePolicyLanguagesInImplementation", this, component.toString(), policyNames2.toString());
                continue;
            }
            for (PolicySet ps : implementation.getPolicySets()) {
                for (PolicyExpression exp : ps.getPolicies()) {
                    PolicyBuilder builder2 = this.builders.getPolicyBuilder(exp.getName());
                    if (builder2 == null) continue;
                    builder2.build(component, implementation, context);
                }
            }
        }
    }
}

