/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;

public class CompositeCloneBuilderImpl
implements CompositeBuilder {
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        if (Composite.DOMAIN_COMPOSITE.equals(composite.getName())) {
            for (Composite included : composite.getIncludes()) {
                this.cloneIncludes(included);
                this.cloneCompositeImplementations(included);
            }
        } else {
            this.cloneIncludes(composite);
            this.cloneCompositeImplementations(composite);
        }
        return composite;
    }

    private void cloneIncludes(Composite composite) {
        ArrayList<Composite> includes = new ArrayList<Composite>();
        for (Composite included : composite.getIncludes()) {
            try {
                includes.add((Composite)included.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        composite.getIncludes().clear();
        composite.getIncludes().addAll(includes);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeCloneBuilder";
    }

    private void cloneCompositeImplementations(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            Composite compositeImplementation = (Composite)implementation;
            try {
                Composite clone = (Composite)compositeImplementation.clone();
                component.setImplementation((Implementation)clone);
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }
}

