/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;

public class ComponentReferenceBindingBuilderImpl
implements CompositeBuilder {
    private BuilderExtensionPoint builders;

    public ComponentReferenceBindingBuilderImpl(ExtensionPointRegistry registry) {
        this.builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
    }

    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.buildReferenceBindings(composite, context);
        return composite;
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferenceBindingBuilder";
    }

    private void buildReferenceBindings(Composite composite, BuilderContext context) {
        for (Component component : composite.getComponents()) {
            for (ComponentReference componentReference : component.getReferences()) {
                for (Binding binding : componentReference.getBindings()) {
                    BindingBuilder builder = this.builders.getBindingBuilder(binding.getType());
                    if (builder == null) continue;
                    builder.build(component, (Contract)componentReference, binding, context, false);
                }
            }
        }
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.buildReferenceBindings((Composite)implementation, context);
        }
    }
}

