/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.DefaultIntent;
import org.apache.tuscany.sca.policy.DefaultingPolicySubject;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.Qualifier;

public class ComponentPolicyBuilderImpl {
    protected BuilderExtensionPoint builders;

    public ComponentPolicyBuilderImpl(ExtensionPointRegistry registry) {
        this.builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
    }

    protected void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        Monitor.warning((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.builder.builder-validation-messages", (String)message, (Object[])messageParameters);
    }

    protected void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        Monitor.error((Monitor)monitor, (Object)this, (String)"org.apache.tuscany.sca.builder.builder-validation-messages", (String)message, (Object[])messageParameters);
    }

    protected void inherit(PolicySubject policySubject, Intent.Type intentType, boolean ignoreExclusiveIntents, Object ... models) {
        for (Object model : models) {
            if (!(model instanceof PolicySubject)) continue;
            PolicySubject subject = (PolicySubject)model;
            if (!ignoreExclusiveIntents) {
                for (Intent intent : subject.getRequiredIntents()) {
                    if (policySubject.getRequiredIntents().contains(intent)) continue;
                    if (intent.getType() != null && intentType != null) {
                        if (!intent.getType().equals((Object)intentType)) continue;
                        policySubject.getRequiredIntents().add(intent);
                        continue;
                    }
                    policySubject.getRequiredIntents().add(intent);
                }
            } else {
                HashSet<Intent> intents = new HashSet<Intent>();
                for (Intent i1 : subject.getRequiredIntents()) {
                    boolean exclusive = false;
                    for (Intent i2 : policySubject.getRequiredIntents()) {
                        if (!i1.getExcludedIntents().contains(i2) && !i2.getExcludedIntents().contains(i1)) continue;
                        exclusive = true;
                        break;
                    }
                    if (exclusive || intents.contains(i1)) continue;
                    if (intentType != null) {
                        if (!i1.getType().equals((Object)intentType)) continue;
                        intents.add(i1);
                        continue;
                    }
                    intents.add(i1);
                }
                policySubject.getRequiredIntents().addAll(intents);
            }
            for (PolicySet policySet : subject.getPolicySets()) {
                if (policySubject.getPolicySets().contains(policySet)) continue;
                policySubject.getPolicySets().add(policySet);
            }
        }
    }

    protected void configure(PolicySubject subject1, PolicySubject subject2, Intent.Type intentType, BuilderContext context) {
        if (subject1 != null) {
            this.resolveAndCheck(subject1, context);
        }
        if (subject2 != null) {
            this.resolveAndCheck(subject2, context);
        }
        this.inherit(subject1, intentType, false, subject2);
        this.checkMutualExclusion(subject1, context);
    }

    protected void configure(ComponentService componentService, BuilderContext context) {
        Service service = componentService.getService();
        if (service != null) {
            this.configure((PolicySubject)componentService, (PolicySubject)service, null, context);
            this.configureBindings((Contract)componentService, (Contract)service, context);
        }
    }

    private void configureBindings(Contract componentContract, Contract componentTypeContract, BuilderContext context) {
        if (componentTypeContract == null) {
            return;
        }
        HashMap<String, Binding> componentTypeContractBindings = new HashMap<String, Binding>();
        for (Binding binding : componentTypeContract.getBindings()) {
            componentTypeContractBindings.put(binding.getName(), binding);
        }
        for (Binding binding : componentContract.getBindings()) {
            Binding componentTypeBinding = (Binding)componentTypeContractBindings.get(binding.getName());
            if (!(binding instanceof PolicySubject) || !(componentTypeBinding instanceof PolicySubject)) continue;
            this.configure((PolicySubject)binding, (PolicySubject)componentTypeBinding, Intent.Type.interaction, context);
        }
    }

    protected void configure(ComponentReference componentReference, BuilderContext context) {
        Reference reference = componentReference.getReference();
        if (reference != null) {
            this.configure((PolicySubject)componentReference, (PolicySubject)reference, null, context);
            this.configureBindings((Contract)componentReference, (Contract)reference, context);
        }
    }

    protected void configure(CompositeService compositeService, BuilderContext context) {
        this.configure((PolicySubject)compositeService, (PolicySubject)compositeService.getPromotedService(), null, context);
    }

    protected void configure(CompositeReference compositeReference, BuilderContext context) {
        for (ComponentReference reference : compositeReference.getPromotedReferences()) {
            this.configure((PolicySubject)compositeReference, (PolicySubject)reference, null, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Component component, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        for (ComponentService componentService : component.getServices()) {
            monitor.pushContext((Object)("Service: " + componentService.getName()));
            try {
                this.configure((PolicySubject)componentService, (PolicySubject)component.getImplementation(), Intent.Type.interaction, context);
                this.removeConstrainedIntents((PolicySubject)componentService, context);
            }
            finally {
                monitor.popContext();
            }
        }
        for (ComponentReference componentReference : component.getReferences()) {
            monitor.pushContext((Object)("Reference: " + componentReference.getName()));
            try {
                this.configure(componentReference, context);
                this.removeConstrainedIntents((PolicySubject)componentReference, context);
            }
            finally {
                monitor.popContext();
            }
        }
        for (ComponentService componentService : component.getServices()) {
            monitor.pushContext((Object)("Service: " + componentService.getName()));
            try {
                this.configure(componentService, context);
                this.removeConstrainedIntents((PolicySubject)componentService, context);
            }
            finally {
                monitor.popContext();
            }
        }
    }

    protected boolean checkQualifiedMutualExclusion(List<Intent> excludedIntentList, Intent intent) {
        for (Intent excludedIntent : excludedIntentList) {
            if (intent.getQualifiableIntent() == null || excludedIntent == null || !intent.getQualifiableIntent().equals(excludedIntent)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMutualExclusion(Intent i1, Intent i2, BuilderContext context) {
        if (i1 != i2 && (i1.getExcludedIntents().contains(i2) || i2.getExcludedIntents().contains(i1) || this.checkQualifiedMutualExclusion(i1.getExcludedIntents(), i2) || this.checkQualifiedMutualExclusion(i2.getExcludedIntents(), i1))) {
            this.error(context.getMonitor(), "MutuallyExclusiveIntentsAtBuild", this, i1, i2);
            return true;
        }
        return false;
    }

    protected boolean checkMutualExclusion(PolicySubject subject1, BuilderContext context) {
        if (subject1 == null) {
            return false;
        }
        for (Intent i1 : subject1.getRequiredIntents()) {
            for (Intent i2 : subject1.getRequiredIntents()) {
                if (!this.checkMutualExclusion(i1, i2, context)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMutualExclusion(PolicySubject subject1, PolicySubject subject2, BuilderContext context) {
        if (subject1 == subject2 || subject1 == null || subject2 == null) {
            return false;
        }
        for (Intent i1 : subject1.getRequiredIntents()) {
            for (Intent i2 : subject2.getRequiredIntents()) {
                if (!this.checkMutualExclusion(i1, i2, context)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean resolveAndCheck(PolicySubject subject, BuilderContext context) {
        if (subject == null) {
            return false;
        }
        this.resolveAndNormalize(subject, context);
        this.checkMutualExclusion(subject, context);
        return false;
    }

    protected boolean isEqual(String name1, String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 != null) {
            return name1.equals(name2);
        }
        return name2.equals(name1);
    }

    protected static Intent resolve(Definitions definitions, Intent proxy) {
        for (Intent i : definitions.getIntents()) {
            if (i.equals(proxy)) {
                return i;
            }
            for (Intent qi : i.getQualifiedIntents()) {
                if (!qi.equals(proxy)) continue;
                return qi;
            }
        }
        return null;
    }

    protected void expandDefaultIntents(PolicySubject subject, BuilderContext context) {
        HashSet copy = new HashSet(subject.getRequiredIntents());
        for (Intent i : copy) {
            if (i.getDefaultQualifiedIntent() == null) continue;
            subject.getRequiredIntents().remove(i);
            subject.getRequiredIntents().add(i.getDefaultQualifiedIntent());
        }
    }

    protected void resolveAndNormalize(PolicySubject subject, BuilderContext context) {
        Definitions definitions = context.getDefinitions();
        HashSet<Intent> intents = new HashSet<Intent>();
        if (definitions != null) {
            for (Intent i : subject.getRequiredIntents()) {
                Intent resolved = ComponentPolicyBuilderImpl.resolve(definitions, i);
                if (resolved != null) {
                    intents.add(resolved);
                    continue;
                }
                this.error(context.getMonitor(), "IntentNotFoundAtBuild", subject, i);
            }
        }
        while (!intents.isEmpty()) {
            boolean profileIntentsFound = false;
            HashSet copy = new HashSet(intents);
            for (Intent i : copy) {
                if (i.getRequiredIntents().isEmpty()) continue;
                intents.remove(i);
                intents.addAll(i.getRequiredIntents());
                profileIntentsFound = true;
            }
            if (profileIntentsFound) continue;
            break;
        }
        HashSet copy = new HashSet(intents);
        for (Intent i : copy) {
            if (i.getQualifiableIntent() == null) continue;
            intents.remove(i.getQualifiableIntent());
        }
        subject.getRequiredIntents().clear();
        subject.getRequiredIntents().addAll(intents);
        HashSet policySets = new HashSet();
        if (definitions != null) {
            for (PolicySet policySet : subject.getPolicySets()) {
                if (policySet.isUnresolved()) {
                    int index = definitions.getPolicySets().indexOf(policySet);
                    if (index != -1) {
                        policySets.add(definitions.getPolicySets().get(index));
                        continue;
                    }
                    this.warning(context.getMonitor(), "PolicySetNotFoundAtBuild", subject, policySet);
                    continue;
                }
                policySets.add(policySet);
            }
        }
        subject.getPolicySets().clear();
        subject.getPolicySets().addAll(policySets);
    }

    protected void removeConstrainedIntents(PolicySubject subject, BuilderContext context) {
        List intents = subject.getRequiredIntents();
        ExtensionType extensionType = subject.getExtensionType();
        if (extensionType != null) {
            ArrayList copy = new ArrayList(intents);
            for (Intent i : copy) {
                List constrainedTypes = i.getConstrainedTypes();
                if (constrainedTypes.size() == 0 && i.getQualifiableIntent() != null) {
                    constrainedTypes = i.getQualifiableIntent().getConstrainedTypes();
                }
                if (constrainedTypes.size() <= 0) continue;
                boolean constraintFound = false;
                for (ExtensionType constrainedType : constrainedTypes) {
                    if (!constrainedType.getType().equals(extensionType.getType()) && !constrainedType.getType().equals(extensionType.getBaseType())) continue;
                    constraintFound = true;
                    break;
                }
                if (constraintFound) continue;
                intents.remove(i);
            }
        }
    }

    protected void checkIntentsResolved(PolicySubject subject, BuilderContext context) {
        for (Intent intent : subject.getRequiredIntents()) {
            boolean intentMatched = false;
            block1: for (PolicySet ps : subject.getPolicySets()) {
                if (ps.getProvidedIntents().contains(intent)) {
                    intentMatched = true;
                    break;
                }
                for (Intent psProvidedIntent : ps.getProvidedIntents()) {
                    if (!this.isQualifiedBy(psProvidedIntent, intent)) continue;
                    intentMatched = true;
                    break block1;
                }
                for (IntentMap map : ps.getIntentMaps()) {
                    for (Qualifier q : map.getQualifiers()) {
                        if (!intent.equals(q.getIntent())) continue;
                        intentMatched = true;
                        break block1;
                    }
                }
            }
            if (intentMatched) continue;
            ExtensionType type = subject.getExtensionType();
            if (type != null) {
                if (type.getType().getLocalPart().startsWith("implementation")) {
                    for (ImplementationType et : context.getDefinitions().getImplementationTypes()) {
                        if (!type.getType().equals(et.getType())) continue;
                        type = et;
                    }
                } else {
                    for (ImplementationType et : context.getDefinitions().getBindingTypes()) {
                        if (!type.getType().equals(et.getType())) continue;
                        type = et;
                    }
                }
            }
            if (type != null && (type.getAlwaysProvidedIntents().contains(intent) || type.getMayProvidedIntents().contains(intent))) continue;
            if (subject instanceof EndpointReference) {
                this.warning(context.getMonitor(), "IntentNotSatisfiedAtBuild", subject, intent.getName(), subject.toString());
                continue;
            }
            this.error(context.getMonitor(), "IntentNotSatisfiedAtBuild", subject, intent.getName(), subject.toString());
        }
    }

    protected Set<String> getPolicyNames(PolicySubject subject) {
        if (subject == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                names.add(exp.getName().getNamespaceURI());
            }
        }
        return names;
    }

    protected boolean isQualifiedBy(Intent qualifiableIntent, Intent qualifiedIntent) {
        return qualifiedIntent.getQualifiableIntent() == qualifiableIntent;
    }

    protected void addDefaultIntents(PolicySubject subject, Object defaultSubjectObject, BuilderContext context) {
        if (!(defaultSubjectObject instanceof DefaultingPolicySubject)) {
            return;
        }
        DefaultingPolicySubject defaultSubject = (DefaultingPolicySubject)defaultSubjectObject;
        List defaultIntents = defaultSubject.getDefaultIntents();
        for (DefaultIntent defaultIntent : defaultIntents) {
            boolean addDefaultIntent = true;
            for (Intent mutualExclusion : defaultIntent.getMutuallyExclusiveIntents()) {
                if (!subject.getRequiredIntents().contains(mutualExclusion)) continue;
                addDefaultIntent = false;
                break;
            }
            for (Intent userDefinedIntent : subject.getRequiredIntents()) {
                if (this.checkMutualExclusionNoError(defaultIntent.getIntent(), userDefinedIntent, context)) continue;
                addDefaultIntent = false;
                break;
            }
            if (!addDefaultIntent) continue;
            subject.getRequiredIntents().add(defaultIntent.getIntent());
        }
    }

    protected boolean checkMutualExclusionNoError(Intent i1, Intent i2, BuilderContext context) {
        return i1 != i2 && (i1.getExcludedIntents().contains(i2) || i2.getExcludedIntents().contains(i1) || this.checkQualifiedMutualExclusion(i1.getExcludedIntents(), i2) || this.checkQualifiedMutualExclusion(i2.getExcludedIntents(), i1));
    }
}

