/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package javax.resource.spi;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.Documented;

import javax.resource.spi.work.WorkContext;

/**
 * @since 1.6
 * @version $Rev: 901922 $ $Date: 2010-01-21 18:25:52 -0500 (Thu, 21 Jan 2010) $
 */
@Documented
@Retention(value= RetentionPolicy.RUNTIME)
@Target(value= ElementType.TYPE)
public @interface Connector {

    AuthenticationMechanism[] authMechanisms() default {};

    String[] description() default {};

    String[] displayName() default {};

    String eisType() default "";

    String[] largeIcon() default {};

    String[] licenseDescription() default {};

    boolean licenseRequired() default false;

    boolean reauthenticationSupport() default false;

    Class<? extends WorkContext>[] requiredWorkContexts() default {};

    SecurityPermission[] securityPermissions() default {};

    String[] smallIcon() default {};

    TransactionSupport.TransactionSupportLevel transactionSupport() default TransactionSupport.TransactionSupportLevel.NoTransaction;

    String vendorName() default "";

    String version() default "";

}
