/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

final class TinkerIndex<T extends Element> {
    protected Map<String, Map<Object, Set<T>>> index = new ConcurrentHashMap<String, Map<Object, Set<T>>>();
    protected final Class<T> indexClass;
    private final Set<String> indexedKeys = new HashSet<String>();
    private final TinkerGraph graph;

    public TinkerIndex(TinkerGraph graph, Class<T> indexClass) {
        this.graph = graph;
        this.indexClass = indexClass;
    }

    protected void put(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            this.index.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = this.index.get(key);
        }
        if (null == (objects = keyMap.get(value))) {
            keyMap.putIfAbsent(value, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(value);
        }
        objects.add(element);
    }

    public List<T> get(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return Collections.emptyList();
        }
        Set<T> set = keyMap.get(TinkerIndex.indexable(value));
        if (null == set) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(set);
    }

    public long count(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return 0L;
        }
        Set<T> set = keyMap.get(TinkerIndex.indexable(value));
        if (null == set) {
            return 0L;
        }
        return set.size();
    }

    public void remove(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(TinkerIndex.indexable(value)))) {
            objects.remove(element);
            if (objects.size() == 0) {
                keyMap.remove(value);
            }
        }
    }

    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            for (Map<Object, Set<T>> map : this.index.values()) {
                for (Set<T> set : map.values()) {
                    set.remove(element);
                }
            }
        }
    }

    public void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.indexedKeys.contains(key)) {
            this.remove(key, oldValue, element);
            this.put(key, newValue, element);
        }
    }

    public void createKeyIndex(String key) {
        if (null == key) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("The key for the index cannot be an empty string");
        }
        if (this.indexedKeys.contains(key)) {
            return;
        }
        this.indexedKeys.add(key);
        (Vertex.class.isAssignableFrom(this.indexClass) ? this.graph.vertices.values().parallelStream() : this.graph.edges.values().parallelStream()).map(e -> new Object[]{e.property(key), e}).filter(a -> ((Property)a[0]).isPresent()).forEach(a -> this.put(key, ((Property)a[0]).value(), (Element)a[1]));
    }

    public void dropKeyIndex(String key) {
        if (this.index.containsKey(key)) {
            this.index.remove(key).clear();
        }
        this.indexedKeys.remove(key);
    }

    public static Object indexable(Object obj) {
        return null == obj ? IndexedNull.instance() : obj;
    }

    public Set<String> getIndexedKeys() {
        return this.indexedKeys;
    }

    public static final class IndexedNull {
        private static final IndexedNull inst = new IndexedNull();

        private IndexedNull() {
        }

        static IndexedNull instance() {
            return inst;
        }

        public int hashCode() {
            return 751912123;
        }

        public boolean equals(Object o) {
            return o instanceof IndexedNull;
        }
    }
}

