/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.BlockManagerBasedBlockHandler;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.RpcUtils$;
import org.spark_project.guava.base.Throwables;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0017'\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0004\u0001A\u0012!d\b\t\u0004\u001dmi\u0012B\u0001\u000f\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u0010 \u0019\u0001!\u0011\u0002I\f\u0002\u0002\u0003\u0005)\u0011A\u0011\u0003\u0007}#\u0013'\u0005\u0002#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t9aj\u001c;iS:<\u0007CA\u0012*\u0013\tQCEA\u0002B]fD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0004K:4\bC\u0001\u00180\u001b\u00051\u0011B\u0001\u0019\u0007\u0005!\u0019\u0006/\u0019:l\u000b:4\b\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00025s5\tQG\u0003\u00027o\u0005!1m\u001c8g\u0015\tA\u0004\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003uU\u0012QbQ8oM&<WO]1uS>t\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002'\rDWmY6q_&tG\u000fR5s\u001fB$\u0018n\u001c8\u0011\u0007\rr\u0004)\u0003\u0002@I\t1q\n\u001d;j_:\u0004\"!\u0011#\u000f\u0005\r\u0012\u0015BA\"%\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r#\u0003\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\bF\u0003K\u0017B\u000b&\u000b\u0005\u0002\u000f\u0001!)1a\u0012a\u0001\u0019B\u0012Qj\u0014\t\u0004\u001dmq\u0005C\u0001\u0010P\t%\u00013*!A\u0001\u0002\u000b\u0005\u0011\u0005C\u0003-\u000f\u0002\u0007Q\u0006C\u00033\u000f\u0002\u00071\u0007C\u0003=\u000f\u0002\u0007Q\bC\u0004U\u0001\t\u0007I\u0011B+\u0002\t!|7\u000f^\u000b\u0002\u0001\"1q\u000b\u0001Q\u0001\n\u0001\u000bQ\u0001[8ti\u0002Bq!\u0017\u0001C\u0002\u0013%Q+\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Daa\u0017\u0001!\u0002\u0013\u0001\u0015aC3yK\u000e,Ho\u001c:JI\u0002Bq!\u0018\u0001C\u0002\u0013%a,\u0001\u000bsK\u000e,\u0017N^3e\u00052|7m\u001b%b]\u0012dWM]\u000b\u0002?B\u0011a\u0002Y\u0005\u0003C\n\u0011ACU3dK&4X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u0014\bBB2\u0001A\u0003%q,A\u000bsK\u000e,\u0017N^3e\u00052|7m\u001b%b]\u0012dWM\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006yAO]1dW\u0016\u0014XI\u001c3q_&tG/F\u0001h!\tA7.D\u0001j\u0015\tQg!A\u0002sa\u000eL!\u0001\\5\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\"1a\u000e\u0001Q\u0001\n\u001d\f\u0001\u0003\u001e:bG.,'/\u00128ea>Lg\u000e\u001e\u0011\t\u000fA\u0004!\u0019!C\u0005M\u0006AQM\u001c3q_&tG\u000f\u0003\u0004s\u0001\u0001\u0006IaZ\u0001\nK:$\u0007o\\5oi\u0002Bq\u0001\u001e\u0001C\u0002\u0013%Q/\u0001\u0006oK^\u0014En\\2l\u0013\u0012,\u0012A\u001e\t\u0004o\u0006\u0005Q\"\u0001=\u000b\u0005eT\u0018AB1u_6L7M\u0003\u0002|y\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ut\u0018\u0001B;uS2T\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004a\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0011\u001d\t9\u0001\u0001Q\u0001\nY\f1B\\3x\u00052|7m[%eA!I\u00111\u0002\u0001C\u0002\u0013%\u0011QB\u0001\u001ae\u0016<\u0017n\u001d;fe\u0016$'\t\\8dW\u001e+g.\u001a:bi>\u00148/\u0006\u0002\u0002\u0010A1\u0011\u0011CA\n\u0003/i\u0011A_\u0005\u0004\u0003+Q(!F\"p]\u000e,(O]3oi2Kgn[3e#V,W/\u001a\t\u0004\u001d\u0005e\u0011bAA\u000e\u0005\tq!\t\\8dW\u001e+g.\u001a:bi>\u0014\b\u0002CA\u0010\u0001\u0001\u0006I!a\u0004\u00025I,w-[:uKJ,GM\u00117pG.<UM\\3sCR|'o\u001d\u0011\t\u0013\u0005\r\u0002A1A\u0005\n\u0005\u0015\u0012!\b3fM\u0006,H\u000e\u001e\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\u0016\u0005\u0005\u001d\"CBA\u0015\u0003c\t9DB\u0004\u0002,\u00055\u0002!a\n\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\u0011\u0005=\u0002\u0001)A\u0005\u0003O\ta\u0004Z3gCVdGO\u00117pG.<UM\\3sCR|'\u000fT5ti\u0016tWM\u001d\u0011\u0011\u0007\r\n\u0019$C\u0002\u00026\u0011\u0012a!\u00118z%\u00164\u0007c\u0001\b\u0002:%\u0019\u00111\b\u0002\u0003-\tcwnY6HK:,'/\u0019;pe2K7\u000f^3oKJD\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\u0002+\u0011,g-Y;mi\ncwnY6HK:,'/\u0019;peV\u0011\u0011q\u0003\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002\u0018\u00051B-\u001a4bk2$(\t\\8dW\u001e+g.\u001a:bi>\u0014\b\u0005\u0003\u0005\u0002J\u0001!\t\u0005BA&\u0003M9W\r^\"veJ,g\u000e\u001e*bi\u0016d\u0015.\\5u+\t\ti\u0005E\u0002$\u0003\u001fJ1!!\u0015%\u0005\u0011auN\\4\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005Q\u0001/^:i'&tw\r\\3\u0015\t\u0005e\u0013q\f\t\u0004G\u0005m\u0013bAA/I\t!QK\\5u\u0011\u001d\t\t'a\u0015A\u0002!\nA\u0001Z1uC\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014a\u00049vg\"\f%O]1z\u0005V4g-\u001a:\u0015\u0011\u0005e\u0013\u0011NAC\u0003\u0017C\u0001\"a\u001b\u0002d\u0001\u0007\u0011QN\u0001\fCJ\u0014\u0018-\u001f\"vM\u001a,'\u000f\r\u0003\u0002p\u0005\u0005\u0005CBA9\u0003w\ny(\u0004\u0002\u0002t)!\u0011QOA<\u0003\u001diW\u000f^1cY\u0016T1!!\u001f%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\n\u0019HA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u0001\u0010\u0002\u0002\u0012Y\u00111QA5\u0003\u0003\u0005\tQ!\u0001\"\u0005\ryFe\r\u0005\t\u0003\u000f\u000b\u0019\u00071\u0001\u0002\n\u0006qQ.\u001a;bI\u0006$\u0018m\u00149uS>t\u0007cA\u0012?Q!A\u0011QRA2\u0001\u0004\ty)A\u0007cY>\u001c7.\u00133PaRLwN\u001c\t\u0005Gy\n\t\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9JB\u0001\bgR|'/Y4f\u0013\u0011\tY*!&\u0003\u001bM#(/Z1n\u00052|7m[%e\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000bA\u0002];tQ&#XM]1u_J$\u0002\"!\u0017\u0002$\u0006\u001d\u0017\u0011\u001a\u0005\t\u0003K\u000bi\n1\u0001\u0002(\u0006A\u0011\u000e^3sCR|'\u000f\r\u0003\u0002*\u0006\r\u0007CBAV\u0003w\u000b\tM\u0004\u0003\u0002.\u0006]f\u0002BAX\u0003kk!!!-\u000b\u0007\u0005M\u0006$\u0001\u0004=e>|GOP\u0005\u0002K%\u0019\u0011\u0011\u0018\u0013\u0002\u000fA\f7m[1hK&!\u0011QXA`\u0005!IE/\u001a:bi>\u0014(bAA]IA\u0019a$a1\u0005\u0017\u0005\u0015\u00171UA\u0001\u0002\u0003\u0015\t!\t\u0002\u0004?\u0012\"\u0004\u0002CAD\u0003;\u0003\r!!#\t\u0011\u00055\u0015Q\u0014a\u0001\u0003\u001fCq!!4\u0001\t\u0003\ty-A\u0005qkND')\u001f;fgRA\u0011\u0011LAi\u0003C\f\u0019\u000f\u0003\u0005\u0002T\u0006-\u0007\u0019AAk\u0003\u0015\u0011\u0017\u0010^3t!\u0011\t9.!8\u000e\u0005\u0005e'bAAn}\u0006\u0019a.[8\n\t\u0005}\u0017\u0011\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002CAD\u0003\u0017\u0004\r!!#\t\u0011\u00055\u00151\u001aa\u0001\u0003\u001fCq!a:\u0001\t\u0003\tI/\u0001\nqkND\u0017I\u001c3SKB|'\u000f\u001e\"m_\u000e\\G\u0003CA-\u0003W\f)0a>\t\u0011\u00055\u0018Q\u001da\u0001\u0003_\fQB]3dK&4X\r\u001a\"m_\u000e\\\u0007c\u0001\b\u0002r&\u0019\u00111\u001f\u0002\u0003\u001bI+7-Z5wK\u0012\u0014En\\2l\u0011!\t9)!:A\u0002\u0005%\u0005\u0002CAG\u0003K\u0004\r!a$\t\u000f\u0005m\b\u0001\"\u0001\u0002~\u0006Y!/\u001a9peR,%O]8s)\u0019\tI&a@\u0003\u0004!9!\u0011AA}\u0001\u0004\u0001\u0015aB7fgN\fw-\u001a\u0005\t\u0005\u000b\tI\u00101\u0001\u0003\b\u0005)QM\u001d:peB!\u00111\u0016B\u0005\u0013\u0011\u0011Y!a0\u0003\u0013QC'o\\<bE2,\u0007b\u0002B\b\u0001\u0011E#\u0011C\u0001\b_:\u001cF/\u0019:u)\t\tI\u0006C\u0004\u0003\u0016\u0001!\tFa\u0006\u0002\r=t7\u000b^8q)\u0019\tIF!\u0007\u0003\u001c!9!\u0011\u0001B\n\u0001\u0004\u0001\u0005\u0002\u0003B\u0003\u0005'\u0001\rA!\b\u0011\t\rr$q\u0001\u0005\b\u0005C\u0001A\u0011\u000bB\u0012\u0003=ygNU3dK&4XM]*uCJ$HC\u0001B\u0013!\r\u0019#qE\u0005\u0004\u0005S!#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005[\u0001A\u0011\u000bB\u0018\u00039ygNU3dK&4XM]*u_B$b!!\u0017\u00032\tM\u0002b\u0002B\u0001\u0005W\u0001\r\u0001\u0011\u0005\t\u0005\u000b\u0011Y\u00031\u0001\u0003\u001e!9!q\u0007\u0001\u0005B\te\u0012\u0001F2sK\u0006$XM\u00117pG.<UM\\3sCR|'\u000f\u0006\u0003\u0002\u0018\tm\u0002\u0002\u0003B\u001f\u0005k\u0001\r!a\u000e\u0002-\tdwnY6HK:,'/\u0019;pe2K7\u000f^3oKJDqA!\u0011\u0001\t\u0013\u0011\u0019%A\u0006oKb$(\t\\8dW&#WCAAI\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013\n\u0001c\u00197fC:,\bo\u00147e\u00052|7m[:\u0015\t\u0005e#1\n\u0005\t\u0005\u001b\u0012)\u00051\u0001\u0003P\u0005\t2\r\\3b]V\u0004H\u000b\u001b:fg\"$\u0016.\\3\u0011\t\tE#1K\u0007\u0002\t%\u0019!Q\u000b\u0003\u0003\tQKW.\u001a")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    private final Receiver<?> receiver;
    public final SparkEnv org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env;
    private final String host;
    private final String executorId;
    private final ReceivedBlockHandler receivedBlockHandler;
    private final RpcEndpointRef trackerEndpoint;
    private final RpcEndpointRef endpoint;
    private final AtomicLong newBlockId;
    private final ConcurrentLinkedQueue<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    private final BlockGeneratorListener defaultBlockGeneratorListener;
    private final BlockGenerator defaultBlockGenerator;

    private String host() {
        return this.host;
    }

    private String executorId() {
        return this.executorId;
    }

    private ReceivedBlockHandler receivedBlockHandler() {
        return this.receivedBlockHandler;
    }

    private RpcEndpointRef trackerEndpoint() {
        return this.trackerEndpoint;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    public ConcurrentLinkedQueue<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    }

    private BlockGeneratorListener defaultBlockGeneratorListener() {
        return this.defaultBlockGeneratorListener;
    }

    private BlockGenerator defaultBlockGenerator() {
        return this.defaultBlockGenerator;
    }

    @Override
    public long getCurrentRateLimit() {
        return this.defaultBlockGenerator().getCurrentLimit();
    }

    @Override
    public void pushSingle(Object data) {
        this.defaultBlockGenerator().addData(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ArrayBufferBlock(arrayBuffer), metadataOption, blockIdOption);
    }

    @Override
    public void pushIterator(Iterator<?> iterator, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new IteratorBlock(iterator), metadataOption, blockIdOption);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ByteBufferBlock(bytes), metadataOption, blockIdOption);
    }

    public void pushAndReportBlock(ReceivedBlock receivedBlock, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        StreamBlockId blockId = (StreamBlockId)blockIdOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        ReceivedBlockStoreResult blockStoreResult = this.receivedBlockHandler().storeBlock(blockId, receivedBlock);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;
            private final long time$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed block ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$1))}));
            }
            {
                this.blockId$1 = blockId$1;
                this.time$1 = time$1;
            }
        });
        Option<Object> numRecords2 = blockStoreResult.numRecords();
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), numRecords2, metadataOption, blockStoreResult);
        this.trackerEndpoint().askSync((Object)new AddBlock(blockInfo), ClassTag$.MODULE$.Boolean());
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reported block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().send((Object)new ReportError(this.streamId(), message, errorString));
        this.logWarning((Function0<String>)new Serializable(this, message, error){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Throwable error$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported error ").append((Object)this.message$1).append((Object)" - ").append((Object)this.error$1).toString();
            }
            {
                this.message$1 = message$1;
                this.error$1 = error$1;
            }
        });
    }

    @Override
    public void onStart() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$1) {
                x$1.start();
            }
        });
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        ReceivedBlockHandler receivedBlockHandler = this.receivedBlockHandler();
        if (receivedBlockHandler instanceof WriteAheadLogBasedBlockHandler) {
            WriteAheadLogBasedBlockHandler writeAheadLogBasedBlockHandler = (WriteAheadLogBasedBlockHandler)receivedBlockHandler;
            writeAheadLogBasedBlockHandler.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$2) {
                x$2.stop();
            }
        });
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv().stop(this.endpoint());
    }

    @Override
    public boolean onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.receiver.getClass().getSimpleName(), this.host(), this.executorId(), this.endpoint());
        return BoxesRunTime.unboxToBoolean((Object)this.trackerEndpoint().askSync((Object)msg, ClassTag$.MODULE$.Boolean()));
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deregistering receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String errorString = (String)error.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().askSync((Object)new DeregisterReceiver(this.streamId(), message, errorString), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Stopped receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockGenerator createBlockGenerator(BlockGeneratorListener blockGeneratorListener) {
        void var3_3;
        Iterable stoppedGenerators = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BlockGenerator x$3) {
                return x$3.isStopped();
            }
        });
        stoppedGenerators.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final boolean apply(BlockGenerator x$4) {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().remove(x$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        BlockGenerator newBlockGenerator = new BlockGenerator(blockGeneratorListener, this.streamId(), this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.conf(), BlockGenerator$.MODULE$.$lessinit$greater$default$4());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().add(newBlockGenerator);
        return var3_3;
    }

    public StreamBlockId org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public void org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(Time cleanupThreshTime) {
        this.logDebug((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning up blocks older then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        this.receivedBlockHandler().cleanupOldBlocks(cleanupThreshTime.milliseconds());
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env, Configuration hadoopConf, Option<String> checkpointDirOption) {
        Logging logging;
        this.receiver = receiver;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env = env;
        super(receiver, env.conf());
        this.host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
        this.executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(env.conf())) {
            if (checkpointDirOption.isEmpty()) {
                throw new SparkException("Cannot enable receiver write-ahead log without checkpoint directory set. Please use streamingContext.checkpoint() to set the checkpoint directory. See documentation for more details.");
            }
            logging = new WriteAheadLogBasedBlockHandler(env.blockManager(), env.serializerManager(), receiver.streamId(), receiver.storageLevel(), env.conf(), hadoopConf, (String)checkpointDirOption.get(), WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$8());
        } else {
            logging = new BlockManagerBasedBlockHandler(env.blockManager(), receiver.storageLevel());
        }
        this.receivedBlockHandler = logging;
        this.trackerEndpoint = RpcUtils$.MODULE$.makeDriverRef("ReceiverTracker", env.conf(), env.rpcEnv());
        this.endpoint = env.rpcEnv().setupEndpoint(new StringBuilder().append((Object)"Receiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString(), (RpcEndpoint)new ThreadSafeRpcEndpoint(this){
            private final RpcEnv rpcEnv;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final RpcEndpointRef self() {
                return RpcEndpoint.class.self((RpcEndpoint)this);
            }

            public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
                return RpcEndpoint.class.receiveAndReply((RpcEndpoint)this, (RpcCallContext)context);
            }

            public void onError(Throwable cause) {
                RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
            }

            public void onConnected(RpcAddress remoteAddress) {
                RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onDisconnected(RpcAddress remoteAddress) {
                RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
                RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
            }

            public void onStart() {
                RpcEndpoint.class.onStart((RpcEndpoint)this);
            }

            public void onStop() {
                RpcEndpoint.class.onStop((RpcEndpoint)this);
            }

            public final void stop() {
                RpcEndpoint.class.stop((RpcEndpoint)this);
            }

            public RpcEnv rpcEnv() {
                return this.rpcEnv;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (StopReceiver$.MODULE$.equals(A1)) {
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Received stop signal";
                                }
                            });
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().stop("Stopped by driver", (Option<Throwable>)None$.MODULE$);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof CleanupOldBlocks) {
                            CleanupOldBlocks cleanupOldBlocks2 = (CleanupOldBlocks)A1;
                            Time threshTime = cleanupOldBlocks2.threshTime();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logDebug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Received delete old batch signal";
                                }
                            });
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(threshTime);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof UpdateRateLimit) {
                            UpdateRateLimit updateRateLimit = (UpdateRateLimit)A1;
                            long eps = updateRateLimit.elementsPerSecond();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)new Serializable(this, eps){
                                public static final long serialVersionUID = 0L;
                                private final long eps$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a new rate limit: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.eps$1)}));
                                }
                                {
                                    this.eps$1 = eps$1;
                                }
                            });
                            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1)new Serializable(this, eps){
                                public static final long serialVersionUID = 0L;
                                private final long eps$1;

                                public final void apply(BlockGenerator bg) {
                                    bg.updateRate(this.eps$1);
                                }
                                {
                                    this.eps$1 = eps$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        boolean bl = StopReceiver$.MODULE$.equals(object) ? true : (object instanceof CleanupOldBlocks ? true : object instanceof UpdateRateLimit);
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public /* synthetic */ ReceiverSupervisorImpl org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                RpcEndpoint.class.$init$((RpcEndpoint)this);
                this.rpcEnv = $outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv();
            }
        });
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators = new ConcurrentLinkedQueue();
        this.defaultBlockGeneratorListener = new BlockGeneratorListener(this){
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public void onAddData(Object data, Object metadata) {
            }

            public void onGenerateBlock(StreamBlockId blockId) {
            }

            public void onError(String message, Throwable throwable) {
                this.$outer.reportError(message, throwable);
            }

            public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
                this.$outer.pushArrayBuffer(arrayBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)new Some((Object)blockId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.defaultBlockGenerator = this.createBlockGenerator(this.defaultBlockGeneratorListener());
    }
}

