/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tMh!\u0002\u001f>\u0001\rK\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"A!\u000f\u0001B\u0001B\u0003%1\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003x\u0011\u0015i\b\u0001\"\u0001\u007f\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\t\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0017\u0011%\ti\u0004\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA!\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA\u001b\u0011%\t)\u0007\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA5\u0011%\t\t\b\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA\u001b\u0011%\t)\b\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA5\u0011%\tI\b\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA5\u0011%\ti\b\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA5\u0011%\t\t\t\u0001b\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAC\u0011%\ti\n\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAQ\u0011%\tI\u000b\u0001b\u0001\n\u0013\tY\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAW\u0011%\t)\f\u0001b\u0001\n\u0003\t9\f\u0003\u0005\u0002L\u0002\u0001\u000b\u0011BA]\u0011%\ti\r\u0001b\u0001\n\u0013\ty\r\u0003\u0005\u0002^\u0002\u0001\u000b\u0011BAi\u0011%\ty\u000e\u0001b\u0001\n\u0013\t\t\u000f\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAr\u0011%\t9\u000f\u0001b\u0001\n\u0013\tY\u000b\u0003\u0005\u0002j\u0002\u0001\u000b\u0011BAW\u0011)\tY\u000f\u0001b\u0001\n\u0003i\u0014q\u0002\u0005\t\u0003[\u0004\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u001e\u0001A\u0002\u0013%\u0011\u0011\u001f\u0005\n\u0003s\u0004\u0001\u0019!C\u0005\u0003wD\u0001Ba\u0002\u0001A\u0003&\u00111\u001f\u0005\n\u0005\u0013\u0001\u0001\u0019!C\u0005\u0005\u0017A\u0011B!\u0007\u0001\u0001\u0004%IAa\u0007\t\u0011\t}\u0001\u0001)Q\u0005\u0005\u001bAqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0011\u001d\u00119\n\u0001C\u0005\u00053CqAa,\u0001\t\u0013\u0011\tl\u0002\u0005\u0003BvB\ta\u0011Bb\r\u001daT\b#\u0001D\u0005\u000bDa!`\u001d\u0005\u0002\t\u001d\u0007b\u0002Bes\u0011\u0005!1\u001a\u0002\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s\u0015\tqt(A\u0002lqMT!\u0001Q!\u0002\u000f\rdWo\u001d;fe*\u0011!iQ\u0001\ng\u000eDW\rZ;mKJT!\u0001R#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\n\u0004\u0001)\u0003\u0006CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%AB!osJ+g\r\u0005\u0002R)6\t!K\u0003\u0002T\u0007\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002V%\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002Z56\t1)\u0003\u0002\\\u0007\nI1\u000b]1sW\u000e{gNZ\u0001\u0007g\u0016\u001cWj\u001a:\u0011\u0005es\u0016BA0D\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018aD3yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0011\u0005\t\u001cW\"A\u001f\n\u0005\u0011l$!G&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005\u001d\u0004X\"\u00015\u000b\u0005%T\u0017AB2mS\u0016tGO\u0003\u0002lY\u0006Q1.\u001e2fe:,G/Z:\u000b\u00055t\u0017a\u00024bEJL7\r\u000f\u0006\u0002_\u0006\u0011\u0011n\\\u0005\u0003c\"\u0014\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011!\r^\u0005\u0003kv\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fQa\u00197pG.\u0004\"\u0001_>\u000e\u0003eT!A_\"\u0002\tU$\u0018\u000e\\\u0005\u0003yf\u0014Qa\u00117pG.\fa\u0001P5oSRtD#D@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY\u0001\u0005\u0002c\u0001!)ak\u0002a\u00011\")Al\u0002a\u0001;\")\u0001m\u0002a\u0001C\")Qm\u0002a\u0001M\")!o\u0002a\u0001g\")ao\u0002a\u0001o\u0006\u0019R\tW#D+R{%kX%E?\u000e{UK\u0014+F%V\u0011\u0011\u0011\u0003\t\u0005\u0003'\t\u0019#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0019\tGo\\7jG*!\u00111DA\u000f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004u\u0006}!BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0012Q\u0003\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)\u0015CViQ+U\u001fJ{\u0016\nR0D\u001fVsE+\u0012*!\u0003)\"x\u000e^1m\u000bb\u0004Xm\u0019;fI\u0016CXmY;u_J\u001c\b+\u001a:SKN|WO]2f!J|g-\u001b7f\u0013\u0012,\"!!\f\u0011\u0011\u0005=\u0012\u0011GA\u001b\u0003ki!!!\u0007\n\t\u0005M\u0012\u0011\u0004\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA&\u00028%\u0019\u0011\u0011\b'\u0003\u0007%sG/A\u0016u_R\fG.\u0012=qK\u000e$X\rZ#yK\u000e,Ho\u001c:t!\u0016\u0014(+Z:pkJ\u001cW\r\u0015:pM&dW-\u00133!\u0003U\u0011\b/\u00133U_J+7o\\;sG\u0016\u0004&o\u001c4jY\u0016,\"!!\u0011\u0011\u0011\u0005\r\u0013QJA\u001b\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\b[V$\u0018M\u00197f\u0015\r\tY\u0005T\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0003\u000b\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fQ\u0001\te\u0016\u001cx.\u001e:dK&!\u00111LA+\u0005=\u0011Vm]8ve\u000e,\u0007K]8gS2,\u0017A\u0006:q\u0013\u0012$vNU3t_V\u00148-\u001a)s_\u001aLG.\u001a\u0011\u0002#A|G-\u00117m_\u000e\fG/[8o'&TX-\u0006\u0002\u00026\u0005\u0011\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3!\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]\u0012+G.Y=\u0016\u0005\u0005%\u0004cA&\u0002l%\u0019\u0011Q\u000e'\u0003\t1{gnZ\u0001\u0014a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u0017\u0010I\u0001\u000f[\u0006D\b+\u001a8eS:<\u0007k\u001c3t\u0003=i\u0017\r\u001f)f]\u0012Lgn\u001a)pIN\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n\u0011\u0004\u001a:jm\u0016\u0014\bk\u001c3SK\u0006$\u0017N\\3tgRKW.Z8vi\u0006QBM]5wKJ\u0004v\u000e\u001a*fC\u0012Lg.Z:t)&lWm\\;uA\u0005\u0019R\r_3dkR|'/\u00133mKRKW.Z8vi\u0006!R\r_3dkR|'/\u00133mKRKW.Z8vi\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003+sA!!#\u0002\u0012B\u0019\u00111\u0012'\u000e\u0005\u00055%bAAH/\u00061AH]8pizJ1!a%M\u0003\u0019\u0001&/\u001a3fM&!\u0011qSAM\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0013'\u0002\u00159\fW.Z:qC\u000e,\u0007%A\flk\n,'O\\3uKN$%/\u001b<feB{GMT1nKV\u0011\u0011\u0011\u0015\t\u0006\u0017\u0006\r\u0016QQ\u0005\u0004\u0003Kc%AB(qi&|g.\u0001\rlk\n,'O\\3uKN$%/\u001b<feB{GMT1nK\u0002\nQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002.B\u00191*a,\n\u0007\u0005EFJA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0005\u0005e\u0006#B&\u0002$\u0006m\u0006\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003\u000bT\u0017aA1qS&!\u0011\u0011ZA`\u0005\r\u0001v\u000eZ\u0001\u000bIJLg/\u001a:Q_\u0012\u0004\u0013!\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o]\u000b\u0003\u0003#\u0004\u0002\"a\u0011\u0002T\u0006%\u0014q[\u0005\u0005\u0003+\f)EA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\t\b\u0017\u0006e\u0017QGA5\u0013\r\tY\u000e\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0002-9,w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001cW\u000f^8sg\u0002\nqd]2iK\u0012,H.\u001a:L]><hNT3xYf\u001c%/Z1uK\u0012,\u00050Z2t+\t\t\u0019\u000f\u0005\u0005\u0002D\u0005M\u0017\u0011NA\u001b\u0003\u0001\u001a8\r[3ek2,'o\u00138po:tUm\u001e7z\u0007J,\u0017\r^3e\u000bb,7m\u001d\u0011\u00021\u0011Lh.Y7jG\u0006cGn\\2bi&|g.\u00128bE2,G-A\res:\fW.[2BY2|7-\u0019;j_:,e.\u00192mK\u0012\u0004\u0013A\u00058v[>+Ho\u001d;b]\u0012Lgn\u001a)pIN\f1C\\;n\u001fV$8\u000f^1oI&tw\rU8eg\u0002\nA\u0002\\1tiNs\u0017\r]:i_R,\"!a=\u0011\u0007\t\f)0C\u0002\u0002xv\u0012A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\u0018\u0001\u00057bgR\u001cf.\u00199tQ>$x\fJ3r)\u0011\tiPa\u0001\u0011\u0007-\u000by0C\u0002\u0003\u00021\u0013A!\u00168ji\"I!QA\u0016\u0002\u0002\u0003\u0007\u00111_\u0001\u0004q\u0012\n\u0014!\u00047bgR\u001cf.\u00199tQ>$\b%\u0001\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cXC\u0001B\u0007!\u0019\u0011yA!\u0006\u0002j5\u0011!\u0011\u0003\u0006\u0005\u0005'\tI%A\u0005j[6,H/\u00192mK&!!q\u0003B\t\u0005\r\u0019V\r^\u0001\u0017I\u0016dW\r^3e\u000bb,7-\u001e;pe&#7o\u0018\u0013fcR!\u0011Q B\u000f\u0011%\u0011)ALA\u0001\u0002\u0004\u0011i!A\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b\u0005K\u00020\u0005G\u00012a\u0013B\u0013\u0013\r\u00119\u0003\u0014\u0002\tm>d\u0017\r^5mK\u0006)1\u000f^1siR1\u0011Q B\u0017\u0005cAqAa\f1\u0001\u0004\t))A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u0005\b\u0005g\u0001\u0004\u0019\u0001B\u001b\u0003A\u00198\r[3ek2,'OQ1dW\u0016tG\rE\u0002c\u0005oI1A!\u000f>\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0003e\u0019X\r\u001e+pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0015\t\u0005u(q\b\u0005\b\u0005\u0003\n\u0004\u0019\u0001B\"\u0003m\u0011Xm]8ve\u000e,\u0007K]8gS2,Gk\u001c+pi\u0006dW\t_3dgBA\u0011q\u0011B#\u0003#\n)$\u0003\u0003\u0003H\u0005e%aA'ba\u0006I\u0011n\u001d#fY\u0016$X\r\u001a\u000b\u0005\u0003[\u0013i\u0005C\u0004\u0003PI\u0002\r!!\"\u0002\u0015\u0015DXmY;u_JLE-\u0001\bp]:+wo\u00158baNDw\u000e^:\u0015\u0011\u0005u(Q\u000bB,\u00053BqAa\f4\u0001\u0004\t)\tC\u0004\u00034M\u0002\rA!\u000e\t\u000f\tm3\u00071\u0001\u0003^\u0005I1O\\1qg\"|Go\u001d\t\u0007\u0005?\u0012I'a=\u000f\t\t\u0005$Q\r\b\u0005\u0003\u0017\u0013\u0019'C\u0001N\u0013\r\u00119\u0007T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YG!\u001c\u0003\u0007M+\u0017OC\u0002\u0003h1\u000bqbZ3u%\u0016,8/\u00192mKB36i\u001d\u000b\u0007\u0005g\u0012yH!!\u0011\r\u0005\r#Q\u000fB=\u0013\u0011\u00119(!\u0012\u0003\r\t+hMZ3s!\u0011\tiLa\u001f\n\t\tu\u0014q\u0018\u0002\u0016!\u0016\u00148/[:uK:$hk\u001c7v[\u0016\u001cE.Y5n\u0011\u001d\u0011y\u0003\u000ea\u0001\u0003\u000bCqAa!5\u0001\u0004\u0011))A\u0005qm\u000e\u001c\u0018J\\+tKB1!q\fB5\u0003\u000b\u000b1C]3rk\u0016\u001cHOT3x\u000bb,7-\u001e;peN$\"\"!@\u0003\f\n=%\u0011\u0013BK\u0011\u001d\u0011i)\u000ea\u0001\u0003k\taC\\;n\u000bb,7-\u001e;peN$v.\u00117m_\u000e\fG/\u001a\u0005\b\u0005_)\u0004\u0019AAC\u0011\u001d\u0011\u0019*\u000ea\u0001\u0003k\t\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e\u0011\u001d\u0011\u0019)\u000ea\u0001\u0005\u000b\u000b1C]3qY\u0006\u001cW\r\u0015,Dg&3g*Z3eK\u0012$\u0002Ba'\u0003$\n\u001d&1\u0016\t\u0007\u0005?\u0012IG!(\u0011\t\u0005u&qT\u0005\u0005\u0005C\u000byLA\u0006ICNlU\r^1eCR\f\u0007b\u0002BSm\u0001\u0007\u00111X\u0001\u0004a>$\u0007b\u0002BUm\u0001\u0007!1T\u0001\ne\u0016\u001cx.\u001e:dKNDqA!,7\u0001\u0004\u0011\u0019(\u0001\u0007sKV\u001c\u0018M\u00197f!Z\u001b5/\u0001\fjg\u0016CXmY;u_JLE\r\\3US6,GmT;u)\u0019\tiKa-\u0003>\"9!QW\u001cA\u0002\t]\u0016!B:uCR,\u0007c\u00012\u0003:&\u0019!1X\u001f\u0003!\u0015CXmY;u_J\u0004v\u000eZ*uCR,\u0007b\u0002B`o\u0001\u0007\u0011\u0011N\u0001\fGV\u0014(/\u001a8u)&lW-A\u000bFq\u0016\u001cW\u000f^8s!>$7/\u00117m_\u000e\fGo\u001c:\u0011\u0005\tL4CA\u001dK)\t\u0011\u0019-\u0001\u0006ta2LGo\u00157piN,BA!4\u0003XR1!q\u001aBu\u0005_\u0004bAa\u0018\u0003j\tE\u0007cB&\u0002Z\nM\u0017Q\u0007\t\u0005\u0005+\u00149\u000e\u0004\u0001\u0005\u000f\te7H1\u0001\u0003\\\n\tA+\u0005\u0003\u0003^\n\r\bcA&\u0003`&\u0019!\u0011\u001d'\u0003\u000f9{G\u000f[5oOB\u00191J!:\n\u0007\t\u001dHJA\u0002B]fDqAa;<\u0001\u0004\u0011i/A\u0005d_:\u001cX/\\3sgB1!q\fB5\u0005'DqA!=<\u0001\u0004\t)$A\u0003tY>$8\u000f")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicInteger EXECUTOR_ID_COUNTER;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final int maxPendingPods;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private volatile scala.collection.immutable.Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> Seq<Tuple2<T, Object>> splitSlots(Seq<T> seq, int n) {
        return ExecutorPodsAllocator$.MODULE$.splitSlots(seq, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicInteger EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private int maxPendingPods() {
        return this.maxPendingPods;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private scala.collection.immutable.Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.driverPod().foreach((Function1 & Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Waitable)this.kubernetesClient.pods().withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        block0: {
            resourceProfileToTotalExecs.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
            if (this.numOutstandingPods().get() != 0) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executorId))));
    }

    private void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        Seq k8sKnownExecIds = (Seq)snapshots.flatMap((Function1 & Serializable)x$2 -> x$2.executorPods().keys());
        this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((IterableOnce)k8sKnownExecIds);
        Seq k8sKnownPVCNames = (Seq)((IterableOps)snapshots.flatMap((Function1 & Serializable)x$3 -> (Iterable)x$3.executorPods().values().map((Function1 & Serializable)x$4 -> x$4.pod()))).flatMap((Function1 & Serializable)pod -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).flatMap((Function1 & Serializable)v -> Option$.MODULE$.apply((Object)v.getPersistentVolumeClaim()).map((Function1 & Serializable)x$5 -> x$5.getClaimName())));
        scala.collection.immutable.Set schedulerKnownExecs = ((IterableOnceOps)schedulerBackend.getExecutorIds().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))))).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((IterableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$7))).mapValues((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long execId = tuple2._1$mcJ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long timeCreated = tuple22._2$mcJ$sp();
            if (currentTime - timeCreated > this.podCreationTimeout()) {
                some = new Some((Object)BoxesRunTime.boxToLong((long)execId));
                return some;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(66).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").toString()).append(new StringBuilder(31).append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString()).toString());
                some = None$.MODULE$;
            }
            return some;
        });
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append(new StringBuilder(44).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").toString()).append(new StringBuilder(62).append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").toString()).append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((IterableOnceOps)timedOut.toSeq().map((Function1 & Serializable)x$9 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(BoxesRunTime.unboxToLong((Object)x$9)))).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            scala.collection.immutable.Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds.elem).filter((Function1)(JFunction1.mcZJ.sp & Serializable)elem -> existingExecs.contains((Object)BoxesRunTime.boxToLong((long)elem)));
        }
        MapView notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable)x$10 -> !((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$10)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((IterableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        IntRef totalNotRunningPodCount = IntRef.create((int)0);
        Seq podsToAllocateWithRpId = (Seq)((IterableOps)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).toSeq().sortBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)x0$3 -> {
            int podCountForRpId;
            LinkedHashMap newlyCreatedExecutorsForRpId;
            int targetNum;
            int rpId;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                rpId = tuple2._1$mcI$sp();
                targetNum = tuple2._2$mcI$sp();
                HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable)() -> HashMap$.MODULE$.empty());
                int currentRunningCount = podsForRpId.values().count((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22(x0$4)));
                Tuple2 tuple22 = ((StrictOptimizedIterableOps)podsForRpId.filter((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$23(x0$5)))).partition((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(schedulerKnownExecs, x0$6)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
                HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
                Tuple2 tuple24 = tuple23;
                HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple24._1();
                HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple24._2();
                IntRef pendingCountForRpId = IntRef.create((int)currentPendingExecutorsForRpId2.size());
                newlyCreatedExecutorsForRpId = (LinkedHashMap)this.newlyCreatedExecutors().filter((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$25(rpId, x0$7)));
                LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$26(rpId, x0$8)));
                if (podsForRpId.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(22).append("ResourceProfile Id: ").append(rpId).append(" (").toString()).append(new StringBuilder(33).append("pod allocation status: ").append(currentRunningCount).append(" running, ").toString()).append(new StringBuilder(18).append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").toString()).append(new StringBuilder(34).append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").toString()).append(new StringBuilder(24).append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").toString()).append(new StringBuilder(39).append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created)").toString()).toString());
                }
                IntRef notRunningPodCountForRpId = IntRef.create((int)(currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()));
                podCountForRpId = currentRunningCount + notRunningPodCountForRpId.elem;
                if (podCountForRpId > targetNum) {
                    scala.collection.mutable.Iterable pendingToDelete;
                    int excess = podCountForRpId - targetNum;
                    List newlyCreatedToDelete = ((IterableOnceOps)((MapOps)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$28(this, currentTime, x0$9)))).keys().take(excess)).toList();
                    List toDelete = (List)newlyCreatedToDelete.$plus$plus((IterableOnce)(pendingToDelete = (scala.collection.mutable.Iterable)((StrictOptimizedIterableOps)((IterableOps)currentPendingExecutorsForRpId2.filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable)x0$10 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$30(x0$10)))));
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        _deletedExecutorIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).$plus$plus((IterableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)x$13 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$33(BoxesRunTime.unboxToLong((Object)x$13))).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)newlyCreatedToDelete);
                            pendingCountForRpId$1.elem -= pendingToDelete.size();
                            notRunningPodCountForRpId$1.elem -= toDelete.size();
                        });
                    }
                }
                totalPendingCount$1.elem += pendingCountForRpId.elem;
                totalNotRunningPodCount$1.elem += notRunningPodCountForRpId.elem;
                if (this.log().isDebugEnabled() && snapshots.nonEmpty()) {
                    int outstanding = pendingCountForRpId.elem + newlyCreatedExecutorsForRpId.size();
                    if (currentRunningCount >= targetNum && !this.dynamicAllocationEnabled()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append(new StringBuilder(63).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").toString()).append("equal to the number of requested executors. Not scaling up further.").toString());
                    } else if (newlyCreatedExecutorsForRpId.nonEmpty()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("Still waiting for ").append(newlyCreatedExecutorsForRpId.size()).append(" executors for ").toString()).append(new StringBuilder(43).append("ResourceProfile Id ").append(rpId).append(" before requesting more.").toString()).toString());
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            None$ none$ = newlyCreatedExecutorsForRpId.isEmpty() && podCountForRpId < targetNum ? new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)rpId), (Object)BoxesRunTime.boxToInteger((int)podCountForRpId), (Object)BoxesRunTime.boxToInteger((int)targetNum))) : None$.MODULE$;
            return none$;
        });
        int remainingSlotFromPendingPods = this.maxPendingPods() - totalNotRunningPodCount.elem;
        if (remainingSlotFromPendingPods > 0 && podsToAllocateWithRpId.size() > 0) {
            ExecutorPodsAllocator$.MODULE$.splitSlots(podsToAllocateWithRpId, remainingSlotFromPendingPods).foreach((Function1 & Serializable)x0$11 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$36(this, applicationId, k8sKnownPVCNames, x0$11);
                return BoxedUnit.UNIT;
            });
        }
        this.deletedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    private Buffer<PersistentVolumeClaim> getReusablePVCs(String applicationId, Seq<String> pvcsInUse) {
        Buffer buffer;
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && this.driverPod().nonEmpty()) {
            Buffer createdPVCs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PersistentVolumeClaimList)((Listable)this.kubernetesClient.persistentVolumeClaims().withLabel("spark-app-selector", applicationId)).list()).getItems()).asScala();
            Buffer reusablePVCs = (Buffer)createdPVCs.filterNot((Function1 & Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)pvcsInUse.contains((Object)pvc.getMetadata().getName())));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Found ").append(reusablePVCs.size()).append(" reusable PVCs from ").append(createdPVCs.size()).append(" PVCs").toString());
            buffer = reusablePVCs;
        } else {
            buffer = (Buffer)Buffer$.MODULE$.empty();
        }
        return buffer;
    }

    private void requestNewExecutors(int numExecutorsToAllocate, String applicationId, int resourceProfileId, Seq<String> pvcsInUse) {
        Buffer<PersistentVolumeClaim> reusablePVCs = this.getReusablePVCs(applicationId, pvcsInUse);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> {
            BoxedUnit boxedUnit;
            int n = x$15;
            int newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
            KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, Integer.toString(newExecutorId), applicationId, this.driverPod(), resourceProfileId);
            KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
            SparkPod executorPod = resolvedExecutorSpec.pod();
            Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
            Seq<HasMetadata> resources = this.replacePVCsIfNeeded(podWithAttachedContainer, resolvedExecutorSpec.executorKubernetesResources(), reusablePVCs);
            Pod createdExecutorPod = (Pod)$this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
            try {
                KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                ((IterableOnceOps)resources.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$2(x$14)))).foreach((Function1 & Serializable)resource -> {
                    if (BoxesRunTime.unboxToBoolean((Object)$this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && this.driverPod().nonEmpty()) {
                        KubernetesUtils$.MODULE$.addOwnerReference((Pod)this.driverPod().get(), (Seq<HasMetadata>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HasMetadata[]{resource}))));
                    }
                    PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").toString()).append(new StringBuilder(13).append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString()).toString());
                    return (PersistentVolumeClaim)$this.kubernetesClient.persistentVolumeClaims().create((Object)pvc);
                });
                this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdExecutorPod});
                    throw e;
                }
                throw throwable;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        });
    }

    private Seq<HasMetadata> replacePVCsIfNeeded(Pod pod, Seq<HasMetadata> resources, Buffer<PersistentVolumeClaim> reusablePVCs) {
        Set replacedResources = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        resources.foreach((Function1 & Serializable)x0$1 -> {
            ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$1(this, reusablePVCs, pod, replacedResources, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)resources.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)replacedResources.contains((Object)elem)));
    }

    private boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long startTime = Instant.parse(state.pod().getStatus().getStartTime()).toEpochMilli();
                if (currentTime - startTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Cannot get startTime of pod ").append(state.pod()).toString());
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResourceProfile rp = (ResourceProfile)tuple2._1();
        int numExecs = tuple2._2$mcI$sp();
        $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable)() -> rp);
        int n = BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        return n;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$14(long x$9) {
        return Long.toString(x$9);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$17(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long execId = tuple2._1$mcJ$sp();
        ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
        int rpId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL())));
        HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$23(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$24(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long k = tuple2._1$mcJ$sp();
        boolean bl = schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$25(int rpId$1, Tuple2 x0$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int waitingRpId = tuple2._1$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$26(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int waitingRpId = tuple2._2$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$28(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$9;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long createTime = tuple2._2$mcJ$sp();
        boolean bl = currentTime$1 - createTime > $this.executorIdleTimeout();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$30(Tuple2 x0$10) {
        long id;
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$33(long x$13) {
        return Long.toString(x$13);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$36(ExecutorPodsAllocator $this, String applicationId$2, Seq k8sKnownPVCNames$1, Tuple2 x0$11) {
        int sharedSlotFromPendingPods;
        Tuple3 tuple3;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$11;
                if (tuple2 == null) break block2;
                tuple3 = (Tuple3)tuple2._1();
                sharedSlotFromPendingPods = tuple2._2$mcI$sp();
                if (tuple3 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int rpId = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int podCountForRpId = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int targetNum = BoxesRunTime.unboxToInt((Object)tuple3._3());
        int numMissingPodsForRpId = targetNum - podCountForRpId;
        int numExecutorsToAllocate = package$.MODULE$.min(package$.MODULE$.min(numMissingPodsForRpId, $this.podAllocationSize()), sharedSlotFromPendingPods);
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").toString()).append(new StringBuilder(41).append("ResourceProfile Id: ").append(rpId).append(", target: ").append(targetNum).append(", known: ").append(podCountForRpId).append(", ").toString()).append(new StringBuilder(28).append("sharedSlotFromPendingPods: ").append(sharedSlotFromPendingPods).append(".").toString()).toString());
        $this.requestNewExecutors(numExecutorsToAllocate, applicationId$2, rpId, (Seq<String>)k8sKnownPVCNames$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$2(HasMetadata x$14) {
        String string = x$14.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$2(PersistentVolumeClaim x2$1, PersistentVolumeClaim p) {
        String string = p.getSpec().getStorageClassName();
        String string2 = x2$1.getSpec().getStorageClassName();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(p.getSpec().getResources().getRequests().get("storage"), x2$1.getSpec().getResources().getRequests().get("storage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$3(PersistentVolumeClaim x2$1, Volume v) {
        if (v.getPersistentVolumeClaim() == null) return false;
        String string = v.getPersistentVolumeClaim().getClaimName();
        String string2 = x2$1.getMetadata().getName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePVCsIfNeeded$1(ExecutorPodsAllocator $this, Buffer reusablePVCs$3, Pod pod$2, Set replacedResources$1, HasMetadata x0$1) {
        HasMetadata hasMetadata = x0$1;
        if (hasMetadata instanceof PersistentVolumeClaim) {
            BoxedUnit boxedUnit;
            PersistentVolumeClaim persistentVolumeClaim = (PersistentVolumeClaim)hasMetadata;
            int index = reusablePVCs$3.indexWhere((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$2(persistentVolumeClaim, p)));
            if (index >= 0) {
                Option volume = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(pod$2.getSpec().getVolumes()).asScala()).find((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$3(persistentVolumeClaim, v)));
                if (volume.nonEmpty()) {
                    PersistentVolumeClaim matchedPVC = (PersistentVolumeClaim)reusablePVCs$3.remove(index);
                    replacedResources$1.add((Object)persistentVolumeClaim);
                    $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Reuse PersistentVolumeClaim ").append(matchedPVC.getMetadata().getName()).toString());
                    ((Volume)volume.get()).getPersistentVolumeClaim().setClaimName(matchedPVC.getMetadata().getName());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicInteger(0);
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.maxPendingPods = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException(new StringBuilder(0).append(new StringBuilder(46).append("No pod was found named ").append((String)name).append(" in the cluster in the ").toString()).append(new StringBuilder(53).append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString()).toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

