/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HandlerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!B\u000f\u001f\u0001\u0011R\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019\u0001\u0007\u0001)A\u0005+\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u0002+\t\r!\u0004\u0001\u0015!\u0003V\u0011\u001dI\u0007A1A\u0005\nQCaA\u001b\u0001!\u0002\u0013)\u0006bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000fE\u0004!\u0019!C\u0005Y\"1!\u000f\u0001Q\u0001\n5Dqa\u001d\u0001C\u0002\u0013%A\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0011\u0019q\b\u0001)A\u0005o\"9q\u0010\u0001b\u0001\n\u0013!\u0006bBA\u0001\u0001\u0001\u0006I!\u0016\u0005\t\u0003\u0007\u0001!\u0019!C\u0005)\"9\u0011Q\u0001\u0001!\u0002\u0013)\u0006\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001bBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003\u0013\u0002A\u0011IA&\u0005a\u0011\u0015m]5d\u000bb,7-\u001e;pe\u001a+\u0017\r^;sKN#X\r\u001d\u0006\u0003?\u0001\n\u0001BZ3biV\u0014Xm\u001d\u0006\u0003C\t\n1a\u001b\u001dt\u0015\t\u0019C%\u0001\u0004eKBdw.\u001f\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sON!\u0001aK\u00196!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!gM\u0007\u0002=%\u0011AG\b\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0011\u0005YJT\"A\u001c\u000b\u0005a\"\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005i:$a\u0002'pO\u001eLgnZ\u0001\u000fWV\u0014WM\u001d8fi\u0016\u001c8i\u001c8g\u0007\u0001\u0001\"AP \u000e\u0003\u0001J!\u0001\u0011\u0011\u0003--+(-\u001a:oKR,7/\u0012=fGV$xN]\"p]\u001a\faa]3d\u001b\u001e\u0014\bCA\"E\u001b\u0005!\u0013BA#%\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018a\u0004:fg>,(oY3Qe>4\u0017\u000e\\3\u0011\u0005![U\"A%\u000b\u0005)#\u0013\u0001\u0003:fg>,(oY3\n\u00051K%a\u0004*fg>,(oY3Qe>4\u0017\u000e\\3\u0002\rqJg.\u001b;?)\u0011y\u0005+\u0015*\u0011\u0005I\u0002\u0001\"B\u001e\u0005\u0001\u0004i\u0004\"B!\u0005\u0001\u0004\u0011\u0005\"\u0002$\u0005\u0001\u00049\u0015AF3yK\u000e,Ho\u001c:D_:$\u0018-\u001b8fe&k\u0017mZ3\u0016\u0003U\u0003\"AV/\u000f\u0005][\u0006C\u0001-.\u001b\u0005I&B\u0001.=\u0003\u0019a$o\\8u}%\u0011A,L\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002][\u00059R\r_3dkR|'oQ8oi\u0006Lg.\u001a:J[\u0006<W\rI\u0001\u0011E2|7m['b]\u0006<WM\u001d)peR,\u0012a\u0019\t\u0003Y\u0011L!!Z\u0017\u0003\u0007%sG/A\tcY>\u001c7.T1oC\u001e,'\u000fU8si\u0002\nQ#\u001a=fGV$xN\u001d)pI:\u000bW.\u001a)sK\u001aL\u00070\u0001\ffq\u0016\u001cW\u000f^8s!>$g*Y7f!J,g-\u001b=!\u0003%!'/\u001b<feV\u0013H.\u0001\u0006ee&4XM]+sY\u0002\n\u0001#[:EK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u00035\u0004\"\u0001\f8\n\u0005=l#a\u0002\"p_2,\u0017M\\\u0001\u0012SN$UMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0013aC5t!f$\bn\u001c8BaB\fA\"[:QsRDwN\\!qa\u0002\n\u0001\u0003Z5tC\ndWmQ8oM&<W*\u00199\u0002#\u0011L7/\u00192mK\u000e{gNZ5h\u001b\u0006\u0004\b%A\u0007fq\u0016\u001c'+Z:pkJ\u001cWm]\u000b\u0002oB\u0011\u0001p\u001f\b\u0003\u0011fL!A_%\u0002\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016L!\u0001`?\u00037\u0015CXmY;u_J\u0014Vm]8ve\u000e,7o\u0014:EK\u001a\fW\u000f\u001c;t\u0015\tQ\u0018*\u0001\bfq\u0016\u001c'+Z:pkJ\u001cWm\u001d\u0011\u0002)\u0015DXmY;u_JlU-\\8ssN#(/\u001b8h\u0003U)\u00070Z2vi>\u0014X*Z7pef\u001cFO]5oO\u0002\nA#\u001a=fGV$xN]\"pe\u0016\u001c(+Z9vKN$\u0018!F3yK\u000e,Ho\u001c:D_J,7OU3rk\u0016\u001cH\u000fI\u0001\u0013Kb,7-\u001e;pe2KW.\u001b;D_J,7/\u0006\u0002\u0002\fA!A&!\u0004V\u0013\r\ty!\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002'\u0015DXmY;u_Jd\u0015.\\5u\u0007>\u0014Xm\u001d\u0011\u0002A\t,\u0018\u000e\u001c3Fq\u0016\u001cW\u000f^8s%\u0016\u001cx.\u001e:dKN\fV/\u00198uSRLWm\u001d\u000b\u0005\u0003/\tI\u0004\u0005\u0004W\u00033)\u0016QD\u0005\u0004\u00037y&aA'baB!\u0011qDA\u001b\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B7pI\u0016d'\u0002BA\u0014\u0003S\t1!\u00199j\u0015\u0011\tY#!\f\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0003\u00020\u0005E\u0012a\u00024bEJL7\r\u000f\u0006\u0003\u0003g\t!![8\n\t\u0005]\u0012\u0011\u0005\u0002\t#V\fg\u000e^5us\"9\u00111H\u000eA\u0002\u0005u\u0012aD2vgR|WNU3t_V\u00148-Z:\u0011\u000bY\u000by$a\u0011\n\u0007\u0005\u0005sLA\u0002TKR\u00042\u0001SA#\u0013\r\t9%\u0013\u0002\u0018\u000bb,7-\u001e;peJ+7o\\;sG\u0016\u0014V-];fgR\fAbY8oM&<WO]3Q_\u0012$B!!\u0014\u0002TA\u0019a(a\u0014\n\u0007\u0005E\u0003E\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u001d\t)\u0006\ba\u0001\u0003\u001b\n1\u0001]8e\u0001")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesExecutorConf kubernetesConf;
    private final SecurityManager secMgr;
    private final ResourceProfile resourceProfile;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final boolean isDefaultProfile;
    private final boolean isPythonApp;
    private final boolean disableConfigMap;
    private final ResourceProfile.ExecutorResourcesOrDefaults execResources;
    private final String executorMemoryString;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public scala.collection.immutable.Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private boolean isDefaultProfile() {
        return this.isDefaultProfile;
    }

    private boolean isPythonApp() {
        return this.isPythonApp;
    }

    private boolean disableConfigMap() {
        return this.disableConfigMap;
    }

    public ResourceProfile.ExecutorResourcesOrDefaults execResources() {
        return this.execResources;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    private scala.collection.immutable.Map<String, Quantity> buildExecutorResourcesQuantities(Set<ExecutorResourceRequest> customResources) {
        return ((IterableOnceOps)customResources.map((Function1 & Serializable)request -> {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.vendor()))) {
                throw new SparkException(new StringBuilder(29).append(new StringBuilder(26).append("Resource: ").append(request.resourceName()).append(" was requested, ").toString()).append("but vendor was not specified.").toString());
            }
            String vendorDomain = request.vendor();
            Quantity quantity = new Quantity(Long.toString(request.amount()));
            return new Tuple2((Object)KubernetesConf$.MODULE$.buildKubernetesResourceName(vendorDomain, request.resourceName()), (Object)quantity);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        Container container;
        Container containerWithLimitCores;
        Nil$ requiredPorts;
        String name2 = new StringBuilder(6).append(this.executorPodNamePrefix()).append("-exec-").append(this.kubernetesConf.executorId()).toString();
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        scala.collection.immutable.Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.kubernetesConf.sparkConf(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Seq<KeyToPath> keyToPaths = KubernetesClientUtils$.MODULE$.buildKeyToPathObjects(confFilesMap);
        String hostname = name2.substring(Math.max(0, name2.length() - 63)).replaceAll("^[^\\w]+", "").replaceAll("[^\\w-]+", "_");
        Quantity executorMemoryQuantity = new Quantity(new StringBuilder(2).append(this.execResources().totalMemMiB()).append("Mi").toString());
        Quantity executorCpuQuantity = new Quantity(this.executorCoresRequest());
        scala.collection.immutable.Map<String, Quantity> executorResourceQuantities = this.buildExecutorResourcesQuantities((Set<ExecutorResourceRequest>)this.execResources().customResources().values().toSet());
        scala.collection.immutable.Seq userOpts = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).toSeq().flatMap((Function1 & Serializable)opts -> {
            String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.executorId());
            return Utils$.MODULE$.splitCommandString(subsOpts);
        });
        scala.collection.immutable.Seq sparkOpts = Utils$.MODULE$.sparkJavaOpts(this.kubernetesConf.sparkConf(), (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        scala.collection.immutable.Seq executorEnv = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)this.driverUrl()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)Integer.toString(this.execResources().cores())), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.kubernetesConf.appId()), new Tuple2((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR(), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)this.kubernetesConf.executorId()), new Tuple2((Object)Constants$.MODULE$.ENV_RESOURCE_PROFILE_ID(), (Object)Integer.toString(this.resourceProfile.id()))})).$plus$plus(this.kubernetesConf.environment())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(k)).withValue(v)).build();
            return envVar;
        })).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})))).$plus$plus((IterableOnce)(((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.AUTH_SECRET_FILE_EXECUTOR())).isEmpty() ? Option$.MODULE$.apply((Object)this.secMgr.getSecretKey()).map((Function1 & Serializable)authSecret -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(SecurityManager$.MODULE$.ENV_AUTH_SECRET())).withValue(authSecret)).build()) : None$.MODULE$))).$plus$plus((IterableOnce)((Option)this.kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH())).map((Function1 & Serializable)cp -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build()))).$plus$plus((IterableOnce)((IterableOps)((IterableOps)userOpts.$plus$plus((IterableOnce)sparkOpts)).zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String opt = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(index).toString())).withValue(opt)).build();
            return envVar;
        }));
        executorEnv.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicExecutorFeatureStep.$anonfun$configurePod$7(x$1))).foreach((Function1 & Serializable)e -> {
            e.setValue(e.getValue().replaceAll(Constants$.MODULE$.ENV_APPLICATION_ID(), this.kubernetesConf.appId()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), this.kubernetesConf.executorId()));
            return BoxedUnit.UNIT;
        });
        Object object = requiredPorts = this.blockManagerPort() != 0 ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))})).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
            return containerPort;
        }) : package$.MODULE$.Nil();
        if (!this.isDefaultProfile() && pod2.container() != null && pod2.container().getResources() != null) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "NOT using the default profile and removing template resources");
            pod2.container().setResources(new ResourceRequirements());
        }
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod2.container()).withName((String)Option$.MODULE$.apply((Object)pod2.container().getName()).getOrElse((Function0 & Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME()))).withImage(this.executorContainerImage())).withImagePullPolicy(this.kubernetesConf.imagePullPolicy())).editOrNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity).addToLimits((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executorResourceQuantities).asJava())).endResources()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container executorContainerWithConfVolume = this.disableConfigMap() ? executorContainer : ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(executorContainer).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Container container2 = containerWithLimitCores = this.isDefaultProfile() ? (Container)this.executorLimitCores().map((Function1 & Serializable)limitCores -> {
            Quantity executorCpuLimitQuantity = new Quantity(limitCores);
            return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainerWithConfVolume).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
        }).getOrElse((Function0 & Serializable)() -> executorContainerWithConfVolume) : executorContainer;
        if (!this.kubernetesConf.workerDecommissioning()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Decommissioning not enabled, skipping shutdown script");
            container = containerWithLimitCores;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Adding decommission script to lifecycle");
            container = ((ContainerBuilder)((ContainerFluent.LifecycleNested)((LifecycleFluent.PreStopNested)((HandlerFluent.ExecNested)new ContainerBuilder(containerWithLimitCores).withNewLifecycle().withNewPreStop().withNewExec().addToCommand(new String[]{this.kubernetesConf.get(Config$.MODULE$.DECOMMISSION_SCRIPT())})).endExec()).endPreStop()).endLifecycle()).build();
        }
        Container containerWithLifecycle = container;
        Option ownerReference = this.kubernetesConf.driverPod().map((Function1 & Serializable)pod -> ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build());
        PodFluent.SpecNested executorPodBuilder = (PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name2).addToLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.labels()).asJava()).addToAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.annotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy("Never").addToNodeSelector((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)));
        Pod executorPod = this.disableConfigMap() ? ((PodBuilder)executorPodBuilder.endSpec()).build() : ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)executorPodBuilder.addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withNewConfigMap().withItems((List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyToPaths).asJava()).withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        PodSpec podSpec = executorPod.getSpec();
        ((Option)this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME())).foreach((Function1 & Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(executorPod, containerWithLifecycle);
    }

    public static final /* synthetic */ boolean $anonfun$configurePod$7(EnvVar x$1) {
        String string = x$1.getName();
        String string2 = Constants$.MODULE$.ENV_EXECUTOR_DIRS();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public BasicExecutorFeatureStep(KubernetesExecutorConf kubernetesConf, SecurityManager secMgr, ResourceProfile resourceProfile) {
        this.kubernetesConf = kubernetesConf;
        this.secMgr = secMgr;
        this.resourceProfile = resourceProfile;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        Predef$.MODULE$.require(this.blockManagerPort() == 0 || 1024 <= this.blockManagerPort() && this.blockManagerPort() < 65536, (Function0 & Serializable)() -> "port number must be 0 or in [1024, 65535]");
        this.executorPodNamePrefix = kubernetesConf.resourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply((String)kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS()), kubernetesConf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.isDefaultProfile = resourceProfile.id() == ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        String string = kubernetesConf.get(Config$.MODULE$.APP_RESOURCE_TYPE());
        Some some = new Some((Object)Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON());
        this.isPythonApp = !(string != null ? !string.equals(some) : some != null);
        this.disableConfigMap = BoxesRunTime.unboxToBoolean((Object)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()));
        this.execResources = ResourceProfile$.MODULE$.getResourcesForClusterManager(resourceProfile.id(), resourceProfile.executorResources(), BoxesRunTime.unboxToDouble((Object)kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())), kubernetesConf.sparkConf(), this.isPythonApp(), Predef$.MODULE$.Map().empty());
        this.executorMemoryString = new StringBuilder(1).append(this.execResources().executorMemoryMiB()).append("m").toString();
        this.executorCoresRequest = this.isDefaultProfile() && kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : Integer.toString(this.execResources().cores());
        this.executorLimitCores = (Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

