/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005mb!\u0002\r\u001a\u0001u\u0019\u0003\"\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00195\u0011!)\u0004A!b\u0001\n\u00031\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011\u0015\u0003!Q1A\u0005\u0002YB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"A1\f\u0001B\u0001B\u0003%\u0011\n\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0001^\u0011!\t\u0007A!A!\u0002\u0013q\u0006\"\u00022\u0001\t\u0003\u0019\u0007b\u00026\u0001\u0005\u0004%\tE\u000e\u0005\u0007W\u0002\u0001\u000b\u0011B\u001c\t\u000b1\u0004A\u0011I7\t\u000bE\u0004A\u0011I7\t\u000bI\u0004A\u0011I7\t\u000bM\u0004A\u0011I7\t\u000bQ\u0004A\u0011I7\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n\u001dQ\u0011QC\r\u0002\u0002#\u0005Q$a\u0006\u0007\u0013aI\u0012\u0011!E\u0001;\u0005e\u0001B\u00022\u0016\t\u0003\t\t\u0003C\u0005\u0002$U\t\n\u0011\"\u0001\u0002&\t12*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s\u0007>tgM\u0003\u0002\u001b7\u0005\u00191\u000eO:\u000b\u0005qi\u0012A\u00023fa2|\u0017P\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h'\r\u0001A\u0005\u000b\t\u0003K\u0019j\u0011!G\u0005\u0003Oe\u0011abS;cKJtW\r^3t\u0007>tg\r\u0005\u0002*Y5\t!F\u0003\u0002,;\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g\u0007\u0001\u0001\"!\r\u001a\u000e\u0003uI!aM\u000f\u0003\u0013M\u0003\u0018M]6D_:4\u0017B\u0001\u0018'\u0003\u0015\t\u0007\u000f]%e+\u00059\u0004C\u0001\u001dB\u001d\tIt\b\u0005\u0002;{5\t1H\u0003\u0002=_\u00051AH]8pizR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001)P\u0001\u0007CB\u0004\u0018\n\u001a\u0011\u0002\u0015\u0015DXmY;u_JLE-A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004\u0013!\u00033sSZ,'\u000fU8e+\u0005I\u0005c\u0001&L\u001b6\tQ(\u0003\u0002M{\t1q\n\u001d;j_:\u0004\"AT-\u000e\u0003=S!\u0001U)\u0002\u000b5|G-\u001a7\u000b\u0005I\u001b\u0016aA1qS*\u0011A+V\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001,X\u0003\u001d1\u0017M\u0019:jGbR\u0011\u0001W\u0001\u0003S>L!AW(\u0003\u0007A{G-\u0001\u0006ee&4XM\u001d)pI\u0002\n\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e+\u0005q\u0006C\u0001&`\u0013\t\u0001WHA\u0002J]R\f!C]3t_V\u00148-\u001a)s_\u001aLG.Z%eA\u00051A(\u001b8jiz\"b\u0001Z3gO\"L\u0007CA\u0013\u0001\u0011\u0015q#\u00021\u00011\u0011\u0015)$\u00021\u00018\u0011\u0015)%\u00021\u00018\u0011\u00159%\u00021\u0001J\u0011\u001da&\u0002%AA\u0002y\u000b!C]3t_V\u00148-\u001a(b[\u0016\u0004&/\u001a4jq\u0006\u0019\"/Z:pkJ\u001cWMT1nKB\u0013XMZ5yA\u00051A.\u00192fYN,\u0012A\u001c\t\u0005q=<t'\u0003\u0002q\u0007\n\u0019Q*\u00199\u0002\u0017\u0015tg/\u001b:p]6,g\u000e^\u0001\fC:tw\u000e^1uS>t7/A\ftK\u000e\u0014X\r\u001e(b[\u0016\u001cHk\\'pk:$\b+\u0019;ig\u000692/Z2sKR,eN\u001e(b[\u0016\u001cHk\\&fsJ+gm]\u0001\bm>dW/\\3t+\u00059\b\u0003\u0002=~\u0003\u0003q!!_>\u000f\u0005iR\u0018\"\u0001 \n\u0005ql\u0014a\u00029bG.\fw-Z\u0005\u0003}~\u00141aU3r\u0015\taX\bE\u0002&\u0003\u0007I1!!\u0002\u001a\u0005QYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fG\u0006\u00192\r[3dW\u0016CXmY;u_J,eN^&fsR!\u00111BA\t!\rQ\u0015QB\u0005\u0004\u0003\u001fi$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003'\u0019\u0002\u0019A\u001c\u0002\u0007-,\u00170\u0001\fLk\n,'O\\3uKN,\u00050Z2vi>\u00148i\u001c8g!\t)ScE\u0002\u0016\u00037\u00012ASA\u000f\u0013\r\ty\"\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005]\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002()\u001aa,!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class KubernetesExecutorConf
extends KubernetesConf
implements Logging {
    private final String appId;
    private final String executorId;
    private final Option<Pod> driverPod;
    private final int resourceProfileId;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$5() {
        return KubernetesExecutorConf$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public String executorId() {
        return this.executorId;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public int resourceProfileId() {
        return this.resourceProfileId;
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public Map<String, String> labels() {
        Map presetLabels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.executorId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()), (Object)Integer.toString(this.resourceProfileId()))}));
        Map<String, String> executorCustomLabels = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX());
        presetLabels.keys().foreach((Function1 & Serializable)key -> {
            Predef$.MODULE$.require(!executorCustomLabels.contains((Object)key), (Function0 & Serializable)() -> new StringBuilder(67).append("Custom executor labels cannot contain ").append(key).append(" as it is reserved for Spark.").toString());
            return BoxedUnit.UNIT;
        });
        return (Map)executorCustomLabels.$plus$plus((IterableOnce)presetLabels);
    }

    @Override
    public Map<String, String> environment() {
        return ((IterableOnceOps)super.sparkConf().getExecutorEnv().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.checkExecutorEnvKey((String)p._1())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, String> annotations() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX());
    }

    @Override
    public Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
    }

    @Override
    public Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
    }

    private boolean checkExecutorEnvKey(String key) {
        boolean bl;
        Regex executorEnvRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[-._a-zA-Z][-._a-zA-Z0-9]*"));
        if (executorEnvRegex.pattern().matcher(key).matches()) {
            bl = true;
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(131).append(new StringBuilder(15).append("Invalid key: ").append(key).append(": ").toString()).append("a valid environment variable name must consist of alphabetic characters, ").append("digits, '_', '-', or '.', and must not start with a digit.").append(new StringBuilder(32).append("Regex used for validation is '").append(executorEnvRegex).append("')").toString()).toString());
            bl = false;
        }
        return bl;
    }

    public KubernetesExecutorConf(SparkConf sparkConf, String appId, String executorId, Option<Pod> driverPod, int resourceProfileId) {
        this.appId = appId;
        this.executorId = executorId;
        this.driverPod = driverPod;
        this.resourceProfileId = resourceProfileId;
        super(sparkConf);
        Logging.$init$((Logging)this);
        this.resourceNamePrefix = (String)((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX())).getOrElse((Function0 & Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

