/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.RemoveRedundantAliasAndProjectSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000153Aa\u0002\u0005\u0001+!)a\u0005\u0001C\u0001O\u001d)!\u0006\u0001E\u0001W\u0019)Q\u0006\u0001E\u0001]!)ae\u0001C\u0001w!9Ah\u0001b\u0001\n\u0003i\u0004B\u0002'\u0004A\u0003%aHA\u0012SK6|g/\u001a*fIVtG-\u00198u\u00032L\u0017m]!oIB\u0013xN[3diN+\u0018\u000e^3\u000b\u0005%Q\u0011!C8qi&l\u0017N_3s\u0015\tYA\"\u0001\u0005dCR\fG._:u\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\u0011\u0001aC\u0007\u0011\u0011\u0005]AR\"\u0001\b\n\u0005eq!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0015\u0005)\u0001\u000f\\1og&\u0011q\u0004\b\u0002\t!2\fg\u000eV3tiB\u0011\u0011\u0005J\u0007\u0002E)\u00111EC\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002&E\ty\u0001K]3eS\u000e\fG/\u001a%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u0011\u0005Aq\n\u001d;j[&TX\r\u0005\u0002-\u00075\t\u0001A\u0001\u0005PaRLW.\u001b>f'\t\u0019q\u0006E\u00021gUj\u0011!\r\u0006\u0003e)\tQA];mKNL!\u0001N\u0019\u0003\u0019I+H.Z#yK\u000e,Ho\u001c:\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0012a\u00027pO&\u001c\u0017\r\\\u0005\u0003u]\u00121\u0002T8hS\u000e\fG\u000e\u00157b]R\t1&A\u0004cCR\u001c\u0007.Z:\u0016\u0003y\u00022a\u0010$I\u001b\u0005\u0001%BA!C\u0003%IW.\\;uC\ndWM\u0003\u0002D\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012!\u0003\t1K7\u000f\u001e\t\u0003\u0013*k\u0011aA\u0005\u0003\u0017N\u0012QAQ1uG\"\f\u0001BY1uG\",7\u000f\t")
public class RemoveRedundantAliasAndProjectSuite
extends SparkFunSuite
implements PlanTest {
    private volatile RemoveRedundantAliasAndProjectSuite$Optimize$ Optimize$module;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public RemoveRedundantAliasAndProjectSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        RemoveRedundantAliasAndProjectSuite removeRedundantAliasAndProjectSuite = this;
        synchronized (removeRedundantAliasAndProjectSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private final void Optimize$lzycompute$1() {
        RemoveRedundantAliasAndProjectSuite removeRedundantAliasAndProjectSuite = this;
        synchronized (removeRedundantAliasAndProjectSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new RemoveRedundantAliasAndProjectSuite$Optimize$(this);
            }
        }
    }

    public RemoveRedundantAliasAndProjectSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.test("all expressions in project list are aliased child output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            this.comparePlans(optimized, (LogicalPlan)relation, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("all expressions in project list are aliased child output but with different order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("some expressions in project list are aliased child output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            this.comparePlans(optimized, (LogicalPlan)relation, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("some expressions in project list are aliased child output but with different order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("some expressions in project list are not Alias or Attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))}))).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("some expressions in project list are aliased child output but with metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            Metadata metadata = new MetadataBuilder().putString("x", "y").build();
            UnresolvedAttribute x$1 = package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            String x$2 = "a";
            Some x$3 = new Some((Object)metadata);
            ExprId x$4 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            Alias aliasWithMeta = new Alias((Expression)x$1, x$2, x$4, x$5, (Option)x$3, x$6);
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{aliasWithMeta, package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            this.comparePlans(optimized, query, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("remove redundant project with self-join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()}));
            LogicalPlan fragment = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(fragment).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))})));
            LogicalPlan x$7 = package.plans$.MODULE$.DslLogicalPlan(fragment).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
            JoinType x$8 = qual$1.join$default$2();
            Option x$9 = qual$1.join$default$3();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(qual$1.join(x$7, x$8, x$9)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation);
            LocalRelation x$10 = relation;
            JoinType x$11 = qual$2.join$default$2();
            Option x$12 = qual$2.join$default$3();
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(qual$2.join((LogicalPlan)x$10, x$11, x$12)).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("alias removal should not break after push project through union", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation r1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()}));
            LocalRelation r2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)r1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)r2).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)r1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).as("a")}))).union((LogicalPlan)r2)).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("remove redundant alias from aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.sum$default$2())}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.sum$default$2())}))).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("remove redundant alias from window", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).window((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$), (Seq)Nil$.MODULE$)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).window((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (List)Nil$.MODULE$), (Seq)Nil$.MODULE$)).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("do not remove output attributes from a subquery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation relation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            Subquery query = new Subquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("a"), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as("b")}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            Subquery expected = new Subquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("a"), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false);
            this.comparePlans(optimized, (LogicalPlan)expected, this.comparePlans$default$3());
        }, new Position("RemoveRedundantAliasAndProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }
}

