/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t\u0011\"*Y2lg>t\u0007+\u0019:tKJ\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003kg>t'B\u0001\u0004\b\u0003!\u0019\u0017\r^1msN$(B\u0001\u0005\n\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\n\u0013\t!\u0012BA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\r\u0001")
public class JacksonParserSuite
extends SparkFunSuite {
    private final void check$1(String input, StructType schema, Seq filters, Seq expected) {
        JSONOptions options = new JSONOptions(Predef$.MODULE$.Map().empty(), "GMT", "");
        JacksonParser parser = new JacksonParser((DataType)schema, options, false, filters);
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        Iterable actual = parser.parse((Object)input, (Function2)createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
        Seq $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    private static final String check$default$1$1() {
        return "{\"i\":1, \"s\": \"a\"}";
    }

    private static final StructType check$default$2$1() {
        return StructType$.MODULE$.fromDDL("i INTEGER");
    }

    public JacksonParserSuite() {
        this.test("skipping rows using pushdown filters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq x$1 = (Seq)Nil$.MODULE$;
            Seq x$2 = (Seq)new .colon.colon((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$);
            String x$3 = JacksonParserSuite.check$default$1$1();
            StructType x$4 = JacksonParserSuite.check$default$2$1();
            this.check$1(x$3, x$4, x$1, x$2);
            Seq x$5 = (Seq)new .colon.colon((Object)new EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$);
            Seq x$6 = (Seq)new .colon.colon((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$);
            String x$7 = JacksonParserSuite.check$default$1$1();
            StructType x$8 = JacksonParserSuite.check$default$2$1();
            this.check$1(x$7, x$8, x$5, x$6);
            Seq x$9 = (Seq)new .colon.colon((Object)new EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$);
            Seq x$10 = (Seq)Nil$.MODULE$;
            String x$11 = JacksonParserSuite.check$default$1$1();
            StructType x$12 = JacksonParserSuite.check$default$2$1();
            this.check$1(x$11, x$12, x$9, x$10);
            StructType x$13 = StructType$.MODULE$.fromDDL("s STRING");
            Seq x$14 = (Seq)new .colon.colon((Object)new StringStartsWith("s", "b"), (List)Nil$.MODULE$);
            Seq x$15 = (Seq)Nil$.MODULE$;
            String x$16 = JacksonParserSuite.check$default$1$1();
            this.check$1(x$16, x$13, x$14, x$15);
            StructType x$17 = StructType$.MODULE$.fromDDL("i INTEGER, s STRING");
            Seq x$18 = (Seq)new .colon.colon((Object)new StringStartsWith("s", "a"), (List)Nil$.MODULE$);
            Seq x$19 = (Seq)new .colon.colon((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"a")})), (List)Nil$.MODULE$);
            String x$20 = JacksonParserSuite.check$default$1$1();
            this.check$1(x$20, x$17, x$18, x$19);
            this.check$1("{\"i\":1,\"s\": \"a\", \"d\": 3.14}", StructType$.MODULE$.fromDDL("i INTEGER, d DOUBLE"), (Seq)new .colon.colon((Object)new EqualTo("d", (Object)BoxesRunTime.boxToDouble((double)3.14)), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.14)})), (List)Nil$.MODULE$));
        }, new Position("JacksonParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
    }
}

