/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\b\u0010\u0001yAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u0004.\u0001\u0001\u0006I!\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u00191\u0004\u0001)A\u0005a!9q\u0007\u0001b\u0001\n\u0013y\u0003B\u0002\u001d\u0001A\u0003%\u0001\u0007C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\t\ry\u0002\u0001\u0015!\u0003<\u0011\u001dy\u0004A1A\u0005\n\u0001Caa\u0012\u0001!\u0002\u0013\t\u0005\"\u0002%\u0001\t\u0013I\u0005\"B.\u0001\t\u0013a&AF\"pk:$X*\u001b8TW\u0016$8\r[!hON+\u0018\u000e^3\u000b\u0005A\t\u0012!C1hOJ,w-\u0019;f\u0015\t\u00112#A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000b\u0016\u0003!\u0019\u0017\r^1msN$(B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u0001\u0013%D\u0001\u0018\u0013\t\u0011sCA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003=\tqb\u00195jY\u0012,\u0005\u0010\u001d:fgNLwN\\\u000b\u0002SA\u0011!fK\u0007\u0002#%\u0011A&\u0005\u0002\u000f\u0005>,h\u000e\u001a*fM\u0016\u0014XM\\2f\u0003A\u0019\u0007.\u001b7e\u000bb\u0004(/Z:tS>t\u0007%A\bfaN|e\rV8uC2\u001cu.\u001e8u+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$A\u0002#pk\ndW-\u0001\tfaN|e\rV8uC2\u001cu.\u001e8uA\u0005Q1m\u001c8gS\u0012,gnY3\u0002\u0017\r|gNZ5eK:\u001cW\rI\u0001\u0005g\u0016,G-F\u0001<!\t\tD(\u0003\u0002>e\t\u0019\u0011J\u001c;\u0002\u000bM,W\r\u001a\u0011\u0002\tI\fg\u000eZ\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011AIM\u0001\u0005kRLG.\u0003\u0002G\u0007\n1!+\u00198e_6\fQA]1oI\u0002\n1aY7t)\u0011QUJV,\u0011\u0005\u0019Z\u0015B\u0001'\u0010\u0005E\u0019u.\u001e8u\u001b&t7k[3uG\"\fum\u001a\u0005\u0006\u001d2\u0001\raT\u0001\u0004KB\u001c\bC\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011a\u0017M\\4\u000b\u0003Q\u000bAA[1wC&\u0011Q'\u0015\u0005\u0006o1\u0001\ra\u0014\u0005\u0006s1\u0001\r\u0001\u0017\t\u0003!fK!AW)\u0003\u000f%sG/Z4fe\u0006aA/Z:u\t\u0006$\u0018\rV=qKV\u0011Q,\u001f\u000b\u0004=\u0006L\u0007CA\u0019`\u0013\t\u0001'G\u0001\u0003V]&$\b\"\u00022\u000e\u0001\u0004\u0019\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019,\u0012!\u0002;za\u0016\u001c\u0018B\u00015f\u0005!!\u0015\r^1UsB,\u0007\"\u00026\u000e\u0001\u0004Y\u0017!B5uK6\u001c\bc\u00017uo:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003av\ta\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005M\u0014\u0014a\u00029bG.\fw-Z\u0005\u0003kZ\u00141aU3r\u0015\t\u0019(\u0007\u0005\u0002ys2\u0001A!\u0002>\u000e\u0005\u0004Y(!\u0001+\u0012\u0005q|\bCA\u0019~\u0013\tq(GA\u0004O_RD\u0017N\\4\u0011\u0007E\n\t!C\u0002\u0002\u0004I\u00121!\u00118z\u0001")
public class CountMinSketchAggSuite
extends SparkFunSuite {
    private final BoundReference childExpression = new BoundReference(0, (DataType)IntegerType$.MODULE$, true);
    private final double epsOfTotalCount;
    private final double confidence;
    private final int seed;
    private final Random rand = new Random(this.seed());

    private BoundReference childExpression() {
        return this.childExpression;
    }

    private double epsOfTotalCount() {
        return this.epsOfTotalCount;
    }

    private double confidence() {
        return this.confidence;
    }

    private int seed() {
        return this.seed;
    }

    private Random rand() {
        return this.rand;
    }

    private CountMinSketchAgg cms(Double eps, Double confidence, Integer seed) {
        return new CountMinSketchAgg((Expression)this.childExpression(), (Expression)new Literal((Object)eps, (DataType)DoubleType$.MODULE$), (Expression)new Literal((Object)confidence, (DataType)DoubleType$.MODULE$), (Expression)new Literal((Object)seed, (DataType)IntegerType$.MODULE$));
    }

    private <T> void testDataType(DataType dataType, Seq<T> items) {
        this.test(new StringBuilder(15).append("test data type ").append(dataType).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CountMinSketchAgg agg = new CountMinSketchAgg((Expression)new BoundReference(0, dataType, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.epsOfTotalCount())), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.confidence())), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.seed())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(agg.nullable(), "agg.nullable", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Tuple2 tuple2 = items.splitAt(items.size() / 2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq seq1 = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)seq1, (Object)seq2);
            Tuple2 tuple23 = tuple22;
            Seq seq12 = (Seq)tuple23._1();
            Seq seq22 = (Seq)tuple23._2();
            CountMinSketch buf1 = CountMinSketchAggSuite.addToAggregateBuffer$1(agg, seq12);
            CountMinSketch buf2 = CountMinSketchAggSuite.addToAggregateBuffer$1(agg, seq22);
            CountMinSketch sketch = agg.createAggregationBuffer();
            agg.merge(sketch, buf1);
            agg.merge(sketch, buf2);
            CountMinSketch referenceSketch = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
            items.foreach((Function1 & Serializable & scala.Serializable)item -> {
                CountMinSketchAggSuite.$anonfun$testDataType$2(referenceSketch, item);
                return BoxedUnit.UNIT;
            });
            items.foreach((Function1 & Serializable & scala.Serializable)item -> (Assertion)this.withClue(new StringBuilder(9).append("For item ").append(item).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                Object object2 = item;
                if (object2 instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)object2;
                    object = uTF8String.getBytes();
                } else {
                    object = item;
                }
                Object itemToTest = object;
                long $org_scalatest_assert_macro_left = referenceSketch.estimateCount(itemToTest);
                long $org_scalatest_assert_macro_right = sketch.estimateCount(itemToTest);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }));
        }, new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
    }

    public static final /* synthetic */ void $anonfun$testDataType$2(CountMinSketch referenceSketch$1, Object item) {
        Object object;
        Object object2 = item;
        if (object2 instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object2;
            object = uTF8String.getBytes();
        } else {
            object = item;
        }
        referenceSketch$1.add(object);
    }

    /*
     * WARNING - void declaration
     */
    private static final CountMinSketch addToAggregateBuffer$1(CountMinSketchAgg agg, Seq items) {
        void var2_2;
        CountMinSketch buf = agg.createAggregationBuffer();
        items.foreach((Function1 & Serializable & scala.Serializable)item -> agg.update(buf, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{item}))));
        return var2_2;
    }

    public static final /* synthetic */ Assertion $anonfun$new$13(CountMinSketchAggSuite $this, double invalidEps) {
        CountMinSketchAgg invalidAgg = $this.cms(Predef$.MODULE$.double2Double(invalidEps), Predef$.MODULE$.double2Double($this.confidence()), Predef$.MODULE$.int2Integer($this.seed()));
        return $this.assertResult(new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(invalidEps).append(")").toString()), invalidAgg.checkInputDataTypes(), Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
    }

    public static final /* synthetic */ Assertion $anonfun$new$14(CountMinSketchAggSuite $this, double invalidConfidence) {
        CountMinSketchAgg invalidAgg = $this.cms(Predef$.MODULE$.double2Double($this.epsOfTotalCount()), Predef$.MODULE$.double2Double(invalidConfidence), Predef$.MODULE$.int2Integer($this.seed()));
        return $this.assertResult(new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(invalidConfidence).append(")").toString()), invalidAgg.checkInputDataTypes(), Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    private static final boolean isEqual$1(Object result, CountMinSketch other) {
        return other.equals((Object)CountMinSketch.readFrom((byte[])((byte[])result)));
    }

    public CountMinSketchAggSuite() {
        this.epsOfTotalCount = 1.0E-4;
        this.confidence = 0.99;
        this.seed = 42;
        this.testDataType((DataType)ByteType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)this.rand().nextInt(10)));
        this.testDataType((DataType)ShortType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> (short)this.rand().nextInt(10)));
        this.testDataType((DataType)IntegerType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.rand().nextInt(10)));
        this.testDataType((DataType)LongType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.rand().nextInt(10)));
        this.testDataType((DataType)StringType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0 & Serializable & scala.Serializable)() -> UTF8String.fromString((String)this.rand().nextString(1))));
        this.testDataType((DataType)BinaryType$.MODULE$, (Seq)Seq$.MODULE$.fill(100, (Function0 & Serializable & scala.Serializable)() -> this.rand().nextString(1).getBytes()));
        this.test("serialize and de-serialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CountMinSketchAgg agg = this.cms(Predef$.MODULE$.double2Double(this.epsOfTotalCount()), Predef$.MODULE$.double2Double(this.confidence()), Predef$.MODULE$.int2Integer(this.seed()));
            CountMinSketch buffer = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(buffer.equals((Object)agg.deserialize(agg.serialize(buffer))), "buffer.equals(agg.deserialize(agg.serialize(buffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            Random random = new Random(31);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> buffer.add((Object)BoxesRunTime.boxToInteger((int)random.nextInt(100))));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(buffer.equals((Object)agg.deserialize(agg.serialize(buffer))), "buffer.equals(agg.deserialize(agg.serialize(buffer)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("fails analysis if eps, confidence or seed provided is not foldable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "a";
            DoubleType$ x$2 = DoubleType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            CountMinSketchAgg wrongEps = new CountMinSketchAgg((Expression)this.childExpression(), (Expression)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.confidence())), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.seed())));
            String x$7 = "b";
            DoubleType$ x$8 = DoubleType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            CountMinSketchAgg wrongConfidence = new CountMinSketchAgg((Expression)this.childExpression(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.epsOfTotalCount())), (Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.seed())));
            String x$13 = "c";
            IntegerType$ x$14 = IntegerType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
            CountMinSketchAgg wrongSeed = new CountMinSketchAgg((Expression)this.childExpression(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.epsOfTotalCount())), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.confidence())), (Expression)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18));
            ((IterableLike)new .colon.colon((Object)wrongEps, (List)new .colon.colon((Object)wrongConfidence, (List)new .colon.colon((Object)wrongSeed, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)wrongAgg -> this.assertResult(new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable"), wrongAgg.checkInputDataTypes(), Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146)));
        }, new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("fails analysis if parameters are invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CountMinSketchAgg wrongEps = this.cms(null, Predef$.MODULE$.double2Double(this.confidence()), Predef$.MODULE$.int2Integer(this.seed()));
            CountMinSketchAgg wrongConfidence = this.cms(Predef$.MODULE$.double2Double(this.epsOfTotalCount()), null, Predef$.MODULE$.int2Integer(this.seed()));
            CountMinSketchAgg wrongSeed = this.cms(Predef$.MODULE$.double2Double(this.epsOfTotalCount()), Predef$.MODULE$.double2Double(this.confidence()), null);
            ((IterableLike)new .colon.colon((Object)wrongEps, (List)new .colon.colon((Object)wrongConfidence, (List)new .colon.colon((Object)wrongSeed, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)wrongAgg -> this.assertResult(new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null"), wrongAgg.checkInputDataTypes(), Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159)));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -1000.0}))).foreach((Function1 & Serializable & scala.Serializable)invalidEps -> CountMinSketchAggSuite.$anonfun$new$13(this, BoxesRunTime.unboxToDouble((Object)invalidEps)));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, -2.0, 2.0}))).foreach((Function1 & Serializable & scala.Serializable)invalidConfidence -> CountMinSketchAggSuite.$anonfun$new$14(this, BoxesRunTime.unboxToDouble((Object)invalidConfidence)));
        }, new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CountMinSketchAgg agg = this.cms(Predef$.MODULE$.double2Double(this.epsOfTotalCount()), Predef$.MODULE$.double2Double(this.confidence()), Predef$.MODULE$.int2Integer(this.seed()));
            CountMinSketch emptyCms = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CountMinSketchAggSuite.isEqual$1(agg.eval((InternalRow)buffer), emptyCms), "isEqual(agg.eval(buffer), emptyCms)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(CountMinSketchAggSuite.isEqual$1(agg.eval((InternalRow)buffer), emptyCms), "isEqual(agg.eval(buffer), emptyCms)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(CountMinSketchAggSuite.isEqual$1(agg.eval((InternalRow)buffer), emptyCms), "isEqual(agg.eval(buffer), emptyCms)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }, new Position("CountMinSketchAggSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

