/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001A3QAB\u0004\u0002\u0002QAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u001bEA\u0005C\u0003)\u0001\u0011E\u0011\u0006C\u00031\u0001\u0011\u0005\u0013\u0006C\u00032\u0001\u0011%!G\u0001\u000bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0011%\tqaY1uC2|wM\u0003\u0002\u000b\u0017\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+e\u0001\"AF\f\u000e\u00035I!\u0001G\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tQR$D\u0001\u001c\u0015\ta\u0012#A\u0005tG\u0006d\u0017\r^3ti&\u0011ad\u0007\u0002\u0013\u0005\u00164wN]3B]\u0012\fe\r^3s\u000b\u0006\u001c\u0007.\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u000f\u0005)Q\u000f^5mgV\tQ\u0005\u0005\u0002#M%\u0011qe\u0002\u0002\u0011\u0007\u0006$\u0018\r\\8h)\u0016\u001cH/\u0016;jYN\f!B]3tKR\u001cF/\u0019;f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSR\f\u0011\"\u00194uKJ,\u0015m\u00195\u0002\r\u0015D\u0018n\u001d;t)\r\u0019d\u0007\u0011\t\u0003WQJ!!\u000e\u0017\u0003\u000f\t{w\u000e\\3b]\")q'\u0002a\u0001q\u0005\u0019QO]5\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014a\u00018fi*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\r)&+\u0013\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\tG\"LG\u000e\u001a:f]B\u00191fQ#\n\u0005\u0011c#A\u0003\u001fsKB,\u0017\r^3e}A\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u0017\u000e\u0003%S!AS\n\u0002\rq\u0012xn\u001c;?\u0013\taE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'-\u0001")
public abstract class ExternalCatalogSuite
extends SparkFunSuite {
    public abstract CatalogTestUtils utils();

    public void resetState() {
    }

    public void afterEach() {
        try {
            this.resetState();
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    private boolean exists(URI uri, Seq<String> children) {
        Path base = new Path(uri);
        Path finalPath = (Path)children.foldLeft((Object)base, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path parent = (Path)tuple2._1();
            String child = (String)tuple2._2();
            Path path = new Path(parent, child);
            return path;
        });
        return base.getFileSystem(new Configuration()).exists(finalPath);
    }

    private final void checkAnswer$1(CatalogTable table, Seq filters, Set expected, ExternalCatalog catalog$12, String tz$1) {
        this.assertResult(expected.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.spec(), Set$.MODULE$.canBuildFrom()), ((TraversableOnce)catalog$12.listPartitionsByFilter(table.database(), table.identifier().identifier(), filters, tz$1).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.spec(), Seq$.MODULE$.canBuildFrom())).toSet(), Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
    }

    public ExternalCatalogSuite() {
        this.test("basic create and list databases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("default"), true);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            catalog.createDatabase(this.utils().newDb("testing"), false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            catalog.createDatabase(this.utils().newDb("testing2"), false);
            Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("get database when a database exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase db1 = this.utils().newBasicCatalog().getDatabase("db1");
            String $org_scalatest_assert_macro_left = db1.name();
            String $org_scalatest_assert_macro_right = "db1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            String $org_scalatest_assert_macro_left2 = db1.description();
            String $org_scalatest_assert_macro_right2 = "db1";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("get database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.utils().newBasicCatalog().getDatabase("db_that_does_not_exist"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85)))), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("list databases without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("list databases with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2", "db3"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("drop database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.dropDatabase("db1", false, false);
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("drop database when the database is not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog1 = this.utils().newBasicCatalog();
            catalog1.dropTable("db2", "tbl1", false, false);
            catalog1.dropTable("db2", "tbl2", false, false);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog1.dropDatabase("db2", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            this.resetState();
            ExternalCatalog catalog2 = this.utils().newBasicCatalog();
            catalog2.dropFunction("db2", "func1");
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog2.dropDatabase("db2", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            this.resetState();
            ExternalCatalog catalog3 = this.utils().newBasicCatalog();
            catalog3.dropDatabase("db2", false, true);
            Set $org_scalatest_assert_macro_left = catalog3.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("drop database when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropDatabase("db_that_does_not_exist", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            catalog.dropDatabase("db_that_does_not_exist", true, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("alter database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db1 = catalog.getDatabase("db1");
            Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"good"), (Object)"true")}));
            String x$2 = db1.copy$default$1();
            String x$3 = db1.copy$default$2();
            URI x$4 = db1.copy$default$3();
            catalog.alterDatabase(db1.copy(x$2, x$3, x$4, x$1));
            CatalogDatabase newDb1 = catalog.getDatabase("db1");
            Map $org_scalatest_assert_macro_left = (Map)db1.properties().$minus$minus((GenTraversableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Map $org_scalatest_assert_macro_left2 = (Map)newDb1.properties().$minus$minus((GenTraversableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("alter database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.utils().newBasicCatalog().alterDatabase(this.utils().newDb("does_not_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)))), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("the table type of an external table should be EXTERNAL_TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable qual$1 = this.utils().newTable("external_table1", "db2");
            CatalogTableType x$5 = CatalogTableType$.MODULE$.EXTERNAL();
            TableIdentifier x$6 = qual$1.copy$default$1();
            CatalogStorageFormat x$7 = qual$1.copy$default$3();
            StructType x$8 = qual$1.copy$default$4();
            Option x$9 = qual$1.copy$default$5();
            Seq x$10 = qual$1.copy$default$6();
            Option x$11 = qual$1.copy$default$7();
            String x$12 = qual$1.copy$default$8();
            long x$13 = qual$1.copy$default$9();
            long x$14 = qual$1.copy$default$10();
            String x$15 = qual$1.copy$default$11();
            Map x$16 = qual$1.copy$default$12();
            Option x$17 = qual$1.copy$default$13();
            Option x$18 = qual$1.copy$default$14();
            Option x$19 = qual$1.copy$default$15();
            Seq x$20 = qual$1.copy$default$16();
            boolean x$21 = qual$1.copy$default$17();
            boolean x$22 = qual$1.copy$default$18();
            Map x$23 = qual$1.copy$default$19();
            Option x$24 = qual$1.copy$default$20();
            CatalogTable table = qual$1.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            catalog.createTable(table, false);
            CatalogTable actual = catalog.getTable("db2", "external_table1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual.tableType());
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("create table when the table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            CatalogTable table = this.utils().newTable("tbl1", "db2");
            return (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createTable(table, false), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("drop table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            catalog.dropTable("db2", "tbl1", false, false);
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("drop table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropTable("unknown_db", "unknown_table", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropTable("unknown_db", "unknown_table", true, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropTable("db2", "unknown_table", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            catalog.dropTable("db2", "unknown_table", true, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("rename table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            catalog.renameTable("db2", "tbl1", "tblone");
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("rename table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable("unknown_db", "unknown_table", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable("db2", "unknown_table", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("rename table when destination table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable("db2", "tbl1", "tbl2"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("alter table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl1 = catalog.getTable("db2", "tbl1");
            Map x$25 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toh"), (Object)"frem")}));
            TableIdentifier x$26 = tbl1.copy$default$1();
            CatalogTableType x$27 = tbl1.copy$default$2();
            CatalogStorageFormat x$28 = tbl1.copy$default$3();
            StructType x$29 = tbl1.copy$default$4();
            Option x$30 = tbl1.copy$default$5();
            Seq x$31 = tbl1.copy$default$6();
            Option x$32 = tbl1.copy$default$7();
            String x$33 = tbl1.copy$default$8();
            long x$34 = tbl1.copy$default$9();
            long x$35 = tbl1.copy$default$10();
            String x$36 = tbl1.copy$default$11();
            Option x$37 = tbl1.copy$default$13();
            Option x$38 = tbl1.copy$default$14();
            Option x$39 = tbl1.copy$default$15();
            Seq x$40 = tbl1.copy$default$16();
            boolean x$41 = tbl1.copy$default$17();
            boolean x$42 = tbl1.copy$default$18();
            Map x$43 = tbl1.copy$default$19();
            Option x$44 = tbl1.copy$default$20();
            catalog.alterTable(tbl1.copy(x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$25, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44));
            CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
            Map $org_scalatest_assert_macro_left = tbl1.properties();
            String $org_scalatest_assert_macro_right = "toh";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
            int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("alter table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterTable(this.utils().newTable("tbl1", "unknown_db")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterTable(this.utils().newTable("unknown_table", "db2")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("alter table schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            StructType newDataSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("new_field_2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
            catalog.alterTableDataSchema("db2", "tbl1", newDataSchema);
            CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
            StructType $org_scalatest_assert_macro_left = newTbl1.dataSchema();
            StructType $org_scalatest_assert_macro_right = newDataSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("alter table stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option oldTableStats;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Option $org_scalatest_assert_macro_left = oldTableStats = catalog.getTable("db2", "tbl1").stats();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(1), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
            catalog.alterTableStats("db2", "tbl1", (Option)new Some((Object)newStats));
            Option newTableStats = catalog.getTable("db2", "tbl1").stats();
            CatalogStatistics $org_scalatest_assert_macro_left2 = (CatalogStatistics)newTableStats.get();
            CatalogStatistics $org_scalatest_assert_macro_right = newStats;
            CatalogStatistics catalogStatistics = $org_scalatest_assert_macro_left2;
            CatalogStatistics catalogStatistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogStatistics != null ? !catalogStatistics.equals(catalogStatistics2) : catalogStatistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("get table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.utils().newBasicCatalog().getTable("db2", "tbl1").identifier().table();
            String $org_scalatest_assert_macro_right = "tbl1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("get table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getTable("unknown_db", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getTable("db2", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("get tables by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)this.utils().newBasicCatalog().getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tbl2", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tbl2", (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("get tables by name when some tables do not exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)this.utils().newBasicCatalog().getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tblnotexist", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"tbl1", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("get tables by name when contains invalid name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String name = "\u7816";
            Seq $org_scalatest_assert_macro_left = (Seq)this.utils().newBasicCatalog().getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"tbl1", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("get tables by name when empty table list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = this.utils().newBasicCatalog().getTablesByName("db2", (Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("list tables without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables("unknown_db"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("list tables with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables("unknown_db", "*"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("column names should be case-preserving and column nullability should be retained", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.utils().storageFormat(), new StructType().add("HelLo", "int", false).add("WoRLd", "int", true), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"WoRLd", (List)Nil$.MODULE$), (Option)new Some((Object)new BucketSpec(4, (Seq)new .colon.colon((Object)"HelLo", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(tbl, false);
            CatalogTable readBack = catalog.getTable("db1", "tbl");
            StructType $org_scalatest_assert_macro_left = readBack.schema();
            StructType $org_scalatest_assert_macro_right = tbl.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            Seq $org_scalatest_assert_macro_left2 = readBack.partitionColumnNames();
            Seq $org_scalatest_assert_macro_right2 = tbl.partitionColumnNames();
            Seq seq = $org_scalatest_assert_macro_left2;
            Seq seq2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            Option $org_scalatest_assert_macro_left3 = readBack.bucketSpec();
            Option $org_scalatest_assert_macro_right3 = tbl.bucketSpec();
            Option option = $org_scalatest_assert_macro_left3;
            Option option2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("basic create and list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("mydb"), false);
            catalog.createTable(this.utils().newTable("tbl", "mydb"), false);
            catalog.createPartitions("mydb", "tbl", (Seq)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"mydb\", \"tbl\", scala.collection.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("create partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createPartitions("does_not_exist", "tbl1", (Seq)Nil$.MODULE$, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createPartitions("db2", "does_not_exist", (Seq)Nil$.MODULE$, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("create partitions that already exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), true);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("create partitions without location", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            CatalogTablePartition partition = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition, (List)Nil$.MODULE$), false);
            URI partitionLocation = catalog.getPartition("db1", "tbl", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")}))).location();
            Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
            Path defaultPartitionLocation = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
            Path $org_scalatest_assert_macro_left = new Path(partitionLocation);
            Path $org_scalatest_assert_macro_right = defaultPartitionLocation;
            Path path = $org_scalatest_assert_macro_left;
            Path path2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.test("create/drop partitions in managed tables with location", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            URI newLocationPart1 = this.utils().newUriForPartition((Seq<String>)((Seq)new .colon.colon((Object)"p1=1", (List)new .colon.colon((Object)"p2=2", (List)Nil$.MODULE$))));
            URI newLocationPart2 = this.utils().newUriForPartition((Seq<String>)((Seq)new .colon.colon((Object)"p1=3", (List)new .colon.colon((Object)"p2=4", (List)Nil$.MODULE$))));
            CatalogTablePartition partition1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat().copy((Option)new Some((Object)newLocationPart1), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition partition2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat().copy((Option)new Some((Object)newLocationPart2), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition1, (List)Nil$.MODULE$), false);
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition2, (List)Nil$.MODULE$), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            catalog.dropPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition1.spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            catalog.dropTable("db1", "tbl", false, false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("list partition names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq partitionNames;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$), false);
            Seq $org_scalatest_assert_macro_left = partitionNames = catalog.listPartitionNames("db2", "tbl2", catalog.listPartitionNames$default$3());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a=1/b=%25%3D", (List)new .colon.colon((Object)"a=1/b=2", (List)new .colon.colon((Object)"a=3/b=4", (List)Nil$.MODULE$)));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("list partition names with partial partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq partitionNames3;
            Seq partitionNames2;
            Seq partitionNames1;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$), false);
            Seq $org_scalatest_assert_macro_left = partitionNames1 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"a=1/b=%25%3D", (List)new .colon.colon((Object)"a=1/b=2", (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            Seq $org_scalatest_assert_macro_left2 = partitionNames2 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")}))));
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)"a=1/b=%25%3D", (List)Nil$.MODULE$);
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            Seq $org_scalatest_assert_macro_left3 = partitionNames3 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%25%3D")}))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        this.test("list partitions with partial partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq parts;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Seq $org_scalatest_assert_macro_left = parts = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            Map $org_scalatest_assert_macro_left2 = ((CatalogTablePartition)parts.head()).spec();
            Map $org_scalatest_assert_macro_right2 = this.utils().part1().spec();
            Map map = $org_scalatest_assert_macro_left2;
            Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
            Seq $org_scalatest_assert_macro_left3 = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"1")}))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
            Seq $org_scalatest_assert_macro_left4 = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown")}))));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("SPARK-21457: list partitions with special chars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Seq $org_scalatest_assert_macro_left = catalog.listPartitions("db2", "tbl1", catalog.listPartitions$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i+j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i.j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Seq $org_scalatest_assert_macro_left2 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part1.spec())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.spec(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left2;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            Seq $org_scalatest_assert_macro_left3 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part2.spec())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.spec(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)part2.spec(), (List)Nil$.MODULE$);
            Seq seq3 = $org_scalatest_assert_macro_left3;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("SPARK-38120: list partitions with special chars and mixed case column name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), this.utils().storageFormat().copy((Option)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI()), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"i+j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"i.j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Seq $org_scalatest_assert_macro_left = (Seq)catalog.listPartitions("db1", "tbl", (Option)new Some((Object)part1.spec())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.spec(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            Seq $org_scalatest_assert_macro_left2 = (Seq)catalog.listPartitions("db1", "tbl", (Option)new Some((Object)part2.spec())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.spec(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)part2.spec(), (List)Nil$.MODULE$);
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        this.test("list partitions by filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String tz = TimeZone.getDefault().getID();
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl2 = catalog.getTable("db2", "tbl2");
            this.checkAnswer$1(tbl2, (Seq)Nil$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1(), this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (List)Nil$.MODULE$), Predef$.MODULE$.Set().empty(), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)new In(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$times((Expression)package.expressions$.MODULE$.intToLiteral(10)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(30), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)new Not((Expression)new In((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(4), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1(), this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2")), (List)Nil$.MODULE$)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2"))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x")), (List)Nil$.MODULE$)), Predef$.MODULE$.Set().empty(), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x"))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                try {
                    this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col1")).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0))), (List)Nil$.MODULE$), Predef$.MODULE$.Set().empty(), catalog, tz);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    RuntimeException runtimeException;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getMessage().contains("MetaException")) {
                        throw new AnalysisException(runtimeException.getMessage(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                    }
                    throw throwable;
                }
                return boxedUnit;
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        this.test("drop partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", scala.collection.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", scala.collection.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            this.resetState();
            ExternalCatalog catalog2 = this.utils().newBasicCatalog();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog2, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog2, \"db2\", \"tbl2\", scala.collection.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            catalog2.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), false, false, false);
            Seq $org_scalatest_assert_macro_left = catalog2.listPartitions("db2", "tbl2", catalog2.listPartitions$default$3());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("drop partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropPartitions("does_not_exist", "tbl1", (Seq)Nil$.MODULE$, false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropPartitions("db2", "does_not_exist", (Seq)Nil$.MODULE$, false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        this.test("drop partitions that do not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$), false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$), true, false, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
        this.test("get partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Map $org_scalatest_assert_macro_left = catalog.getPartition("db2", "tbl2", this.utils().part1().spec()).spec();
            Map $org_scalatest_assert_macro_right = this.utils().part1().spec();
            Map map = $org_scalatest_assert_macro_left;
            Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
            Map $org_scalatest_assert_macro_left2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec()).spec();
            Map $org_scalatest_assert_macro_right2 = this.utils().part2().spec();
            Map map3 = $org_scalatest_assert_macro_left2;
            Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getPartition("db2", "tbl1", this.utils().part3().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        this.test("get partition when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getPartition("does_not_exist", "tbl1", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getPartition("db2", "does_not_exist", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("rename partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart1 = this.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"101")})), this.utils().part1().copy$default$2(), this.utils().part1().copy$default$3(), this.utils().part1().copy$default$4(), this.utils().part1().copy$default$5(), this.utils().part1().copy$default$6());
            CatalogTablePartition newPart2 = this.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"201")})), this.utils().part2().copy$default$2(), this.utils().part2().copy$default$3(), this.utils().part2().copy$default$4(), this.utils().part2().copy$default$5(), this.utils().part2().copy$default$6());
            Seq newSpecs = (Seq)new .colon.colon((Object)newPart1.spec(), (List)new .colon.colon((Object)newPart2.spec(), (List)Nil$.MODULE$));
            catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), newSpecs);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart1.spec()).spec());
            Map $org_scalatest_assert_macro_right = newPart1.spec();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart2.spec()).spec());
            Map $org_scalatest_assert_macro_right2 = newPart2.spec();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getPartition("db2", "tbl2", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getPartition("db2", "tbl2", this.utils().part2().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
        this.test("rename partitions should update the location for managed table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
            CatalogTablePartition mixedCasePart1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition mixedCasePart2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)mixedCasePart1, (List)Nil$.MODULE$), false);
            Path $org_scalatest_assert_macro_left = new Path(catalog.getPartition("db1", "tbl", mixedCasePart1.spec()).location());
            Path $org_scalatest_assert_macro_right = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
            Path path = $org_scalatest_assert_macro_left;
            Path path2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            catalog.renamePartitions("db1", "tbl", (Seq)new .colon.colon((Object)mixedCasePart1.spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)mixedCasePart2.spec(), (List)Nil$.MODULE$));
            Path $org_scalatest_assert_macro_left2 = new Path(catalog.getPartition("db1", "tbl", mixedCasePart2.spec()).location());
            Path $org_scalatest_assert_macro_right2 = new Path(new Path(tableLocation, "partCol1=3"), "partCol2=4");
            Path path3 = $org_scalatest_assert_macro_left2;
            Path path4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(path3 != null ? !path3.equals(path4) : path4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            URI existingPartLoc = catalog.getPartition("db2", "tbl2", this.utils().part1().spec()).location();
            catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$));
            Path $org_scalatest_assert_macro_left3 = new Path(catalog.getPartition("db2", "tbl2", this.utils().part3().spec()).location());
            Path $org_scalatest_assert_macro_right3 = new Path(existingPartLoc);
            Path path5 = $org_scalatest_assert_macro_left3;
            Path path6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(path5 != null ? !path5.equals(path6) : path6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        this.test("rename partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renamePartitions("does_not_exist", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renamePartitions("db2", "does_not_exist", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
        this.test("rename partitions when the new partition already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        this.test("alter partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            try {
                URI newLocation = this.utils().newUriForDatabase();
                String newSerde = "com.sparkbricks.text.EasySerde";
                Map newSerdeProps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark"), (Object)"bricks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compressed"), (Object)"false")}));
                CatalogTablePartition oldPart1 = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition oldPart2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                CatalogStorageFormat x$45 = this.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6());
                Map x$46 = oldPart1.copy$default$1();
                Map x$47 = oldPart1.copy$default$3();
                long x$48 = oldPart1.copy$default$4();
                long x$49 = oldPart1.copy$default$5();
                Option x$50 = oldPart1.copy$default$6();
                CatalogStorageFormat x$51 = this.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6());
                Map x$52 = oldPart2.copy$default$1();
                Map x$53 = oldPart2.copy$default$3();
                long x$54 = oldPart2.copy$default$4();
                long x$55 = oldPart2.copy$default$5();
                Option x$56 = oldPart2.copy$default$6();
                catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)oldPart1.copy(x$46, x$45, x$47, x$48, x$49, x$50), (List)new .colon.colon((Object)oldPart2.copy(x$52, x$51, x$53, x$54, x$55, x$56), (List)Nil$.MODULE$)));
                CatalogTablePartition newPart1 = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition newPart2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
                Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
                Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 == null ? some3 != null : !option3.equals(some3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
                Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                Option option4 = $org_scalatest_assert_macro_left4;
                Some some4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 == null ? some4 != null : !option4.equals(some4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
                Some x$57 = new Some((Object)newSerde);
                Option x$58 = this.utils().storageFormat().copy$default$1();
                Option x$59 = this.utils().storageFormat().copy$default$2();
                Option x$60 = this.utils().storageFormat().copy$default$3();
                boolean x$61 = this.utils().storageFormat().copy$default$5();
                Map x$62 = this.utils().storageFormat().copy$default$6();
                CatalogStorageFormat x$63 = this.utils().storageFormat().copy(x$58, x$59, x$60, (Option)x$57, x$61, x$62);
                Map x$64 = oldPart1.copy$default$1();
                Map x$65 = oldPart1.copy$default$3();
                long x$66 = oldPart1.copy$default$4();
                long x$67 = oldPart1.copy$default$5();
                Option x$68 = oldPart1.copy$default$6();
                Map x$69 = newSerdeProps;
                Option x$70 = this.utils().storageFormat().copy$default$1();
                Option x$71 = this.utils().storageFormat().copy$default$2();
                Option x$72 = this.utils().storageFormat().copy$default$3();
                Option x$73 = this.utils().storageFormat().copy$default$4();
                boolean x$74 = this.utils().storageFormat().copy$default$5();
                CatalogStorageFormat x$75 = this.utils().storageFormat().copy(x$70, x$71, x$72, x$73, x$74, x$69);
                Map x$76 = oldPart2.copy$default$1();
                Map x$77 = oldPart2.copy$default$3();
                long x$78 = oldPart2.copy$default$4();
                long x$79 = oldPart2.copy$default$5();
                Option x$80 = oldPart2.copy$default$6();
                catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)oldPart1.copy(x$64, x$63, x$65, x$66, x$67, x$68), (List)new .colon.colon((Object)oldPart2.copy(x$76, x$75, x$77, x$78, x$79, x$80), (List)Nil$.MODULE$)));
                CatalogTablePartition newPart1b = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition newPart2b = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                Option $org_scalatest_assert_macro_left5 = newPart1b.storage().serde();
                Some $org_scalatest_assert_macro_right5 = new Some((Object)newSerde);
                Option option5 = $org_scalatest_assert_macro_left5;
                Some some5 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
                Map $org_scalatest_assert_macro_left6 = newPart2b.storage().properties();
                Map $org_scalatest_assert_macro_right6 = newSerdeProps;
                Map map = $org_scalatest_assert_macro_left6;
                Map map2 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
                CatalogTablePartition badPart1 = this.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v2")})), this.utils().part1().copy$default$2(), this.utils().part1().copy$default$3(), this.utils().part1().copy$default$4(), this.utils().part1().copy$default$5(), this.utils().part1().copy$default$6());
                CatalogTablePartition badPart2 = this.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v4")})), this.utils().part2().copy$default$2(), this.utils().part2().copy$default$3(), this.utils().part2().copy$default$4(), this.utils().part2().copy$default$5(), this.utils().part2().copy$default$6());
                object = this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)badPart1, (List)new .colon.colon((Object)badPart2, (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            }
            finally {
                catalog.setCurrentDatabase("default");
            }
            return object;
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
        this.test("alter partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterPartitions("does_not_exist", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterPartitions("db2", "does_not_exist", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        this.test("basic create and list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("mydb"), false);
            catalog.createFunction("mydb", this.utils().newFunc("myfunc", this.utils().newFunc$default$2()));
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("mydb", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("create function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createFunction("does_not_exist", this.utils().newFunc()), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
        this.test("create function that already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (FunctionAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createFunction("db2", this.utils().newFunc("func1", this.utils().newFunc$default$2())), ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
        this.test("drop function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            catalog.dropFunction("db2", "func1");
            Seq $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "*");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("drop function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropFunction("does_not_exist", "something"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("drop function that does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchFunctionException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.dropFunction("db2", "does_not_exist"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        this.test("get function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1");
            CatalogFunction $org_scalatest_assert_macro_right = new CatalogFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), this.utils().funcClass(), (Seq)Nil$.MODULE$);
            CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
            CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
            return (NoSuchFunctionException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getFunction("db2", "does_not_exist"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
        this.test("get function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getFunction("does_not_exist", "func1"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.test("rename function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            String newName = "funcky";
            String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right = this.utils().funcClass();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            catalog.renameFunction("db2", "func1", newName);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.getFunction("db2", "func1"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", newName).identifier().funcName();
            String $org_scalatest_assert_macro_right2 = newName;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
            String $org_scalatest_assert_macro_left3 = catalog.getFunction("db2", newName).className();
            String $org_scalatest_assert_macro_right3 = this.utils().funcClass();
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
            return (NoSuchFunctionException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameFunction("db2", "does_not_exist", "me"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        this.test("rename function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameFunction("does_not_exist", "func1", "func5"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        this.test("rename function when new function already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createFunction("db2", this.utils().newFunc("func2", (Option<String>)new Some((Object)"db2")));
            return (FunctionAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameFunction("db2", "func1", "func2"), ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        this.test("alter function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right = this.utils().funcClass();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
            CatalogFunction qual$2 = catalog.getFunction("db2", "func1");
            String x$81 = this.utils().newFuncClass();
            FunctionIdentifier x$82 = qual$2.copy$default$1();
            Seq x$83 = qual$2.copy$default$3();
            CatalogFunction myNewFunc = qual$2.copy(x$82, x$81, x$83);
            catalog.alterFunction("db2", myNewFunc);
            String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right2 = this.utils().newFuncClass();
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createFunction("db2", this.utils().newFunc("func2", this.utils().newFunc$default$2()));
            catalog.createFunction("db2", this.utils().newFunc("not_me", this.utils().newFunc$default$2()));
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2", "not_me"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
            Set $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "func*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        this.test("create/drop database should create/delete the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db = this.utils().newDb("mydb");
            catalog.createDatabase(db, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            catalog.dropDatabase("mydb", false, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        this.test("create/drop/rename table should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db = catalog.getDatabase("db1");
            CatalogTable table = new CatalogTable(new TableIdentifier("my_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
            catalog.renameTable("db1", "my_table", "your_table");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
            catalog.dropTable("db1", "your_table", false, false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
            CatalogTable externalTable = new CatalogTable(new TableIdentifier("external_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), new CatalogStorageFormat((Option)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(externalTable, false);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"external_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
        this.test("create/drop/rename partitions should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(table, false);
            URI tableLocation = catalog.getTable("db1", "tbl").location();
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part3 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"6")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
            catalog.renamePartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)part3.spec(), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
            catalog.dropPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part2.spec(), (List)new .colon.colon((Object)part3.spec(), (List)Nil$.MODULE$)), false, false, false);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
            File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            CatalogTablePartition partWithExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"7"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"8")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partWithExistingDir, (List)Nil$.MODULE$), false);
            tempPath.delete();
            CatalogTablePartition partWithNonExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"9"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"10")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partWithNonExistingDir, (List)Nil$.MODULE$), false);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(tempPath.exists(), "tempPath.exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        this.test("drop partition from external table should not delete the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), false);
            Path partPath = new Path(catalog.getPartition("db2", "tbl1", this.utils().part1().spec()).location());
            FileSystem fs = partPath.getFileSystem(new Configuration());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            catalog.dropPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
    }
}

