/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtils {
    public static final String TEXT_XML = "text/xml; charset=utf-8";
    public static final Collection<String> fmts = new ArrayList<String>();
    public static TimeZone UTC;
    private static ThreadLocalDateFormat fmtThreadLocal;
    private static final Pattern escapePattern;

    public static Collection<ContentStream> toContentStreams(String str, String contentType) {
        if (str == null) {
            return null;
        }
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        ContentStreamBase.StringStream ccc = new ContentStreamBase.StringStream(str);
        ccc.setContentType(contentType);
        streams.add(ccc);
        return streams;
    }

    public static SolrInputDocument toSolrInputDocument(SolrDocument d) {
        SolrInputDocument doc = new SolrInputDocument();
        for (String name : d.getFieldNames()) {
            doc.addField(name, d.getFieldValue(name), 1.0f);
        }
        return doc;
    }

    public static SolrDocument toSolrDocument(SolrInputDocument d) {
        SolrDocument doc = new SolrDocument();
        for (SolrInputField field : d) {
            doc.setField(field.getName(), field.getValue());
        }
        return doc;
    }

    public static void writeXML(SolrInputDocument doc, Writer writer) throws IOException {
        writer.write("<doc boost=\"" + doc.getDocumentBoost() + "\">");
        for (SolrInputField field : doc) {
            float boost = field.getBoost();
            String name = field.getName();
            for (Object v : field) {
                if (v instanceof Date) {
                    v = ((DateFormat)fmtThreadLocal.get()).format((Date)v);
                }
                if (boost != 1.0f) {
                    XML.writeXML(writer, "field", v.toString(), "name", name, "boost", Float.valueOf(boost));
                } else {
                    XML.writeXML(writer, "field", v.toString(), "name", name);
                }
                boost = 1.0f;
            }
        }
        writer.write("</doc>");
    }

    public static String toXML(SolrInputDocument doc) {
        StringWriter str = new StringWriter();
        try {
            ClientUtils.writeXML(doc, str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str.toString();
    }

    public static Date parseDate(String d) throws ParseException, DateParseException {
        if (d.endsWith("Z") && d.length() > 20) {
            return ClientUtils.getThreadLocalDateFormat().parse(d);
        }
        return DateUtil.parseDate((String)d, fmts);
    }

    public static DateFormat getThreadLocalDateFormat() {
        return (DateFormat)fmtThreadLocal.get();
    }

    public static String escapeQueryChars(String input) {
        Matcher matcher = escapePattern.matcher(input);
        return matcher.replaceAll("\\\\$1");
    }

    public static String toQueryString(SolrParams params, boolean xml) {
        StringBuilder sb = new StringBuilder(128);
        try {
            String amp = xml ? "&amp;" : "&";
            boolean first = true;
            Iterator<String> names = params.getParameterNamesIterator();
            while (names.hasNext()) {
                String key = names.next();
                String[] valarr = params.getParams(key);
                if (valarr == null) {
                    sb.append(first ? "?" : amp);
                    sb.append(key);
                    first = false;
                    continue;
                }
                for (String val : valarr) {
                    sb.append(first ? "?" : amp);
                    sb.append(key);
                    if (val != null) {
                        sb.append('=');
                        sb.append(URLEncoder.encode(val, "UTF-8"));
                    }
                    first = false;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    static {
        fmts.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fmts.add("yyyy-MM-dd'T'HH:mm:ss");
        fmts.add("yyyy-MM-dd");
        UTC = TimeZone.getTimeZone("UTC");
        fmtThreadLocal = new ThreadLocalDateFormat();
        escapePattern = Pattern.compile("(\\W)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        DateFormat proto;

        public ThreadLocalDateFormat() {
            SimpleDateFormat tmp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            tmp.setTimeZone(UTC);
            this.proto = tmp;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.proto.clone();
        }
    }
}

