/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.settings.impl.RunModeCommand;
import org.apache.sling.settings.impl.SettingsServiceConfigurator;
import org.apache.sling.settings.impl.SlingPropertiesPrinter;
import org.apache.sling.settings.impl.SlingSettingsPrinter;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServicesListener {
    private final BundleContext bundleContext;
    private ConfigAdminListener configAdminListener;
    private ShellListener shellListener;
    private ServiceRegistration settingsReg;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        SlingSettingsServiceImpl settingsService = new SlingSettingsServiceImpl(bundleContext);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Settings Service");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.settingsReg = bundleContext.registerService(new String[]{SlingSettingsService.class.getName()}, (Object)settingsService, props);
        SlingPropertiesPrinter.initPlugin(bundleContext);
        SlingSettingsPrinter.initPlugin(bundleContext, settingsService);
        this.configAdminListener = new ConfigAdminListener(settingsService);
        this.configAdminListener.start();
        this.shellListener = new ShellListener(settingsService);
        this.shellListener.start();
    }

    public void deactivate() {
        if (this.shellListener != null) {
            this.shellListener.deactivate();
            this.shellListener = null;
        }
        if (this.configAdminListener != null) {
            this.configAdminListener.deactivate();
            this.configAdminListener = null;
        }
        if (this.settingsReg != null) {
            this.settingsReg.unregister();
            this.settingsReg = null;
        }
        SlingSettingsPrinter.destroyPlugin();
        SlingPropertiesPrinter.destroyPlugin();
    }

    private final class ShellListener
    extends AbstractListener {
        private Object runModeCommand;
        private final SlingSettingsServiceImpl settings;

        public ShellListener(SlingSettingsServiceImpl settings) {
            super("org.apache.felix.shell.ShellService");
            this.settings = settings;
        }

        @Override
        protected void serviceChanged() {
            if (this.getService() != null && this.runModeCommand == null) {
                this.runModeCommand = new RunModeCommand(ServicesListener.this.bundleContext, this.settings.getRunModes());
            }
        }

        @Override
        public void deactivate() {
            super.deactivate();
            if (this.runModeCommand != null) {
                ((RunModeCommand)this.runModeCommand).destroy();
                this.runModeCommand = null;
            }
        }
    }

    private final class ConfigAdminListener
    extends AbstractListener {
        private Object settingsServiceConfigurator;
        private final SlingSettingsServiceImpl settings;

        public ConfigAdminListener(SlingSettingsServiceImpl settings) {
            super("org.osgi.service.cm.ConfigurationAdmin");
            this.settings = settings;
        }

        @Override
        protected void serviceChanged() {
            if (this.getService() != null && this.settingsServiceConfigurator == null) {
                this.settingsServiceConfigurator = new SettingsServiceConfigurator(ServicesListener.this.bundleContext, this.settings);
            }
        }

        @Override
        public void deactivate() {
            super.deactivate();
            if (this.settingsServiceConfigurator != null) {
                ((SettingsServiceConfigurator)this.settingsServiceConfigurator).destroy();
                this.settingsServiceConfigurator = null;
            }
        }
    }

    private abstract class AbstractListener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference reference;
        private volatile Object service;

        public AbstractListener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occurred.", ise);
            }
            this.retainService();
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        this.serviceChanged();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                this.serviceChanged();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService();
            }
        }

        protected abstract void serviceChanged();
    }
}

