/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.welink;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeLinkHookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeLinkHookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private final AlarmRulesWatcher alarmRulesWatcher;
    private final RequestConfig requestConfig;

    public WeLinkHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    public void doAlarm(List<AlarmMessage> alarmMessages) {
        if (this.alarmRulesWatcher.getWeLinkSettings() == null || this.alarmRulesWatcher.getWeLinkSettings().getWebhooks().isEmpty()) {
            return;
        }
        WeLinkSettings welinkSettings = this.alarmRulesWatcher.getWeLinkSettings();
        welinkSettings.getWebhooks().forEach(webHookUrl -> {
            String accessToken = this.getAccessToken((WeLinkSettings.WebHookUrl)webHookUrl);
            alarmMessages.forEach(alarmMessage -> {
                String content = String.format(Locale.US, this.alarmRulesWatcher.getWeLinkSettings().getTextTemplate(), alarmMessage.getAlarmMessage());
                this.sendAlarmMessage((WeLinkSettings.WebHookUrl)webHookUrl, accessToken, content);
            });
        });
    }

    private void sendAlarmMessage(WeLinkSettings.WebHookUrl webHookUrl, String accessToken, String content) {
        JsonObject appServiceInfo = new JsonObject();
        appServiceInfo.addProperty("app_service_id", "1");
        appServiceInfo.addProperty("app_service_name", webHookUrl.getRobotName());
        JsonArray groupIds = new JsonArray();
        Arrays.stream(webHookUrl.getGroupIds().split(",")).forEach(arg_0 -> ((JsonArray)groupIds).add(arg_0));
        JsonObject body = new JsonObject();
        body.add("app_service_info", (JsonElement)appServiceInfo);
        body.addProperty("app_msg_id", UUID.randomUUID().toString());
        body.add("group_id", (JsonElement)groupIds);
        body.addProperty("content", String.format(Locale.US, "<r><n></n><g>0</g><c>&lt;imbody&gt;&lt;imagelist/&gt;&lt;html&gt;&lt;![CDATA[&lt;DIV&gt;%s&lt;/DIV&gt;]]&gt;&lt;/html&gt;&lt;content&gt;&lt;![CDATA[%s]]&gt;&lt;/content&gt;&lt;/imbody&gt;</c></r>", content, content));
        body.addProperty("content_type", (Number)0);
        body.addProperty("client_app_id", "1");
        this.sendPostRequest(webHookUrl.getMessageUrl(), Collections.singletonMap("x-wlk-Authorization", accessToken), body.toString());
    }

    private String getAccessToken(WeLinkSettings.WebHookUrl webHookUrl) {
        String accessTokenUrl = webHookUrl.getAccessTokenUrl();
        String clientId = webHookUrl.getClientId();
        String clientSecret = webHookUrl.getClientSecret();
        String response = this.sendPostRequest(accessTokenUrl, Collections.emptyMap(), String.format(Locale.US, "{\"client_id\":%s,\"client_secret\":%s}", clientId, clientSecret));
        Gson gson = new Gson();
        JsonObject responseJson = (JsonObject)gson.fromJson(response, JsonObject.class);
        return Optional.ofNullable(responseJson).map(r -> r.get("access_token")).map(JsonElement::getAsString).orElse("");
    }

    private String sendPostRequest(String url, Map<String, String> headers, String requestBody) {
        String response = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(url);
            post.setConfig(this.requestConfig);
            post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
            post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
            headers.forEach((arg_0, arg_1) -> ((HttpPost)post).setHeader(arg_0, arg_1));
            StringEntity entity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);){
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null) {
                    if (statusLine.getStatusCode() != 200) {
                        log.error("send to {} failure. Response code: {}, Response content: {}", new Object[]{url, statusLine.getStatusCode(), EntityUtils.toString((HttpEntity)httpResponse.getEntity())});
                    } else {
                        response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    }
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }
}

